/*
dirfix.cmd - reset archive attribute on directories
Copyright 1999 by Chuck McKinnis,  Sandia Park, NM (USA)
mckinnis@ibm.net
*/

Trace 'N'

Parse Upper Arg drives test .

If drives = 'TEST' Then
   Parse Upper Arg test drives .

If Abbrev(test, 'TEST') Then
   test = 1
Else
   test = 0

If drives = '' Then Do
   Say 'Report on and reset directory entries'
   Say '   that have the archive bit set on'
   Say ''
   Say 'Usage - dirfix x: | all [test]'
   Say '   test - just report the findings'
   Return
   End

If RxFuncQuery('SysLoadFuncs') Then
   Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', sysfuncs.i
Call SysLoadFuncs

If drives = 'ALL' Then
   drives = SysDriveMap(, 'LOCAL')
Else
   If Lastpos(':', drives) <> Length(drives) Then
      drives = drives || ':'

tst_attrib = '++***'
chg_attrib = '-****'

if test Then
   chg_attrib = '*****'

Do i = 1 To Words(drives)
   Parse Value SysDriveInfo(Word(drives, i)) With drive free total . 
   If (drive <> Word(drives, i)) | (free = total) | (free = 0) Then
      Iterate i
   drive = drive || '\'
   rc = SysFileTree(drive, 'dirs.', 'DSO', tst_attrib, chg_attrib)
   If dirs.0 > 0 Then
      Do j = 1 To dirs.0
         Say 'Archive bit set on in' dirs.j
      End
   Else
      Say 'No archive bits found set in directories on' drive
   If \test Then
      Do
         If dirs.0 = 1 Then
            Say dirs.0 'directory cleared on' drive
         Else
            Say dirs.0 'directories cleared on' drive
      End
End
Return
