/* xinit.cmd
    This is a sample XINIT.CMD file which starts PMX server.
 
    It requires the environment variables XFILES and HOSTNAME
    to be set up during TCP/IP installation.
 
    The following national language keyboard definitions are being distributed.
    They are copied unchanged from RS/6000 AIX 3.1 and AIX 3.2.
    You can choose which AIX version of the keyboard definition files get
    used by setting the optional PMXUNIX OS/2 environment variable:
       set PMXUNIX=AIX3.1
       or
       set PMXUNIX=AIX3.2      <== the default if PMXUNIX is not set
 
    Set the OS/2 environment variable LANG with the desired national keyboard.
    For example, if you want the Italian keyboard definition, you could
    add the following line to your CONFIG.SYS file.  LANG defaults to
    US English if it is not found in the OS/2 environment.
       set LANG=it_IT
 
     Language            LANG=value       Language            LANG=value
     --------            ----------       --------            ----------
     Belgian             nl_BE            Latin Amer. Spanish es_LA
     Belgian French      fr_BE            Norwegian           no_NO
     Canadian French     fr_CA            Portuguese          pt_PT
     Danish              da_DK            Spanish             es_ES
     Dutch               nl_NL            Swedish             sv_SV
     Finnish             fi_FI            Switzerland French  fr_CH
     French              fr_FR            Switzerland German  de_CH
     German              de_DE            Turkish             tr_TR
     Greek               el_GR            United Kingdom      en_GB
     Icelandic           is_IS            United States       en_US
     Italian             it_IT
     Japanese            ja_JP
     Japanese English    en_JP
 
     An optional PMXKEYBOARD OS/2 environment variable can be set to select
     the type of keyboard that PMX uses.  This environment variable is only
     important when LANG=ja_JP, since there are three different Japanese
     keyboards available.
 
     PMX supports the following keyboards:
 
     Keyboard type                 PMXKEYBOARD= or '-k' flag value
     ----------------------------  -------------------------------
     101 key                       101
     102 key                       102
     Japanese 5576-A01 (106 keys)  5576-A01 or 5576A01 or 106A <== LANG=Ja_JP default
     Japanese 5576-001 (124 keys)  5576-001 or 5576001 or 124
     Japanese 5576-002 (106 keys)  5576-002 or 5576002 or 106
 
     User-Access control:
     xinit now supports the OPTIONAL parameter
        [-usraccess]
           If -usraccess is supplied, a random value will be added to
           the Xauthor.ity file (on the OS/2-PMX machine).
 
.....................................................................
If some of this information scrolled off the top of your screen try:
   xinit ? | more
or
   xinit ? > xinit.doc
   e xinit.doc
.....................................................................
###
*/
trace o
 
  parse arg args
 
  JaJPdefaultKeyboard = '5576-A01'
 
  /*
   *   Provide XINIT HELP text
   */
  if args='?' | args='-h' | args='/h' then
     do
     i = 2
     help = sourceline(i)
     do while help <> '###'
        say help
        i = i+1
        help = sourceline(i)
        end /*dowhile*/
     exit 0
     end /*endif*/
 
 /*
  *  Check to see if PMX is already running:
  */
  'pmxwait -q 0'    /* See if the server is running */
 
  if rc = 0 then
     do
     /* PMX is already running! */
     say "PMX is already running! PMXWAIT rc=" rc
     exit 2
     end
 
  /*
   *  if there is a PMXFLAGS environment variable, then prefix args with it:
   */
  pmxflags = VALUE('PMXFLAGS',,'OS2ENVIRONMENT')
  args = pmxflags args
  /*
   *  Process the *required* XFILES and HOSTNAME enviornment variables:
   */
  XFiles =  VALUE('XFILES',,'OS2ENVIRONMENT')
  if XFiles = '' then
    do
    say "XFILES environment variable is not defined. PMX is not started!"
    exit 1
    end
  Hostname =  VALUE('HOSTNAME',,'OS2ENVIRONMENT')
  if Hostname = '' then
    do
    say "HOSTNAME environment variable is not defined. PMX is not started!"
    exit 1
    end
 
  /* Create a DISPLAY environment variable: */
  DISPLAY = Hostname || ':0'
  'set DISPLAY=' || DISPLAY
 
  /*
   *  Process the -pmx flag or the PMXVERSION environment variable:
   */
  if (0<>WORDPOS( '-pmx' , args )) then
     do
     pmxPos     = WORDPOS( '-pmx' , args )
     pmxVersion = SUBWORD( args , pmxPos+1 , 1 )
     args       = DELWORD( args , pmxPos , 2 )
     end /*if WORDPOS*/
  else
     do
     pmxVersion = VALUE('PMXVERSION',,'OS2ENVIRONMENT')
     if pmxVersion = '' then pmxVersion='PMX.EXE'
     end /*if WORDPOS else*/
 
  /*
   *  Process the -lang flag or the LANG environment variable:
   */
  lang=''
  if (0<>WORDPOS( '-lang' , args )) then
     do
     langPos = WORDPOS( '-lang' , args )
     lang    = SUBWORD( args , langPos+1 , 1 )
     args    = DELWORD( args , langPos , 2 )
     end /*if WORDPOS*/
  else
    if (0=WORDPOS('-ignoresavedsettings', args)) then
      do forever
        lang = ''
        ini_path=VALUE('ETC',,'OS2ENVIRONMENT')
        if ini_path='' then leave
        ini_path = ini_path || '\PMX.INI'
        ini_path = stream(ini_path,'c','QUERY EXISTS');
        if ini_path='' then leave
        RC=RXFUNCQUERY('SysIni')
        if (RC<>0) then do
          RC=RXFUNCADD('SysIni','REXXUTIL','SysIni')
          if (RC<>0) then leave
        end
        lang=STRIP(SysIni(ini_path,'Notebook1','language'), 't', '00'x)
        /* say xx||lang||xx */
        if ((lang='') | (lang = 'ERROR') | (lang = 'ERROR:')) then do
          lang=''
          leave
        end
        leave
      end
 
  if (lang='') then do
     lang = VALUE('LANG',,'OS2ENVIRONMENT')
                /*** Modify 'En_US' below to have a different default keyboard ***/
     if lang = '' then lang='En_US'
  end /* if lang='' */
 
  lang = translate(lang)
  /*
   *  Allow LANG shortcut:  translate "jajp" to "Ja_JP"
   *                        translate  XPG4 format to PMX format
   */
  if pos("_",lang)=3 & length(lang)=5
  then nop     /* do nothing because its alreay in PMX format */
  else         /* translate from XPG4 format to PMX format    */
     do
       lang = substr( lang , 1 , 2 ) || "_" || substr( lang , 3 , 2 )
       if lang="SV_SE"
       then lang="SV_SV"
     end
 
  /*
   *  Check to see if "-k" flag appears in the XINIT args
   */
  if (0<>WORDPOS( '-k' , args )) then
     kbdopt = ''
  else
     do
       kbdopt = translate(VALUE('PMXKEYBOARD',,'OS2ENVIRONMENT'))
       if kbdopt<>'' then
          kbdopt = '-k' kbdopt
       else
          do
            /*
             *  Check INI file for keyboard type.
             *  If it is not found, then
             *  Infer keyboard type from LANG setting
             */
            if (0=WORDPOS('-ignoresavedsettings', args)) then
              do forever
                ini_path=VALUE('ETC',,'OS2ENVIRONMENT')
                if ini_path='' then leave
                ini_path = ini_path || '\PMX.INI'
                ini_path = stream(ini_path,'c','QUERY EXISTS');
                if ini_path='' then leave
                RC=RXFUNCQUERY('SysIni')
                if (RC<>0) then do
                  RC=RXFUNCADD('SysIni','REXXUTIL','SysIni')
                  if (RC<>0) then leave
                end
                kbdopt=STRIP(SysIni(ini_path,'Notebook1','Keyboard'), 't', '00'x)
                /* say xx||kbdopt||xx */
                if ((kbdopt='') | (kbdopt = 'ERROR:')) then do
                  kbdopt=''
                  leave
                end
                if (kbdopt='107') then do
                   kbdopt = '106A'
                end
                kbdopt='-k' kbdopt
                leave
              end /* end do forever */
 
            if kbdopt='' then do
              select
                when lang = 'EN_US' then
                   kbdopt = '-k 101'
                when lang = 'JA_JP' | lang = 'EN_JP' then
                   kbdopt = '-k' JaJPdefaultKeyboard
                otherwise
                   kbdopt = '-k 102'
              end /* end select */
            end /* if kbdopt='' */
          end /*if kbdopt<>''*/
     end /*if WORDPOS*/
 
  /*
   *  Process the PMXUNIX environment variable or the "-unix" flag:
   */
  if (0<>WORDPOS( '-unix' , args )) then
     do
     unixPos = WORDPOS( '-unix' , args )
     unix    = SUBWORD( args , unixPos+1 , 1 )
     args    = DELWORD( args , unixPos , 2 )
     end /*if WORDPOS*/
  else
     unix = VALUE('PMXUNIX',,'OS2ENVIRONMENT')
 
  unix = translate(unix)
  select
  when unix = 'AIX3.1' then keyboardSuffix = '._31'
  when unix = 'AIX3.2' then keyboardSuffix = ''
     /*
      * -- you may wish to add other unix types here:
      *    ... be sure to copy the correct keyboard.??? files over
      *        to \tcpip\x11\defaults\xmodmap\??_?? subdirectories
      * eg:
      *  when unix = 'SUNx.x' then keyboardSuffix = '.SUN'
      */
  otherwise                    keyboardSuffix = '' /* PMXUNIX default is AIX3.2 */
  end /*select*/
 
  /*
   * Check to see if the keyboard file exists; if not issue error
   */
  if stream(XFiles'\DEFAULTS\XMODMAP\'lang'\keyboard'keyboardSuffix,,
            'c','QUERY EXISTS')=''
  then
    do
      say "Language is not supported by PMX. PMX is not started!"
      exit 3
    end
 
  /*
   * User-based Access control - Process the "-usraccess" flag
   */
  if (0<>WORDPOS( '-usraccess' , args )) then
     do
       /* remove it from the list of args */
     usraccessPos = WORDPOS( '-usraccess' , args )
     args    = DELWORD( args , usraccessPos , 1 )
       /* generate and save random hex key */
     randomkey = RANDOM(0, 100000, TIME('S'))
     randomkey = D2X(randomkey, 8)
     "call " xauth 'add' DISPLAY '.' randomkey
     end  /*if WORDPOS*/
 
  'START' pmxVersion args kbdopt
 
  'pmxwait -v 60'    /* wait until the server is running */
 
  if rc <> 0 then
     do
     /* PMX is not running! */
     say "XINIT Failure: PMX does not seem to be running! PMXWAIT rc=" rc
     exit 2
     end
 
  'xmodmap 'XFiles'\DEFAULTS\XMODMAP\'lang'\keyboard'keyboardSuffix
 
  /*
   * Uncomment the following line if you want host machines *NOT*
   * appearing in \tcpip\etc\x0hosts to connect to PMX
   */
  /* 'xhost +' */   /* DISABLE PMX access control */
 
  /*
   * At this point, call xinitrc.cmd from the %etc% directory.  You can put
   * any user-specific configuration in that file.  That way, you won't
   * have to modify xinit.cmd.
   */
   do forever
     xinitrc_path=VALUE('ETC',,'OS2ENVIRONMENT')
     if xinitrc_path='' then leave
     xinitrc_path = xinitrc_path || '\XINITRC.CMD'
     xinitrc_path = stream(xinitrc_path,'c','QUERY EXISTS');
     if xinitrc_path='' then leave
     "call" xinitrc_path
     leave
   end
