/* This small program imports RemoteAccess' (and others) LASTCALL.BBS
   into BT-XE's history file */
/* by C.F.S., 2:341/70 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

typedef unsigned short word;
typedef unsigned char byte;

typedef struct _ADDRESS
{
    word Zone;
    word Net;
    word Node;
    word Point;
    char *Domain;
} ADDR, *ADDRP;

#include "..\..\include\history.h"

struct /* Lastcall */
{
    byte line;
    char pasname[36];
    char pashandle[36];
    char pascity[26];
    word baud;
    long times;
    char paslogon[6];
    char paslogoff[6];
    byte attribute;
} lastcall;

char *pas2c (char *s)
{
    char c;
    c=s[0];
    memmove (s,s+1,c);
    s[c]=0;
    return s;
}

char *pack (char *s)
{
    printf ("In: %s\n",s);
    while (*s==' ' || *s=='\n' || *s=='\r')
        strcpy (s,s+1);
    while (s[strlen (s)-1]==' ' || s[strlen (s)-1]=='\n' || s[strlen (s)-1]=='\r')
        s[strlen (s)-1]=0;
    return s;
}

int main (int argc,char **argv)
{
    CALLHIST rec;
    FILE *in, *out;
    char *x1,*x2,l1[7],l2[7];
    time_t curtime;
    long calc,len;
    unsigned task;
    char line[160];
    time (&curtime);
    printf ("RemoteAccess to BT-XE, 0.1b, by C.F.S., 2:341/70 - Part of the BT-XE package\n");
    printf ("----------------------------------------------------------------------------\n");
    if (argc!=4)
    {
        printf ("Usage: GETRA task_number bgfax_log_file btxe_history_file\n");
        printf ("Example: GETRA 2 P:\\RA\\LASTCALL.BBS P:\\BTXE\\TASK\\CALLHIST.ALL\n\n");
        exit (1);
    }
    task=atoi (argv[1]);
    in=fopen (argv[2],"rb");
    if (in==NULL)
    {
        printf ("Failed to open input file %s\n",argv[1]);
        exit (2);
    }
    fseek (in,-sizeof (lastcall),SEEK_END);
    fread (&lastcall,1,sizeof (lastcall),in);
    fclose (in);
    pas2c (lastcall.pasname);
    pas2c (lastcall.pashandle);
    pas2c (lastcall.pascity);
    pas2c (lastcall.paslogon);
    pas2c (lastcall.paslogoff);
    rec.task=task;
    rec.outgoing=0;
    rec.calltype=CT_BBS;
    rec.subclass=SC_LASTCALL;
    strcpy (l1,lastcall.paslogon);
    strcpy (l2,lastcall.paslogoff);
    *(x1=strchr (l1,':'))=0;
    *(x2=strchr (l2,':'))=0;
    calc=atoi (l2)*3600+atoi (x2+1)*60;
    calc-=atoi (l1)*3600+atoi (x1+1)*60;
    rec.length=calc;
    rec.starttime=curtime-rec.length;
    memcpy (&rec.h.b1,&lastcall,sizeof (lastcall));
    out=fopen (argv[3],"a+b");
    if (out==NULL)
    {
        printf ("Unable to open output file %s\n",argv[3]);
        exit (3);
    }
    fwrite (&rec,1,sizeof (CALLHIST),out);
    fclose (out);
    printf ("Done.\n");
    return 0;
}
