
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <dos.h>
#include <direct.h>
#include <share.h>
#include <sys\types.h>
#include <sys\stat.h>

int incoming=0;
char sys[256]="";
char ourname[256]="";



char           *waffle_munger(char *str, char *sys, char *ourname);

void checkcline(char *filename,char *cline)
{
 char tempname[256];
 char namehere[256];
 struct stat buf;

 if (!*filename)
   return;
 strcpy(tempname,filename);
 strcpy(namehere,waffle_munger(tempname,sys,ourname));
 if (!incoming) strcat(namehere,"at");

 printf("%-12s ",namehere);
 if (stat(namehere,&buf)!=-1) 
    printf("%7lu %s\n",buf.st_size,cline);
  else 
    printf("Error finding file (either missing or settings are wrong)\n");
}

void process(char *s)
{
 FILE *file;
 static char  line[256];
 static char  cline[256]="";
 static char  iline[256]="";
 static char  fline[256]="";

 char *command,*parms;
 int err=0;


 file=_fsopen(s,"rt",SH_DENYRW);
 if (!file) return;
 while(!feof(file))
  {
    line[0]=0;
    fgets(line,sizeof(line),file);
    if (!line[0]) continue;
    if (line[0]=='\n') continue;

    command=strtok(line," \n");
    parms=strtok(NULL,"\n"); // remaineder

    switch(*command) {
    case 'C' : if (parms) strcpy(cline,parms); break;
    case 'I' : if (parms) strcpy(iline,parms); break;
    case 'F' : if (parms) strcpy(fline,parms); break;
    }
  }
 fclose(file);

 if (cline[0])
   checkcline(iline[0]?iline:fline,cline);

}


void showhelp(void)
{
 printf("Usage:   GUUQ [in/out] remotename ourname\n"
        "         where remotename and ourname are the uucp names used for spooling\n");
 if (getenv("MYSITE")) if (getenv("MYFEED")) exit(0);

 printf("\nYou may also set the following in your environment settings..\n");
 if (!getenv("MYSITE"))
   printf("SET MYSITE=wmeonlin  (subsitute YOUR site's UUCP name from your gateway configs\n");
 if (!getenv("MYFEED"))
   printf("SET MYFEED=hostname  (subsitute your FEED'S UUCP name from your gateway configs\n");
 exit(0);
}

int main(int argc, char *argv[])
{
 char *p;
 sys[0]=0;
 ourname[0]=0;
 DIR *dirp;
 struct dirent *direntp;

 if ((p=getenv("MYSITE"))!=NULL) strcpy(ourname,p);
 if ((p=getenv("MYFEED"))!=NULL) strcpy(sys,p);

 if (argc>1)
  {
   if (stricmp(argv[1],"in")==NULL) incoming=1;
   else if (stricmp(argv[1],"out")==NULL) incoming=0;
   else showhelp();
   }
    else incoming=0;

 if (argc>2) strcpy(sys,argv[2]);
 if (argc>3) strcpy(ourname,argv[3]);

 if (!ourname[0]) showhelp();
 if (!sys[0]) showhelp();
   fprintf(stderr,"GUUQ Copyright 1994 by Jason Fesler.  All rights reserved.\n");

      if (incoming) {
         printf("Data File       Size Command                           *.X    (Inbound)\n");
         printf("---------------+----+--------------------------------------------------\n");
         dirp = opendir("*.X");
      } else {
         printf("Data File       Size Command                           *.XQT  (Outbound)\n");
         printf("---------------+----+---------------------------------------------------\n");
         dirp = opendir("*.XQT");
      } /* endif */

      if (dirp == NULL) {
         } else {
          for (;;) {
          direntp = readdir(dirp);
          if (direntp==NULL) break;
          process(direntp->d_name);
         }
        closedir(dirp);
      } /* endif incoming */
   return 0;
}


