
/*////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  Maximus IPC Creator                                                     //
//  Copyright 1991 by Peter G. Zion.  All rights reserved.                  //
//  Source code may be freely distributed as long as copyright message is   //
//  not removed from this file or the compiled executable.                  //
//                                                                          //
//  Please send OS/2 source updates to 1:157/535.                           //
//                                                                          //
//  minor change to creat() by Bill Bond 1:325/118, 8/11/92 on this date    //
//  1:157/535 was not in the nodelist.                                      //
//                                                                          //
//                                                                          //
////////////////////////////////////////////////////////////////////////////*/


#define INCL_DOS
//#include <os2.h>


#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys\types.h>
#include <sys/stat.h>

#include <share.h>
/*  #include <mem.h>  */
#include <stdlib.h>
#include <string.h>

struct Ipc {

  int avail;
  char username[36];
  char status[80];
  unsigned msgs_waiting;
  unsigned long next_msgofs;
  unsigned long new_msgofs;

};

void Write( struct Ipc *ipc, int node ) {
  
  int fp;
  char filename[13] = "IPC00.BBS";
  
  filename[3] = node>>4;
  if( filename[3] > 9 )
    filename[3] += 'A' - 10;
  else
    filename[3] += '0';
  filename[4] = (node&15);
  if( filename[4] > 9 )
    filename[4] += 'A' - 10;
  else
    filename[4] += '0';
  if( (fp = creat( filename, S_IREAD | S_IWRITE)) == -1 ) {
    puts( "Error: Unable to open file for output.\n\r" );
    setmode( fp, O_BINARY );
    return;
  }
  
  write( fp, ipc, sizeof( struct Ipc ) );
  
  close( fp );
  
} 

void Ipc( struct Ipc *ipc, int node, char *name, char *stat, int av ) {

  memset( ipc, 0, sizeof( struct Ipc ) );
  strncpy( ipc->username, name, 35 );
  strncpy( ipc->status, stat, 79 );
  ipc->avail = av;
  Write( ipc, node );

}

void main( int argc, char *argv[] ) {
    
  struct Ipc ipc;
  char *user, *status;
  int node;

  puts( "\nMaximus IPC creator -- by Peter G. Zion\nCopyright 1991.  All rights reserved.\n" );
    
    if( argc != 4 ) {
    puts( "Usage:\n\tIPC <node number> <user to list> <status>\n\nExample:\n\tIPC 1 \"Mailer\" \"Waiting for call\"");
        return;
    }
    
  node = atoi( argv[1] );
  user = argv[2];
  status = argv[3];
    
  Ipc( &ipc, node, user, status, 0 );

  puts( "Done!" );

}
