/*# name=Compiler-determination and memory-model-determination routines
    name=Support for WATCOM C (DOS, OS/2 and 386 flat), Microsoft C
    name=(all memory models, DOS & OS/2), Turbo C 2.0, Turbo/Borland C++
    name=and IBM C Set/2 (flat model).
*/

/* Non-DOS systems...  Just do a "#define __FARCODE__",                     *
 * "#define __FARDATA__" and "#define __LARGE__" in place of this file.     */

#ifndef __COMPILER_H_DEFINED
#define __COMPILER_H_DEFINED

#ifdef __IBMC__
#define OS_2
#include <os2def.h>
#endif

  #define __FLAT__
  #define __386__
  #define __POSIX__

  /* Other macros may get defined by braindead compilers */

#ifdef __SMALL__
  #undef __SMALL_
#endif

#ifdef __TINY__
  #undef __TINY__
#endif

#ifdef __MEDIUM__
  #undef __MEDIUM__
#endif

#ifdef __COMPACT__
  #undef __COMPACT__
#endif

#ifdef __LARGE__
  #undef __LARGE__
#endif

#ifdef __HUGE__
  #undef __HUGE__
#endif

/* Code is really "near", but "far" in this context means that we want    *
 * a 32 bit ptr (vice 16 bit).                                            */

#define __FARCODE__
#define __FARDATA__

/* Everything should be "near" in the flat model */

#ifdef far
  #undef far
#endif

#ifdef near
  #undef near
#endif

#ifdef huge
  #undef huge
#endif

#define far
#define near
#define huge

/* Since we're using flat model OS/2, we never need to load DS */

#ifdef _loadds
  #undef _loadds
#endif

#ifdef __loadds
  #undef __loadds
#endif

#define _loadds
#define __loadds

  #define _stdc
  #define _vstdc
  #define _intr
  #define _intcast
  #define _veccast
  #define _fast
  #define _loadds
  #define _export

  #define pascal
  #define cdecl
  #define far
  #define near

  #define OS2FAR
#ifdef __IBMC__
  #define MAPIENTRY _System
#else
  #define EXPENTRY
  #define MAPIENTRY
#endif

  #define NW(var) (void)var

int _fast lock(int fh, long offset, long len);
int _fast unlock(int fh, long offset, long len);

#ifndef __TYPEDEFS_H_DEFINED
#include "typedefs.h"
#endif

#endif /* ! __COMPILER_H_DEFINED */

