#ifndef __STAMP_H_DEFINED
#define __STAMP_H_DEFINED
#pragma pack(1)

#include "typedefs.h"

#ifdef __IBMC__
  struct _stamp   /* DOS-style datestamp */ {
    struct { dword da : 5; dword mo : 4; dword yr : 7; } date;
    struct { dword ss : 5; dword mm : 6; dword hh : 5; } time;
  };
#else
  struct _stamp   /* DOS-style datestamp */ {
    struct { word da : 5; word mo : 4; word yr : 7; } date;
    struct { word ss : 5; word mm : 6; word hh : 5; } time;
  };
#endif

struct _dos_st {
  word date;
  word time;
};

/* Union so we can access stamp as "int" or by individual components */

union stamp_combo {
  dword          ldate;
  struct _stamp  msg_st;
  struct _dos_st dos_st;
};

typedef union stamp_combo SCOMBO;

#endif /* __STAMP_H_DEFINED */

