#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
//#include <unistd.h>
#include "func.h"

int split_files( char *filename , unsigned long int _s)
{
    FILE            *fp_orig,
                    *fp_split;

    unsigned
        long int    orig_pos, orig_size,
                    split_pos, split_size,
                    i, n,
                    bytes_left;

    int             filenr,
                    pieces,
               bytes_read,
               allow_read;

    struct stat     *buf;
    char            *c_byte,
                    *split_fname,
                    *orig_fname,
               *split_sfname;


    i = n = 0;
    orig_pos = orig_size = 0;
    split_pos = split_size = 0;
    filenr = 1;


    buf = (struct stat*)malloc(sizeof(struct stat*));
    c_byte = (char*)malloc(sizeof(char*)*BUFFERSIZE);
    split_fname = (char*)malloc(sizeof(char*) * 200);
    orig_fname = (char*)malloc(sizeof(char*) * 200);

    strcpy(orig_fname,filename);

    stat(orig_fname,buf);
    orig_size = buf->st_size;

   if (_s >= orig_size)
      {
      printf("Splitted filesize is same as size of the filename!\n"
         "Try using cp(1) instead...\n");
      exit(0);
      }

   fp_orig = fopen(orig_fname,"rb");

   if (fp_orig == NULL)
      {
      perror("error opening input file");
      return -1;
      }

   split_size = _s;

   bytes_left = orig_size;

   orig_fname = strip_path( orig_fname );

   pieces = orig_size / split_size;
   if ((orig_size % split_size) > 0)
      pieces++;

   if (pieces > 999)
      {
      printf("You will be ending up with over %d files, and I "
         "cannot handle more than 999... Perhaps you "
         "could choose a bigger output size?\n");
      exit(0);
      }

   printf("Splitting %s into %d pieces.\n",orig_fname, pieces);

   while (orig_pos < orig_size)
      {
      sprintf(split_fname,"%s.%03d",orig_fname,filenr);

      fp_split = fopen(split_fname,"wb");
      if (fp_split == NULL)
         {
         perror("error opening output file");
         return -1;
         }

      split_pos = 0;

      split_sfname = shorten_path(split_fname);

      printf("%s\t\t\t%d bytes\n",split_sfname,split_size);
      bytes_read = 0;
      allow_read = BUFFERSIZE;

      while (split_pos < split_size)
         {
         if ((split_pos+allow_read)-1 - split_size < BUFFERSIZE)
            allow_read = split_size % BUFFERSIZE;

         bytes_read = fread(c_byte, 1, allow_read, fp_orig);
         fwrite(c_byte, 1, bytes_read, fp_split);

         orig_pos+=bytes_read;
         split_pos+=bytes_read;
         if (feof(fp_orig))
            {
            if (split_pos != split_size)
               printf("EOF reached on input and bytes_read=%d\n", bytes_read);
            break;
            }
         if (ferror(fp_orig))
            {
            printf("Ouch: errno = %d", errno);
            break;
            }
#ifdef DEBUG
         printf("split pos:\t%d\n",split_pos);
         printf("split size:\t%d\n",split_size);
         printf("allow_read:\t%d\n",allow_read);
         sleep(1);
#endif
         }

      bytes_left -= split_size;

      if (bytes_left < split_size)
         split_size = bytes_left;

      filenr++;

      fclose(fp_split);
      }

    fclose(fp_orig);

    return 0;
    }

