NAME
     tar - process tape archives

SYNOPSIS
     tar -c[bfvw] device block filename...
     tar -r[bvw] device block [filename...]
     tar -t[fv] device
     tar -u[bvw] device block
     tar -x[flmovw] device [filename...]

DESCRIPTION
     Tar reads and writes archive files which conform to the
     Archive/Interchange File Format specified in IEEE Std.
     1003.1-1988.

     Options
     The following options are available:

     -c        Creates a new archive; writing begins at the
               beginning of the archive, instead of after the
               last file.

     -r        Writes names files to the end of the archive.

     -t        Lists the names of all of the files in the
               archive.

     -u        Causes named files to be added to the archive if
               they are not already there, or have been modified
               since last written into the archive.  This implies
               the -r option.

     -x        Extracts named files from the archive.  If a named
               file matches a directory whose contents had been
               written onto the archive, that directory is recur-
               sively extracted.  If a named file in the archive
               does not exist on the system, the file is create
               with the same mode as the one in the archive,
               except that the set-user-id and get-group-id modes
               are not set unless the user has appropriate
               privileges.

     If the files exist, their modes are not changed except as
     described above.  The owner, group and modification time are
     restored if possible.  If no filename argument is given, the
     entire contents of the archive is extracted.  Note that if
     several files with the same name are in the archive, the
     last one will overwrite all earlier ones.

     -b        Causes tar to use the next argument on the command
               line as the blocking factor for tape records.  The
               default is 1; the maximum is 20.  This option
               should only be used with raw magnetic tape
               archives.  Normally, the block size is determined
               automatically when reading tapes.

     -f        Causes tar to use the next argument on the command
               line as the name of the archive instead of the
               default, which is usually a tape drive.  If - is
               specified as a filename tar writes to the standard
               output or reads from the standard input, whichever
               is appropriate for the options given.  Thus, tar
               can be used as the head or tail of a pipeline.

     -l        Tells tar to report if it cannot resolve all of
               the links to the files being archived.  If -l is
               not specified, no error messages are written to
               the standard output.  This modifier is only valid
               with the -c, -r and -u options.

     -m        Tells tar not to restore the modification times.
               The modification time of the file will be the time
               of extraction.  This modifier is invalid with th
               -t option.

     -o        Causes extracted files to take on the user and
               group identifier of the user running the program
               rather than those on the archive.  This modifier
               is only valid with the -x option.

     -v        Causes tar to operate verbosely.  Usually, tar
               does its work silently, but the v modifier causes
               it to print the name of each file it processes,
               preceded by the option letter.  With the -t
               option, v gives more information about the archive
               entries than just the name.

     -w        Causes tar to print the action to be taken, fol-
               lowed by the name of the file, and then wait for
               the user's confirmation.  If a word beginning with
               y is given, the action is performed.  Any other
               input means "no".  This modifier is invalid with
               the -t option.

FILES
     /dev/tty  used to prompt the user for information when the
               -i or -y options are specified.

SEE ALSO
     cpio(1), dd(1), find(1), pax(1), cpio(5), tar(5)

COPYRIGHT
     Copyright (c) 1989 Mark H. Colburn.
     All rights reserved.

     Redistribution and use in source and binary forms are per-
     mitted provided that the above copyright notice is dupli-
     cated in all such forms and that any documentation,
     advertising materials, and other materials related to such
     distribution and use acknowledge that the software was
     developed by Mark H. Colburn.

     THE SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS
     OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE
     IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PAR-
     TICULAR PURPOSE.

AUTHOR
     Mark H. Colburn
     Minnetech Consulting, Inc.
     3232 Aquila Lane
     St. Louis Park, MN 55426

     mark@Minnetech.MN.ORG
