{

(c) GNU General Public License
(c) 2000 by raVen

raco archivers support

supported compilers: borland pascal 7.0, virtual pascal 2.0b+

}
{&Use32+,LocInfo+}
{$D+,L+,I-,R-,S-,Q-}
{}
Unit RacoArc;
interface
Uses Objects, rObjects, rCommon;
{}
const
 ArcNameMacro : pChar = '@ArcName';
 FileNameMacro: pChar = '@FileName';
 x_x          : pChar = '*.*';
 Command      : pChar = 'COMSPEC';
 DosExec      : pChar = ' /C ';
{}
type
{}
 tIdent = record
  Ofs: Longint;
  Flw: pString;
 end;
{( tRacoArchiver )}
 pRacoArchiver = ^tRacoArchiver;
 tRacoArchiver = object(tObject)
  Ext,Unpack,Add,Test,ArcName: pString;
  Ident: tIdent;
  constructor Init(aExt,aIdent,aUnpack,aAdd,aTest: String);
  destructor Done; virtual;

  procedure SetArcName(aArcName: String);
  function CanProcessIt: Boolean;
  function UnPackTo(Dir: String): Byte;
  function PackFrom(Dir: String): Byte;
  function TestArc: Byte;
 end;
{( tRacoArchivers )}
 pRacoArchivers = ^tRacoArchivers;
 tRacoArchivers = object(tObject)
  ArcCol: pCollection;
  ArcName: pString;
  CurrentArc: Integer;
  constructor Init;
  destructor  Done; virtual;

  procedure AddArchiver(aExt,aIdent,aUnpack,aAdd,aTest: String);
  procedure SetArcName(aArcName: String);
  function CanProcessIt: Integer;
  function UnPackTo(Dir: String): Byte;
  function PackFrom(Dir: String): Byte;
  function TestArc: Byte;
 end;
{}
implementation
Uses rStrings, Dos, rMacroz, Strings, Memory;
{( tRacoArchiver )}
constructor tRacoArchiver.Init;
 var
  s: String;
 begin
  inherited Init;
  Ext:=NewStr(aExt);
  Unpack:=NewStr(aUnPack);
  Add:=NewStr(aAdd);
  Test:=NewStr(aTest);
  if aIdent='' then exit;
  with Ident do
   begin
    Ofs:=CToN(Trim(ExtractWord(1,aIdent,[',']),SpaceChars));
    aIdent:=Trim(ExtractWord(2,aIdent,[',']),SpaceChars);
    s:='';
    repeat
     s:=s+Char(ToDec(Copy(aIdent,1,2),16));
     Delete(aIdent,1,2);
    until aIdent='';
    Flw:=NewStr(s);
   end;
 end;
{}
destructor tRacoArchiver.Done;
 begin
  ReallocStr(Ext,'');
  ReallocStr(Unpack,'');
  ReallocStr(Add,'');
  ReallocStr(Test,'');
  ReallocStr(ArcName,'');
  ReallocStr(Ident.Flw,'');
  inherited Done;
 end;
{}
procedure tRacoArchiver.SetArcName;
 begin
  ReallocStr(ArcName,aArcName);
 end;
{}
function tRacoArchiver.CanProcessIt;
 var
  f: File;
  s: String;
  fa: Word;
  NumRead: Word;
  Ofs: Longint;
 begin
  CanProcessIt:=False;
  if not Exist(GetPS(ArcName)) then exit;
  if (GetPS(Ext)<>'') and (GetPS(Ident.Flw)='') then
   begin
    if (UpStr(JustExtension(GetPS(ArcName)))=UpStr(GetPS(Ext))) then
     begin
      CanProcessIt:=True;
      exit;
     end;
   end
  else
   begin
    if GetPS(Ident.Flw)='' then exit;
    Assign(f,GetPS(ArcName));
    GetFAttr(f,fa);
    SetFAttr(f,Archive);
    Reset(f,1);
    if Ident.Ofs>=0 then Ofs:=Ident.Ofs else Ofs:=FileSize(f)+1-Ident.Ofs;
    Seek(f,Ofs);
    s[0]:=Char(Length(GetPS(Ident.Flw)));
    BlockRead(f,s[1],Length(GetPS(Ident.Flw)),NumRead);
    Close(f);
    if GetPS(Ident.Flw)=s then CanProcessIt:=True;
    SetFAttr(f,fa);
   end;
 end;
{}
function tRacoArchiver.UnpackTo;
 var
  m: pMacros;
  OldDir,s: String;
 begin
  UnPackTo:=66;
  if (GetPS(ArcName)='') or (GetPS(Unpack)='') then exit;
  GetDir(0,OldDir);
  Dir:=AddBackSlash(Dir);
  New(m,Init);
  if (Pos(Space,GetPS(ArcName))>0) then m^.AddStringMacro(StrPas(ArcNameMacro),Quote1+GetPS(ArcName)+Quote1,false)
  else m^.AddStringMacro(StrPas(ArcNameMacro),GetPS(ArcName),false);
  m^.AddStringMacro(StrPas(FileNameMacro),StrPas(x_x),false);
  s:=StrPas(DosExec)+GetPS(UnPack);
  m^.ProcessString(s);
  DisposeObj(m);
  if not MkTree(Dir) then exit;
  ChDir(RemoveBackSlash(Dir));
{$IfDef MsDos}
 {$IfNDef DPMI}
  SetMemTop(HeapPtr);
 {$EndIf}
  SwapVectors;
{$EndIf}
  Exec(GetEnv(StrPas(Command)),s);
{$IfDef MsDos}
  SwapVectors;
 {$IfNDef DPMI}
  SetMemTop(HeapEnd);
 {$EndIf}
{$EndIf}
  ChDir(OldDir);
  UnPackTo:=DosExitCode;
 end;
{}
function tRacoArchiver.PackFrom;
 var
  m: pMacros;
  OldDir,s: String;
 begin
  PackFrom:=66;
  if (GetPS(ArcName)='') or (GetPS(Add)='') then exit;
  GetDir(0,OldDir);
  Dir:=AddBackSlash(Dir);
  New(m,Init);
  if (Pos(Space,GetPS(ArcName))>0) then m^.AddStringMacro(StrPas(ArcNameMacro),Quote1+GetPS(ArcName)+Quote1,false)
  else m^.AddStringMacro(StrPas(ArcNameMacro),GetPS(ArcName),false);
  m^.AddStringMacro(StrPas(FileNameMacro),StrPas(x_x),false);
  s:=StrPas(DosExec)+GetPS(Add);
  m^.ProcessString(s);
  DisposeObj(m);
  if not MkTree(Dir) then exit;
  ChDir(RemoveBackSlash(Dir));
{$IfDef MsDos}
 {$IfNDef DPMI}
  SetMemTop(HeapPtr);
 {$EndIf}
  SwapVectors;
{$EndIf}
  Exec(GetEnv(StrPas(Command)),s);
{$IfDef MsDos}
  SwapVectors;
 {$IfNDef DPMI}
  SetMemTop(HeapEnd);
 {$EndIf}
{$EndIf}
  ChDir(OldDir);
  PackFrom:=DosExitCode;
 end;
{}
function tRacoArchiver.TestArc;
 var
  m: pMacros;
  s: String;
 begin
  TestArc:=66;
  if (GetPS(ArcName)='') or (GetPS(Test)='') then exit;
  New(m,Init);
  if (Pos(Space,GetPS(ArcName))>0) then m^.AddStringMacro(StrPas(ArcNameMacro),Quote1+GetPS(ArcName)+Quote1,false)
  else m^.AddStringMacro(StrPas(ArcNameMacro),GetPS(ArcName),false);
  s:=StrPas(DosExec)+GetPS(Test);
  m^.ProcessString(s);
  DisposeObj(m);
{$IfDef MsDos}
 {$IfNDef DPMI}
  SetMemTop(HeapPtr);
 {$EndIf}
  SwapVectors;
{$EndIf}
  Exec(GetEnv(StrPas(Command)),s);
{$IfDef MsDos}
  SwapVectors;
 {$IfNDef DPMI}
  SetMemTop(HeapEnd);
 {$EndIf}
{$EndIf}
  TestArc:=DosExitCode;
 end;
{( tRacoArchivers )}
constructor tRacoArchivers.Init;
 begin
  inherited Init;
  CurrentArc:=-1;
  ArcName:=nil;
  New(ArcCol,Init(16,16));
 end;
{}
destructor tRacoArchivers.Done;
 begin
  ReallocStr(ArcName,'');
  DisposeObj(ArcCol);
  inherited Done;
 end;
{}
procedure tRacoArchivers.AddArchiver;
 begin
  ArcCol^.Insert(New(pRacoArchiver,Init(aExt,aIdent,aUnpack,aAdd,aTest)));
 end;
{}
procedure tRacoArchivers.SetArcName;
 begin
  ReallocStr(ArcName,aArcName);
  CurrentArc:=-1;
 end;
{}
function tRacoArchivers.CanProcessIt;
 var
  x: Word;
 begin
  CanProcessIt:=-1;
  if GetPS(ArcName)='' then exit;
  if ArcCol^.Count>0 then for x:= ArcCol^.Count-1 downto 0 do
   begin
    pRacoArchiver(ArcCol^.At(x))^.SetArcName(GetPS(ArcName));
    if pRacoArchiver(ArcCol^.At(x))^.CanProcessIt then
     begin
      CanProcessIt:=x;
      CurrentArc:=x;
      exit;
     end;
   end;
 end;
{}
function tRacoArchivers.UnPackTo;
 begin
  UnPackTo:=255;
  if GetPS(ArcName)='' then exit;
  if CurrentArc<0 then CurrentArc:=CanProcessIt;
  if CurrentArc<0 then exit;
  UnPackTo:=pRacoArchiver(ArcCol^.At(CurrentArc))^.UnPackTo(Dir);
 end;
{}
function GetTempFileName(Dir: String): String;
 function GetMSGID: String;
  var
   stamp: Longint;
   stampW: record
    L,H: System.Word
   end absolute stamp;
   Year,Month,Day,Dow,Hour,Min,Sec,Sec100: Word;
   q: DateTime;
  begin
   Dos.GetDate(Year,Month,Day,Dow);
   GetTime(Hour,Min,Sec,Sec100);
   Stamp:=LongInt(Year)*365*24*60*60;
   Stamp:=Stamp+LongInt(Month)*30*24*60*60;
   Stamp:=Stamp+LongInt(Day)*24*60*60;
   Stamp:=Stamp+LongInt(Hour)*60*60;
   Stamp:=Stamp+LongInt(Min)*60;
   stamp:=stamp+Longint(Sec);
   stamp:=(stamp shl 7) or (Sec100 and $7F);
   Stamp:=Stamp+Random(65535);
   GetMsgID :=
   Digits[1+Hi(stampW.H) shr 4] +
   Digits[1+Hi(StampW.H) and $F] +
   Digits[1+Lo(StampW.H) shr 4] +
   Digits[1+Lo(StampW.H) and $F] +
   Digits[1+Hi(StampW.L) shr 4] +
   Digits[1+Hi(StampW.L) and $F] +
   Digits[1+Lo(StampW.L) shr 4] +
   Digits[1+Lo(StampW.L) and $F];
  end;
 var
  ext,s: String;
  x: LongInt;
 begin
  ext:='.tmp';
  if MkTree(Dir) then s:=AddBackSlash(Dir) else s:='';
  repeat
   s:=GetMsgId;
   GetTempFileName:=Dir+s+Ext;
  until not Exist(Dir+s+Ext);
 end;
{}
function tRacoArchivers.PackFrom;
 begin
  PackFrom:=255;
  if GetPS(ArcName)='' then exit;
  ReallocStr(ArcName,ForceExtension(GetTempFileName(Dir),GetPS(pRacoArchiver(ArcCol^.At(0))^.Ext)));
  if ArcCol^.Count<>0 then
   begin
    pRacoArchiver(ArcCol^.At(0))^.SetArcName(GetPS(ArcName));
    PackFrom:=pRacoArchiver(ArcCol^.At(0))^.PackFrom(Dir);
   end;
 end;
{}
function tRacoArchivers.TestArc;
 begin
  if GetPS(ArcName)='' then exit;
  if CurrentArc<0 then CurrentArc:=CanProcessIt;
  if CurrentArc<0 then exit;
  if ArcCol^.Count<>0 then TestArc:=pRacoArchiver(ArcCol^.At(CurrentArc))^.TestArc;
 end;
{}
end.
