extproc sh.exe
#----------- @jsawa@ ----------------------------------------------------
#  viewman.cmd  written by SAWATAISHI Jun <jsawa@attglobal.net>
#                                    http://www2s.biglobe.ne.jp/~vtgf3mpr/
#
#  You need following utilitis to run this batch file
#
#        `head' included in GNU fileutils
#               http://www2s.biglobe.ne.jp/~vtgf3mpr/index-e.htm
#                                                    [English Page]
#               ftp://hobbes.nmsu.edu/pub/os2/util/file/gnufutil.zip
#               ftp://ftp.leo.org/pub/comp/os/os2/leo//gnu/systools/gnufutil.zip
#
#        `sh'  included in KSH package
#               ftp://ftp.leo.org/pub/comp/os/os2/leo/shells/pdksh-5.2.13-emx.zip
#               ftp://hobbes.nmsu.edu/pub/os2/util/shell/ksh527rt.zip
#
#        `gzip' 
#               ftp://hobbes.nmsu.edu/pub/os2/util/archiver/gz124_32.zip
#               ftp://ftp.leo.org/pub/comp/os/os2/leo/gnu/archiver/gz124-32.zip
#
#        `bzip2' 
#               ftp://hobbes.nmsu.edu/pub/os2/util/archiver/bzip090b.zip
#               ftp://ftp.leo.org/pub/comp/os/os2/leo/archiver/bzip090b.zip
#               http://www.muraroa.demon.co.uk/
#               http://www2s.biglobe.ne.jp/~vtgf3mpr/index-e.htm
#               http://netpassport-wc.netpassport.or.jp/~wmakoto/CLUB-bzip2.html
#                                                              [Japanese Page]
#
#
#         `less' for PAGER
#               ftp://ftp.leo.org/pub/comp/os/os2/leo/unix/gnu/less329-2.zip
#                                                      [English version]
#               ftp://hobbes.nmsu.edu/pub/os2/unix/util/util/file/less329-2.zip
#                                                      [English version]
#               http://hp.vector.co.jp/authors/VA000199/os2/
#                                                      [Japanese version]
#
#
# If you have installed Japanese version of groff:
#          device=nippon
# If not:
#          device=ascii
#
device=nippon
#
# Set text-mode WWW pager: 
WWW_PAGER="w3m -T text/html"
#

if [ -z $1 ] ; then 
	echo -e "\n"
	echo "*---------  viewman.cmd --------------------------------*"
	echo -e "\n"
	echo "Read manpage with 'groff' and PAGER"
	echo "  If PAGER environment variable in not set, "
	echo "  viewman.cmd outputs formatted manpage to standard output."
	echo
	echo "Usage:  viewman [-x|-w] x:/foo/bar/manpage.1"
	echo "        viewman         x:/foo/bar/manpage.1.gz"
	echo "        viewman         x:/foo/bar/manpage.1.bz2"
	echo
	echo             -x: output to X window
	echo             -w: output in HTML format using WWW_PAGER
	echo                      c.f. set WWW_PAGER=w3m -T text/html
	echo              
	echo "*-------------------------------------------------------*"
	exit
fi

# If the first argument is "-x", groff outputs in X graphical interface. 
# Available devices for X are X100, X100-12, X75, and X75-12
#
if [ "$1" = "-x" ] ; then
	device=X100-12
	xfree86=yes
	shift
fi

if [ "$1" = "-w" ] ; then
	device=html
	PAGER="${WWW_PAGER-$PAGER}"
	shift
fi


case $1 in
	*.gz)  top_line=`gzip  -dc $1 | head -1` ;;
	*.bz2) top_line=`bzip2 -dc $1 | head -1` ;;
	*)     top_line=`head -1 $1 ` ;;
esac

if [ -z "$top_line" ]
then
	case $1 in
		*.gz)  gzip  -dc $1 | $PAGER    ;;
		*.bz2) bzip2 -dc $1 | $PAGER    ;;
		*)                     $PAGER $1 ;;
	esac
	exit
else
	if [ "$xfree86" = "yes" ]
	then
		case $1 in
			*.gz)  gzip  -dc $1 | groff -mandoc -T${device} ;;
			*.bz2) bzip2 -dc $1 | groff -mandoc -T${device}  ;;
			*)                     groff -mandoc -T${device} $1 ;;
		esac
	else
		if [ -z $PAGER ] ; then 
			case $1 in
				*.gz)  gzip  -dc $1 | groff -mandoc -T${device} ;;
				*.bz2) bzip2 -dc $1 | groff -mandoc -T${device} ;;
				*)                    groff -mandoc -T${device} ;;
			esac
		else
			case $1 in
				*.gz)  gzip  -dc $1 | groff -mandoc -T${device}    | $PAGER ;;
				*.bz2) bzip2 -dc $1 | groff -mandoc -T${device}    | $PAGER ;;
				*)                    groff -mandoc -T${device} $1 | $PAGER ;;
			esac
		fi
	fi
	exit
fi
