#!/bin/sh

# build prerequisites:
# * upx 3.04 source (http://upx.sourceforge.net/)
# * ucl 1.03 (http://www.oberhumer.com/opensource/ucl/)
# * LZMA SDK 4.65
# (http://www.7-zip.org/sdk.html, http://sourceforge.net/projects/sevenzip/)
# 
# upx 3.04 build step (for OS/2 with gcc 3.3.5):
#
# * extract upx-3.04-src.tar.bz2
# * apply patch for OS/2 (in the directory upx-3.04-src):
#     patch -p1 < upx-3.04-os2klibc.diff
# * mkdir lzma465 (into the directory upx-3.04-src)
# * extract ucl-1.03.tar.gz (into the directory "upx-3.04-src")
# * extract lzma465.tar.bz2 (into the directory "upx-3.04-src/lzma465")
# * configure the ucl library (in the directory upx-3.04-src/ucl-1.03):
#     \bin\sh ./conf.ucl-1.03.gcc335.noasm.sh
# * run build script (in the directory upx-3.04-src):
#     \bin\sh ./bld_upx_os2.sh


basedir=`pwd`
UPX_UCLDIR="$basedir/ucl-1.03"
UPX_LZMADIR="$basedir/lzma465"
exeext=".exe"
UPX_DEFS="-DUCL_NO_ASM"
UPX_CFLAGS="-O2 -mcpu=i486 -fno-strict-aliasing -Wall -W -Wcast-align -Wcast-qual -Wpointer-arith -Wwrite-strings -Werror"
UPX_LDFLAGS="-s -Zomf -Zstack 8192"

export UPX_UCLDIR
export UPX_LZMADIR

cd $UPX_UCLDIR && make && cp -p src/.libs/ucl.a libucl.a && cd $basedir && \
make \
  DEFS="$UPX_DEFS" \
  CFLAGS="$UPX_CFLAGS" \
  CXXFLAGS="$UPX_CFLAGS" \
  LDFLAGS="$UPX_LDFLAGS" \
  exeext=$exeext \
  all
