/******************************************************************
 * To create boot disks for ADSM boot recovery under Warp Connect.
 *
 * NOTE:
 *  1. These files are layed out for Drive A: being 1.44, and Drive
 *     B: being 1.22.
 ******************************************************************/

/******************************************************************
 * Be sure to properly set the next few entries to match your system.
 * Don't change anything else!
 ******************************************************************/

Ether_Driver =  'ELNK16.OS2'

OS2_Drive    =  'D:'
IBMCOM_Drive =  'D:'
MPTN_Drive   =  'D:'
TCPIP_Drive  =  'D:'
ADSM_Path    =  'E:\util\adsm'

/* Driver1    =  'AHA?????.ADD' */   /* Scsi hasn't been tried yet */
Driver1      =  'IBM1S506.ADD'       /* for IDE */


/*********************************************************************
 * Begin copying files.
 *********************************************************************/

'cls'
say ''
say ''
say '   This procedure will be copying files to three disks. It will first'
say 'use drive A:, then drive B:, then A: again.'
say ''
say 'Please make sure you have three blank, formatted disks.'
say ''
say 'If you don''t have the disks ready, just open another command-line window'
say 'and format the disks.'
say ''
say ''
say ''
say 'Place the first boot disk in drive A:, and the second boot disk in B:'
say ''
say ''
pause

OS2_Drive'\OS2\INSTALL\BOOTDISK\SYSINSTX A:'   /* create system disk */

'COPY 'OS2_Drive'\OS2\BOOT\'Driver1' A:'       /* copy the HD controller driver */
                                               /* if scsi is ever tried, more   */
                                               /* copies may need to be placed  */
                                               /* here for os2scsi.dmd, etc.    */

'ATTRIB -H -S 'OS2_Drive'\OS2KRNL'             /* prepare to copy system files  */
'ATTRIB -H -S 'OS2_Drive'\OS2LDR'
'ATTRIB -H -S 'OS2_Drive'\OS2LDR.MSG'
'ATTRIB -H -S 'OS2_Drive'\OS2VER'

'COPY 'OS2_Drive'\OS2KRNL       A:'            /* copy system files             */
'COPY 'OS2_Drive'\OS2LDR        A:'
'COPY 'OS2_Drive'\OS2LDR.MSG    A:'
'COPY 'OS2_Drive'\OS2VER        A:'

'ATTRIB +H +S 'OS2_Drive'\OS2KRNL'             /* undo the changes to system files */
'ATTRIB +H +S 'OS2_Drive'\OS2LDR'
'ATTRIB +H +S 'OS2_Drive'\OS2LDR.MSG'
'ATTRIB +H +S 'OS2_Drive'\OS2VER'


/* put the hard disk driver in config.sys as the top line.    */
/* append the vanilla config.sys.                             */
/* append the device statement for the ethernet driver at     */
/* the end of config.sys.  It will be set to drive B:         */
/* because that's where the driver will be copied in a moment */

echo 'BASEDEV='Driver1'  > A:\config.sys'
'type config.dsm >> A:\config.sys'
echo 'DEVICE=B:\'Ether_Driver'  >> A:\config.sys'

'COPY 'OS2_Drive'\OS2\CMD.EXE                          A:'  /* copy OS/2 files */
'COPY 'OS2_Drive'\OS2\HPFS.IFS                         A:'
'COPY 'OS2_Drive'\OS2\KEYBOARD.DCP                     A:'
'COPY 'OS2_Drive'\OS2\BOOT\CLOCK01.SYS                 A:'
'COPY 'OS2_Drive'\OS2\BOOT\DOS.SYS                     A:'
'COPY 'OS2_Drive'\OS2\BOOT\IBM1FLPY.ADD                A:'  
'COPY 'OS2_Drive'\OS2\BOOT\IBMKBD.SYS                  A:'
'COPY 'OS2_Drive'\OS2\BOOT\KBDBASE.SYS                 A:'  
'COPY 'OS2_Drive'\OS2\BOOT\OS2DASD.DMD                 A:'
'COPY 'OS2_Drive'\OS2\BOOT\PRINT01.SYS                 A:'
'COPY 'OS2_Drive'\OS2\BOOT\RESOURCE.SYS                A:'
'COPY 'OS2_Drive'\OS2\BOOT\SCREEN01.SYS                A:'
'COPY 'OS2_Drive'\OS2\BOOT\TESTCFG.SYS                 A:'
'COPY 'OS2_Drive'\OS2\INSTALL\BOOTDISK\VTBL850.DCP     A:'
'COPY 'OS2_Drive'\OS2\SYSTEM\COUNTRY.SYS               A:'
'COPY 'OS2_Drive'\OS2\SYSTEM\HARDERR.EXE               A:'

'COPY 'IBMCOM_Drive'\IBMCOM\PROTOCOL\NETBEUI.OS2       A:' /* copy TCPIP files */
'COPY 'IBMCOM_Drive'\IBMCOM\PROTOCOL\NETBIND.EXE       A:'
'COPY 'IBMCOM_Drive'\IBMCOM\LT2.MSG                    A:'
'COPY 'IBMCOM_Drive'\IBMCOM\PRO.MSG                    A:'
'COPY 'IBMCOM_Drive'\IBMCOM\PROTMAN.OS2                A:'
'COPY 'MPTN_Drive'\MPTN\PROTOCOL\IFNDIS.SYS            A:'
'COPY 'MPTN_Drive'\MPTN\BIN\CNTRL.EXE                  A:' 


'COPY 'OS2_Drive'\OS2\BOOT\CDFS.IFS              B:'  /* copy OS/2 files */
'COPY 'OS2_Drive'\OS2\DLL\ANSICALL.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\BKSCALLS.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\BMSCALLS.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\BVHINIT.DLL            B:'
'COPY 'OS2_Drive'\OS2\DLL\BVSCALLS.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\DOSCALL1.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\KBDCALLS.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\MOUCALLS.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\MSG.DLL                B:'
'COPY 'OS2_Drive'\OS2\DLL\NAMPIPES.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\NLS.DLL                B:'
'COPY 'OS2_Drive'\OS2\DLL\OS2CHAR.DLL            B:'
'COPY 'OS2_Drive'\OS2\DLL\QUECALLS.DLL           B:'
'COPY 'OS2_Drive'\OS2\DLL\SESMGR.DLL             B:'
'COPY 'OS2_Drive'\OS2\DLL\UCDFS.DLL              B:'
'COPY 'OS2_Drive'\OS2\DLL\UHPFS.DLL              B:'
'COPY 'OS2_Drive'\OS2\DLL\VIOCALLS.DLL           B:' 

'COPY 'IBMCOM_Drive'\IBMCOM\PROTOCOL.INI         B:'  /* copy TCPIP files */
'COPY 'TCPIP_Drive'\TCPIP\ETC\PROTOCOL           B:'
'COPY 'IBMCOM_Drive'\IBMCOM\MACS\'Ether_driver  'B:'
'COPY 'MPTN_Drive'\MPTN\DLL\TCPIPDLL.DLL         B:'
'COPY 'MPTN_Drive'\MPTN\PROTOCOL\AFINET.SYS      B:'
'COPY 'MPTN_Drive'\MPTN\PROTOCOL\SOCKETS.SYS     B:'
'COPY 'MPTN_Drive'\MPTN\PROTOCOL\AFOS2.SYS       B:'

'COPY 'ADSM_path'\DLL\FCLCNRP.DLL                B:'  /* copy ADSM files */
'COPY 'ADSM_path'\DLL\HPFS386.DLL                B:'


'cls'
say ''
say ''
say 'Remove the two boot disks, and label them '
say '      ''ADSM Boot Disk A'' and            '
say '      ''ADSM Boot Disk B''                ' 
say ''
say '(Disk A contains only those files needed during boot '
say ' and Disk B contains DLLs, etc. needed during boot as '
say ' well as during TCPIP and ADSM activity. Disk B also '
say ' contains the ethernet adaptor driver.  If you ever use '
say ' these disks on another machine, you will need to replace '
say ' this driver with the correct one, and edit config.sys to '
say ' load the correct driver name.)'
say ''
say ''
say 'Put the third disk in drive A:            '
say ''
pause
'COPY 'OS2_Drive'\OS2\TEDIT.EXE                A:' /* copy OS/2 utilities */
'COPY 'OS2_Drive'\OS2\TEDIT.HLP                A:'
'COPY 'OS2_Drive'\OS2\CHKDSK.COM               A:'
'COPY 'OS2_Drive'\OS2\FDISK.COM                A:'
'COPY 'OS2_Drive'\OS2\FORMAT.COM               A:'

'COPY 'MPTN_Drive'\MPTN\BIN\INETWAIT.EXE       A:' /* copy TCPIP config files */
'COPY 'MPTN_Drive'\MPTN\BIN\IFCONFIG.EXE       A:'
'COPY 'MPTN_Drive'\MPTN\BIN\ROUTE.EXE          A:'
'COPY 'MPTN_Drive'\MPTN\BIN\ARP.EXE            A:'
'COPY 'TCPIP_Drive'\TCPIP\BIN\IPGATE.EXE       A:'

/* normally, config.sys runs mptnstart.cmd which  */
/* does 'INETWAIT' and then runs setup.cmd to do  */
/* IFCONFIG/ROUTE/etc.  We're just going to stick */
/* INETWAIT into setup.cmd as the first line, and */
/* append startup.cmd to it.  User only needs to  */
/* run setup.cmd, and it will do the INETWAIT.    */
/* IP Addrs are hard coded in setup.cmd           */

echo 'INETWAIT  >  A:\SETUP.CMD'
'type 'MPTN_Drive'\MPTN\BIN\SETUP.CMD  >>  A:SETUP.CMD'


'COPY 'ADSM_path'\DSMC.EXE                     A:' /* copy ADSM runtime files */
'COPY 'ADSM_path'\DSCAMENG.TXT                 A:'
'COPY 'ADSM_path'\DSM.OPT                      A:'


cls
say 'Remove the disk in drive A: and label it'
say '      ''ADSM Recovery Disk A''          '
say ''
say ' The ADSM Recovery disk must replace boot disk #1 after boot'
say ' finishes, and boot disk #2 must remain in drive B: during recovery.'
say ''
say ' This disk contains TCPIP commands, FORMAT, FDISK, TEDIT, the'
say ' ADSM command line client and the DSM.OPT file.'
pause
say ''
say ' If you ever use these disks on another machine, be sure to edit'
say ' DSM.OPT to reflect the other machine, and also edit the IP addresses'
say ' contained in SETUP.CMD.  Remember that the ADSM server address '
say ' contained in DSM.OPT must be in dotted decimal format because there'
say ' is no nameserver connectivity using these disks.'
say ''
say ' After boot completes, place Recovery Disk A in drive A: and type '
say '''SETUP'' to complete your TCPIP configuration.  You may then type '
say ' FDISK, FORMAT and execute DSMC commands such as:'
say '      DSMC QUERY FILESPACE'
say '      DSMC RESTORE C:* D:* -SUBDIR=YES -REPLACE=YES'
say ''
say ' Hints on ADSM commands, and the format command, are contained in'
say ' config.sys as remarks.  You can always type config.sys to the '
say ' screen and refresh your memory.'
exit
