/* An example of a window with the KEYS Flag set. We simply print out each
 key that the user presses */

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE


/* ====================== 'Main Window' ======================= */
/* First Group is TEXT */
RXTYPE.1 = 'TEXT'

/* Default */
RXFLAGS.1 = ' '

/* Text lines */
RXLABEL.1 = "Press a key on the keyboard:"

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.1 = '1 1 0 0'

/* Position */
RXX.1 = 10
RXY.1 = 30

/* Use another TEXT Group to display the key */
RXTYPE.2 = 'TEXT'

/* Default */
RXFLAGS.2 = ' '

/* Text lines */
RXLABEL.2 = ' '

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases. Note that
 we deliberately set WidthOfPhrase non-0 to allow enough width to accomodate
 a range of text */
RXINFO.2 = '1 1 200 0'

/* Position */
RXX.2 = 10
RXY.2 = 10

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
RXDLG 2 '"Main Window"' 'RXWINMAIN' 'NOCLOSE|KEYS'

more:
   /* Do user interaction. We go to sleep while user manipulates the window
      ounts down, until such time as the
      user presses ESC or ENTER if the window's RESULT Flag is set, or tries
      to close a dialog using its CLOSE ICON, or uses a RESULT Group, or
      uses some Group with its END Flag set, or presses a key if the window's
      KEYS Flag is set, or the timer times out */
   RXDLG

   /* RXWIND now specifies which window woke us up. The window is still
      there because we specified NOCLOSE. Even if we hadn't specified that,
     the window would still be there if what caused RXDLG to return was a user
     pressing a key.  (The exception to this would be the ESC and ENTER keys
     if we had set the window's RESULT Flag too). NOTE: *NONE* of the RXVAL or
     any LIST/DROP BOX stem variables, nor the Dimensions string for that
     window have been setup if what caused RXDLG to return was a user pressing
     a key.  (The exception to this would be the ESC and ENTER keys if we had
     set the window's RESULT Flag too) */

   /* Figure out what key he pressed and display it */
   SELECT
	/* Regular (ie, printable key) */
	WHEN RXID = 0 THEN DO
	    IF RXSUBID = ' ' THEN RXSUBID = 'SPACE' /* Just so that we see something for a SPACE */
	    RXSET '""' 2 1 'VAL' RXSUBID
	END

	/* Regular (ie, printable key) with ALT key held down */
	WHEN RXID = -1 THEN DO
	    /* NOTE: OS/2 siphons off ALT+SPACE to access a window's system
		menu, but ALT+SHIFT+SPACE works here */
	    IF RXSUBID = ' ' THEN RXSUBID = 'SPACE' /* Just so that we see something for a SPACE */
	    RXSET '""' 2 1 'VAL' RXSUBID' + ALT'
	END

	/* Regular (ie, printable key) with CTRL key held down */
	WHEN RXID = -2 THEN DO
	    IF RXSUBID = ' ' THEN RXSUBID = 'SPACE' /* Just so that we see something for a SPACE */
	    RXSET '""' 2 1 'VAL' RXSUBID' + CTRL'
	END

	/* Regular (ie, printable key) with ALT and CTRL both held down */
	WHEN RXID = -3 THEN DO
	    IF RXSUBID = ' ' THEN RXSUBID = 'SPACE' /* Just so that we see something for a SPACE */
	    RXSET '""' 2 1 'VAL' RXSUBID' + ALT + CTRL'
	END

	/* Virtual key */
	WHEN RXID = -4 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2
	END

	/* Virtual Key with ALT key held down */
	WHEN RXID = -5 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + ALT'
	END

	/* Virtual Key with CTRL key held down */
	WHEN RXID = -6 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + CTRL'
	END

	/* Virtual Key with ALT and CTRL both held down */
	WHEN RXID = -7 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + ALT + CTRL'
	END

	/* Virtual Key with SHIFT key held down */
	WHEN RXID = -8 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + SHIFT'
	END

	/* Virtual Key with SHIFT + ALT key held down */
	WHEN RXID = -9 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + SHIFT + ALT'
	END

	/* Virtual Key with SHIFT and CTRL both held down */
	WHEN RXID = -10 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + SHIFT + CTRL'
	END

	/* Virtual Key with SHIFT and ALT and CTRL all held down */
	WHEN RXID = -11 THEN DO
	    CALL ProcessKey
	    RXSET '""' 2 1 'VAL' str2' + SHIFT + ALT + CTRL'
	END

	/* ESC */
	WHEN RXID = -12 THEN DO
	    RXSET '""' 2 1 'VAL' 'ESC'
	END

	/* Window's CLOSE ICON or ABORT */
	WHEN RXID = -98 | RXID = -99 THEN DO
	    EXIT
	END

	OTHERWISE
	    RXSET '""' 2 1 'VAL' 'RXID = 'RXID', RXSUBID = 'RXSUBID
   END

/* Do another message loop */
SIGNAL more

/* ========================== Done ========================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT


ProcessKey:
    SELECT
	WHEN RXSUBID = 4 THEN str2 = 'Break'
	WHEN RXSUBID = 5 THEN str2 = 'BackSpace'
	WHEN RXSUBID = 6 THEN str2 = 'TAB'
	WHEN RXSUBID = 7 THEN str2 = 'BackTAB'
	WHEN RXSUBID = 13 THEN str2 = 'Pause'
	WHEN RXSUBID = 14 THEN str2 = 'Caps Lock'
	WHEN RXSUBID = 17 THEN str2 = 'Page Up'
	WHEN RXSUBID = 18 THEN str2 = 'Page Down'
	WHEN RXSUBID = 19 THEN str2 = 'End'
	WHEN RXSUBID = 20 THEN str2 = 'Home'
	WHEN RXSUBID = 21 THEN str2 = 'Left'
	WHEN RXSUBID = 22 THEN str2 = 'Up'
	WHEN RXSUBID = 23 THEN str2 = 'Right'
	WHEN RXSUBID = 24 THEN str2 = 'Down'
	WHEN RXSUBID = 25 THEN str2 = 'Print Screen'
	WHEN RXSUBID = 26 THEN str2 = 'Insert'
	WHEN RXSUBID = 27 THEN str2 = 'Delete'
	WHEN RXSUBID = 28 THEN str2 = 'Scroll Lock'
	WHEN RXSUBID = 29 THEN str2 = 'Num Lock'
	WHEN RXSUBID = 31 THEN str2 = 'SysRq'
	WHEN RXSUBID = 32 THEN str2 = 'F1'
	WHEN RXSUBID = 33 THEN str2 = 'F2'
	WHEN RXSUBID = 34 THEN str2 = 'F3'
	WHEN RXSUBID = 35 THEN str2 = 'F4'
	WHEN RXSUBID = 36 THEN str2 = 'F5'
	WHEN RXSUBID = 37 THEN str2 = 'F6'
	WHEN RXSUBID = 38 THEN str2 = 'F7'
	WHEN RXSUBID = 39 THEN str2 = 'F8'
	WHEN RXSUBID = 40 THEN str2 = 'F9'
	WHEN RXSUBID = 41 THEN str2 = 'F10'
	WHEN RXSUBID = 42 THEN str2 = 'F11'
	WHEN RXSUBID = 43 THEN str2 = 'F12'
	WHEN RXSUBID = 44 THEN str2 = 'F13'
	WHEN RXSUBID = 45 THEN str2 = 'F14'
	WHEN RXSUBID = 46 THEN str2 = 'F15'
	WHEN RXSUBID = 47 THEN str2 = 'F16'
	WHEN RXSUBID = 48 THEN str2 = 'F17'
	WHEN RXSUBID = 49 THEN str2 = 'F18'
	WHEN RXSUBID = 50 THEN str2 = 'F19'
	WHEN RXSUBID = 51 THEN str2 = 'F20'
	WHEN RXSUBID = 52 THEN str2 = 'F21'
	WHEN RXSUBID = 53 THEN str2 = 'F22'
	WHEN RXSUBID = 54 THEN str2 = 'F23'
	WHEN RXSUBID = 55 THEN str2 = 'F24'
    END
RETURN
