/* This creates a Main Window, and numerous Child Dialogs. Then it does a
   message loop, letting the user interact with any of those windows. Some
   of the windows have Groups which cause RXDLG to return. Other windows have
   the RESULT flag set so that the user can end by pressing ESC or ENTER. Of
   course, clicking upon a CLOSE BOX always causes RXDLG to return. We check
   the RXWIND variable and do some appropriate processing for that window --
   namely, we just print out the returned value for that window's groups.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE


/* ================ Create "Main Window" =============== */
/* First Group is ENTRY */
RXTYPE.1 = 'ENTRY'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Labels for each entry, and Groupbox. Note: 3rd entry has no label */
RXLABEL.1 = 'Range|Second||Fourth|All'

/* Variable name where the text "typed into" the entries is stored */
RXVAL.1 = 'TEXT'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '4 2 45'

/* Position of Group */
RXX.1 = 65
RXY.1 = 70

/* The text for the 4 entries */
TEXT.1 = 'Hello'
TEXT.2 = 'Hi'
TEXT.3 = ' '         /* A blank entry initially */
TEXT.4 = 'More text'

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* Specify NOCLOSE (since we'll do the closing ourselves, and also
    RESULT so that RXDLG returns upon ESC or ENTER */
RXDLG 1 '"Main Window"' 'RXWIN1' 'NOCLOSE|RESULT'




/* =================== Create "Drop Stuff" Dialog =================== */
/* First Group is DROP */
RXTYPE.1 = 'DROP'

/* Default */
RXFLAGS.1 = ''

/* Labels for each dropbox, and Groupbox. Note: No label for 3rd dropbox,
    nor Groupbox */
RXLABEL.1 = 'First | Range'

/* Stem variable names to fetch the strings for each dropbox in the group */
RXVAL.1 = 'BLORT | CHOICE | LIST'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '3 2 100'

/* Position */
RXX.1 = 65
RXY.1 = 56

/* First List items */
BLORT.1 = 'This is 1'
BLORT.2 = 'This is 2'
BLORT.3 = 'This is 3'
BLORT.4 = 'This is 4'
BLORT.5 = 'This is 5'
BLORT.6 = 'This is 6'
BLORT.7 = 'This is 7'
BLORT.8 = ' '  /* Marks the end of the list */

/* Second List items */
CHOICE.1 = 'OS/2'
CHOICE.2 = 'Windows'  /* "Ack!", says Bill The Gates */
CHOICE.3 = ' '  /* Marks the end of the list */

/* Third List items */
LIST.1 = 'Bananas'
LIST.2 = 'Oranges'
LIST.3 = 'Grapes'
LIST.4 = 'Apples'
LIST.5 = ' '  /* Marks the end of the list */

RXWIN3 = '350 130 40 40'
RXDLG 1 '"Drop Stuff"' 'RXWIN3' 'NOCLOSE|RESULT'




/* ================= Create "Indexes" Dialog ================== */
/* First Group is DROP */
RXTYPE.1 = 'DROP'

/* Give me index rather than the text for the selected item. If I typed
    in something, not in the droplist, then that text is returned. Also,
    cause RXDLG to return when control is used */
RXFLAGS.1 = 'INDEX'

/* Labels for each dropbox, and Groupbox */
RXLABEL.1 = 'Type Here:|Drop Me'

/* Stem variable names to fetch the strings for each dropbox in the group */
RXVAL.1 = 'BLORT'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 100'

/* Position */
RXX.1 = 95
RXY.1 = 56

/* First List items */
BLORT.1 = 'This is 1'
BLORT.2 = 'This is 2'
BLORT.3 = 'This is 3'
BLORT.4 = 'This is 4'
BLORT.5 = 'This is 5'
BLORT.6 = 'This is 6'
BLORT.7 = 'This is 7'
BLORT.8 = ' '  /* Marks the end of the list */

RXWIN4 = '220 120 84 70'
RXDLG 1 '"Indexes"' 'RXWIN4'  'NOCLOSE|RESULT'



/* ================= Create "List 1" Dialog ================== */
/* First Group is LIST */
RXTYPE.1 = 'LIST'

/* Give me index # of item, rather than the text for it. Also cause RXDLG
     to return */
RXFLAGS.1 = 'INDEX|END'

/* Labels for each listbox, and Groupbox */
RXLABEL.1 = 'Items: | Fruits: | List boxes'

/* Stem variable names to fetch the strings for each dropbox in the group */
RXVAL.1 = 'BLORT|LIST'

/* TotalControls, ControlsPerLine, WidthOfControls, *AND* NumVisibleItems */
RXINFO.1 = '2 1 100 4'

/* Position */
RXX.1 = 10
RXY.1 = 10

/* First List items */
BLORT.1 = 'One'
BLORT.2 = 'Two'
BLORT.3 = 'Three'
BLORT.4 = 'Four'
BLORT.5 = 'Five'
BLORT.6 = ' '  /* Marks the end of the list */

/* Second List items */
LIST.1 = 'Bananas'
LIST.2 = 'Oranges'
LIST.3 = 'Grapes'
LIST.4 = 'Apples'
LIST.5 = ' '  /* Marks the end of the list */

RXWIN5 = '130 234 100 8'
RXDLG 1 '"List 1"' 'RXWIN5' 'NOCLOSE|RESULT'




/* ============== Create "MultiSelect Lists" dialog ================ */
/* First Group is LIST */
RXTYPE.1 = 'LIST'

/* Flags */
RXFLAGS.1 = 'MULTIPLE|ALLNONE'

/* Labels for each listbox, and Groupbox. NOTE: No Groupbox */
RXLABEL.1 = 'Items: | Fruits:'

/* Stem variable names to fetch the strings for each listbox in the group */
RXVAL.1 = 'BLORT|LIST'

/* TotalControls, ControlsPerLine, WidthOfControls, *AND* NumVisibleItems */
RXINFO.1 = '2 1 100 4'

/* Position */
RXX.1 = 16
RXY.1 = 30

/* First List items */
BLORT.1 = 'One'
BLORT.2 = 'Two'
BLORT.3 = 'Three'
BLORT.4 = 'Four'
BLORT.5 = 'Five'
BLORT.6 = ' '  /* Marks the end of the list */

/* Second List items */
LIST.1 = 'Bananas'
LIST.2 = 'Oranges'
LIST.3 = 'Grapes'
LIST.4 = 'Apples'
LIST.5 = 'Pears'
LIST.6 = 'Titties and Beer'
LIST.7 = ' '  /* Marks the end of the list */

/* Second Group is RESULT */
RXTYPE.2 = 'RESULT'

/* Return a 1 for OK, YES, RETRY, ENTER, etc. Return a 0 for
    CANCEL, NO, IGNORE, etc. No need to set 'END' since
    RESULTBUTTON group always causes RXDLG to return */
RXFLAGS.2 = 'BOOL'

/* No groupbox */
RXLABEL.2 = ' '

/* Give me "Ok" and "Cancel" */
RXINFO.2 = '1 2'

/* RXVAL is Irrelevant for RESULTBUTTON */

/* Position */
RXX.2 = 3
RXY.2 = 3

RXWIN6 = '150 274 10 100'
RXDLG 2 '"MultiSelect Lists"' 'RXWIN6' 'NOCLOSE|RESULT'




/* ================ Create "Electric Slide" Dialog ================ */
/* First Group is SLIDER */
RXTYPE.1 = 'SLIDER'

/* Print out value of slider knob as it moves */
RXFLAGS.1 = 'VALUE'

/* Range/Detent/Label for each slider, and Groupbox.
    NOTE: First slider has no Detent (ie, 255) */
RXLABEL.1 = '128 255 Range 1:| 64 0 Range 2:|Try us'

/* Initial values for slider knobs */
RXVAL.1 = '64 32'

/* TotalControls, ControlsPerLine, SizeOfControl */
RXINFO.1 = '2 1 142'

/* Position */
RXX.1 = 80
RXY.1 = 18

RXWIN7 = '280 104 80 80'
RXDLG 1 '"Electric Slide"' 'RXWIN7' 'NOCLOSE|RESULT'



/* ============= Message loop on the dialog windows ============ */
more:
   /* Because we have more than 1 window open and have not specified MODAL
       for the active one, the window that is active when we call RXDLG may
       not be the same window that is active when RXDLG returns (ie, it may
       not be the same window that causes RXDLG to return and sets all of the
       RXVAL and any LIST/DROP BOX stem variables, RXID, RXSUBID, and RXWIND
       variables, and the Dimensions string for that window. For this
       reason, let's not specify any window title nor operation to RXDLG. This will
       cause RXDLG to pick up on the window that was last active,
       will interact with the user, and won't force any dialog closure (unless the
       user happens to have activated a window that wasn't created with
       NOCLOSE (here, all of our windows are NOCLOSE).
       Note that if all of the windows are closed (including the main window),
       and we don't specify a window title, this amounts to specifying a
       window title that isn't open. In this case, Rexx Dialog sets an ERROR (ie,
       "Can't find REXX dialog." error message), and we would branch to that
       label. In fact, our way out of here is to EXIT after we detect that the
       user has clicked on the main window CLOSE ICON (and we kill that
       window).
 */

   /* Wait on the window(s). We go to sleep while user manipulates dialogs,
       until such time as the user presses ESC or ENTER, or tries to close a dialog
       using its CLOSE ICON, or uses a RESULT Group or a Control within some
       Group that has its END Flag set. Other things that could cause RXDLG to
       return are a window timeout and if the user pressed a key in a window
       with its KEYS Flag set... but we haven't utilized those features */
   RXDLG  /* NOTE: No window title means "use Main Window". No operation
		   specified means an operation of 0 (ie, PROCESS) */

   /* RXWIND now specifies which window woke us up. (The window is still
      there because we specified NOCLOSE and didn't do an Operation that
      causes a window closure).
	 All of the RXVAL (and any LIST/DROP BOX stem) variables, RXID,
     RXSUBID, and RXWIND variables (and the Dimensions string for that
     window) have been setup according to the state of this window when RXDLG
     returned */

   /* Did user press ESC or click on the CLOSE ICON? Note that we haven't set
      the KEYS flag of any window, so we don't need to check for particular
      negative values of RXID because the only 2 we ever receive here are
      for the ESC key and CLOSE ICON */
   IF RXID < 0 THEN DO
      RXSAY '"'RXWIND'" aborted.'
      IF RXWIND = 'Main Window' THEN EXIT
   END

   /* If user didn't abort, then display the value strings for this window.
       IMPORTANT: If he didn't abort, then he either pushed some SUCCESS (ie,
       OK, RETRY, ENTER, etc) or FAILURE (ie, CANCEL, IGNORE, NO, etc)
       button in a RESULT Group, or he used some Group whose 'END' Flag
       we set, or he pressed the ENTER key while the window itself had the
       focus, or a timeout occured if we setup that for this window, or some
       key was pressed if the window had its KEYS Flag set.
	   If we had a RESULT Group with a FAILURE type button in the window,
       and that caused RXDLG to return, normally we'd check the RXVAL of that
       Group, and if an odd number, abort any operation. (For BOOL, we'd
       abort on 0) */

    ELSE DO
       /* =========================================== */
       /* Did user press the ENTER key while the window had the focus?
	   Note that we haven't setup a timeout, nor set the KEYS flag
	   of any window, so we don't need to check RXSUBID. It's always
	   going to be 10 (ie, ENTER) here if RXID is 0 */
       IF RXID = 0 THEN DO
	   RXSAY 'Pressed ENTER on "'RXWIND'".'
       END

       /* Display the Group #, Control # of the control that caused RXDLG to return */
       ELSE RXSAY 'Group #'RXID', Control #'RXSUBID' ended "'RXWIND'" dialog.'

       SELECT
	   /* =============== Indexes Dialog ================ */
	   WHEN RXWIND = "Indexes" THEN DO
	   /* Display index of chosen item in the Group's only DROPBOX */
	       RXSAY '"'RXWIND'" Group 1, drop index is 'BLORT.0
	   END

	   /* ============== Drop Stuff Dialog ============== */
	   WHEN RXWIND = "Drop Stuff" THEN DO
	   /* Display the selection for each of the 3 drop boxes */
	       RXSAY '"'RXWIND'" Group 1, drop 1 choice is "'BLORT.0'"'
	       RXSAY '"'RXWIND'" Group 1, drop 2 choice is "'CHOICE.0'"'
	       RXSAY '"'RXWIND'" Group 1, drop 3 choice is "'LIST.0'"'
	   END

	   /* ================= List 1 Dialog ================ */
	   WHEN RXWIND = "List 1" THEN DO
	   /* Display the selection for each of the 2 list boxes.
	       NOTE: This group is SINGLE SELECT */
	       RXSAY '"'RXWIND'" Group 1, list 1 choice is "'BLORT.0'"'
	       RXSAY '"'RXWIND'" Group 1, list 2 choice is "'LIST.0'"'
	   END

	   /* ============== MultiSelect Lists Dialog ============== */
	   WHEN RXWIND = "MultiSelect Lists" THEN DO
	   /* Let's check the result button to see if user pressed OK or
	       CANCEL, and if CANCEL, skip displaying the list selections.
	       NOTE: Since the MultiSelects Lists dialog had its
	       RESULT Flag set, RXDLG could also have returned because
	       user pressed the ENTER or ESC key while the dialog had the
	       Focus. In that case, our RESULT value is setup to either
	       FAILURE or SUCCESS.  In this case, since we only have 1
	       SUCCESS and 1 FAILURE type of button, and we specified BOOL,
	       the RESULT's value will be 1 for ESC and 0 for ENTER (ie,
	       the same as if he chose CANCEL or OK respectively). If we setup
	       a timeout, that would set the RESULT's value to 0 too */
	       IF RXVAL.2 = 1 THEN DO
		   /* Display the selections for BLORT (ie, first listbox in Group 1),
		       one by one */
		   DO i = 1 TO BLORT.0
		       RXSAY '"'RXWIND'" Group 1, list 1, choice 'i' is "'BLORT.0.i'"'
		   END
		   /* Display the selections for LIST, (ie, second listbox in Group 1)
		       one by one */
		   DO i = 1 TO LIST.0
		       RXSAY '"'RXWIND'" Group 1, list 1, choice 'i' is "'LIST.0.i'"'
		   END
	       END
	   END

	   /* ============== Electric Slide Dialog ============== */
	   WHEN RXWIND = "Electric Slide" THEN DO
	   /* Print out each slider's value */
	       DO i = 1 TO 2
		   PARSE VAR RXVAL.1 knob RXVAL.1
		   RXSAY '"'RXWIND'" Group 1, Slider #'i' = 'knob
	       END
	   END

	   /* ================ Main Window ================= */
	   WHEN RXWIND = "Main Window" THEN DO
	   /* Display each entry's text, one entry at a time */
	       DO i = 1 TO 4 /* There are 4 entries in this Group */
		   RXSAY '"'RXWIND'" Group 1, entry #'i' is "'TEXT.i'"'
	       END
	   END

       END
   END

   /* If this isn't the main window, then close this window (without
       setting up any variables again, ie, Operation 4). We let the user
       specifically decide when it's time to close the main window. Note
       that we could eliminate this if we just made all of our child dialogs
       without NOCLOSE. But don't try to close a window that was automatically
       closed by Rexx Dialog, or you'll get the "Can't find Rexx Dialog" error */
   IF RXWIND \= 'Main Window' & RXWIND \= '' THEN RXDLG '"'RXWIND'"' 4

/* Do another message loop */
SIGNAL more

/* =================================================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
