/* This demos how Rexx Dialog updates a window's dimensions string when the
 window is closed. Therefore, if a window is reopened using the same
 dimensions string, it reopens with the same size and position as when it was
 closed. This also demos how you can reopen a window with the same values for
 its Groups if you don't alter the returned RXVAL strings */

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* ================ Create "Spin Group" Dialog ================= */
/* First Group is SPIN */
RXTYPE.1 = 'SPIN'

/* Default */
RXFLAGS.1 = ''

/* Max, Min, Label for each slider, and groupbox */
RXLABEL.1 = '255 0 Range 1:| 20 10 Range 2:|Try us'

/* Values for each slider */
RXVAL.1 = '64 19'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '2 1 70'

/* Position */
RXX.1 = 80
RXY.1 = 18

RXWIN1 = '190 104 20 20'

RXDLG 1 '"Spin Group"' 'RXWIN1'  'RESULT'

/* Do user interaction */
RXDLG

/* Display "Spin Group" values */
values = RXVAL.1   /* Copy it so that we don't alter what was returned to us */
DO i = 1 TO 2
   PARSE VAR values knob values
   RXSAY 'Spin #'i' = 'knob
END





/* ================ Create "Spin Group" Dialog ================= */
/* Create the same dialog again. Leave the dialog's RXWIN1, and the Spin
    Group's RXVAL.1 strings, the same as the previous RXDLG returned. Note
    that the same location and spin values as used as what were returned the
    last time we created this dialog are used now */
RXDLG 1 '"Spin Group"' 'RXWIN1'

/* Do user interaction */
RXDLG

/* Display "Spin Group" values */
values = RXVAL.1
DO i = 1 TO 2
   PARSE VAR values knob values
   RXSAY 'Spin #'i' = 'knob
END





/* ========================== Done ========================== */
EXIT

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
