/* This creates a Main Window with a Group of radio buttons with the END
    flag set.  Whenever the user clicks upon a button, RXDLG returns, and
    we force the next radio button (after the selected button) to be selected.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is RADIO */
RXTYPE.1 = 'RADIO'

/* Use of a control in this group causes RXDLG to return. Also let RXDLG
    label the controls with numbers */
RXFLAGS.1 = 'END|NUMBERED'

/* Only need to specify Groupbox (or null string if none) because of NUMBERED */
RXLABEL.1 = 'Pick one'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '16 4 0'

/* Initially select button 1 */
RXVAL.1 = '1'

/* Position */
RXX.1 = 7
RXY.1 = 6

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Since there is only 1 group, we only need to pay attention to RXSUBID.
   It's the number of the selected button.  Since we didn't skip buttons, we
   simply increment this to get the next button #, but check that it isn't over
   16, because we only have 16 buttons
*/

IF RXSUBID = 16 THEN RXSUBID = 0
RXSET '""' 1 RXSUBID+1 'VAL' 1
SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
