.* RX3.IPF - Information Tag Language file for RX3.EXE new REXX commands.
:userdoc.
:Title.RX3 REXX Commands

.*============================================================================
.* RX3 REXX Commands
.*--------------------------------------------------------------
:h1 res=50000.RX3 REXX Commands
:i1 id=App.RX3 REXX Commands

:p.RX3.EXE adds the following REXX commands to both standard REXX (ie, PARSE,
LEFT, etc), plus Rexx Dialog (ie, RXDLG, RXSET, etc) commands.

:p.APPADD
.br
APPSUBTRACT

:p.A REXX script may use any of these commands.  The script must be
launched by RX3.EXE.

:p.In order to have automatic display of all error messages generated by these
functions, you should use RXERR to set the error display level to 50.

:p.The following pages describe each command's syntax, args, returns, etc.


.*--------------------------------------------------------------
.*   APPADD
.*--------------------------------------------------------------
:h2 res=50001.APPADD
:i2 refid=App.APPADD
:parml tsize=15 break=none.

:pt.:hp8.Template:ehp8.
:pd.APPADD number1 number2

:pt.:hp8.Description:ehp8.
:pd.This command adds number1 to number2 and returns the sum.

:pt.:hp8.Args:ehp8.
:p.:hp2.number1:ehp2. is the first number to add.

:p.:hp2.number2:ehp2. is the second number to add (to the first number).

:p.:hp8.Returns:ehp8.
:p.Sets the REXX variable :hp2.SUM:ehp2. to the resulting sum.

:eparml.

:p.:hp8.Examples:ehp8.
:p./* This adds 5 + 77 and displays the sum */

:p.APPADD 5 77
.br
RXSAY '5 + 77 =' SUM



.*--------------------------------------------------------------
.*   APPSUBTRACT
.*--------------------------------------------------------------
:h2 res=50002.APPSUBTRACT
:i2 refid=App.APPSUBTRACT
:parml tsize=15 break=none.

:pt.:hp8.Template:ehp8.
:pd.APPSUBTRACT number1 number2

:pt.:hp8.Description:ehp8.
:pd.This command subtracts number2 from number1 and returns the result.

:pt.:hp8.Args:ehp8.
:p.:hp2.number1:ehp2. is the number to subtract from.

:p.:hp2.number2:ehp2. is the second number to subtract (from the first number).

:p.:hp8.Returns:ehp8.
:p.Sets the REXX variable :hp2.ANSWER.0:ehp2. to the result.

:p.If number2 is larger than number1, then the error message "Second number
smaller than first" or error number 200:hp9.50:ehp9. (ie, display level of 50)
is returned.

:eparml.

:p.:hp8.Examples:ehp8.
:p./* This subtracts 5 from 77 and displays the result */

:p.APPSUBTRACT 77 5
.br
IF RC <> "" THEN RXSAY RC
.br
ELSE RXSAY '77 - 5 =' Answer.0




:euserdoc.
