/* This creates a Main Window with a Group of 2 LISTs, and RESULT flag set.
   Whenever the user presses ENTER, RXDLG returns, and if list box 1 is
   visible, we hide it (and its Label and ALL\NONE buttons).  If list box 1 is
   hidden, we show it (and its Label and ALL\NONE buttons)
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is LIST */
RXTYPE.1 = 'LIST'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'ALLNONE|MULTIPLE'

/* Label for control. Groupbox */
RXLABEL.1 = 'Choices:|More:|List'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '2 1 90 6'

/* REXX variable where initial text stored */
RXVAL.1 = 'STRS|PTRS'

/* Position */
RXX.1 = 15
RXY.1 = 15

/* Items for List 1 */
STRS.1 = 'all'
STRS.2 = 'none'
STRS.3 = 'something'
STRS.4 = 'more'
STRS.5 = 'more stuff'
STRS.6 = ' '

/* Items for List 2 */
PTRS.1 = '1'
PTRS.2 = '2'
PTRS.3 = '3'
PTRS.4 = ' '

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE|RESULT'

/* Initialize a flag that tells whether list is visible or invisible */
flag = 1

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Did user press the ENTER key while the window had the focus?
   Note that we haven't setup a timeout, nor set the KEYS flag
   of any window, so we don't need to check RXSUBID. It's always
   going to be 10 (ie, ENTER) here if RXID is 0 */
IF RXID = 0 THEN DO
   /* If list 1 is visible, hide the list, plus its label and ALL\NONE
      buttons. Note that if we changed the ControlNum arg to 0, then this
      would hide both lists as well as the Groupbox. We wouldn't need the
      final arg of 1 */
   IF flag = 1 THEN DO
       RXSET '""' 1 1 'HIDE' 1
       flag = 0
   END

   /* Show list 1, plus its label and ALL\NONE buttons */
   ELSE DO
       RXSET '""' 1 1 'SHOW' 1
       flag = 1
   END
END


SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
