/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*/
/*
 * Universal main routine.
 * solves the following problem:
 * when a processes' main threads ends it kill all sub threads
 * reguardless of weather they have more work to do.
 * This main routine solves this by waiting for all threads be for exiting.
 * it starts a main thread specified by user, then waits for all threads.
 * also it loads the argc and argv arguements into current application
 * before starting a thread that must be defined by user which will
 * do program main work.
 * program must  define  MainThreadFn::run()
 * which is code to do the work of the program.
 *
 */
#ifndef APPMAIN
#define APPMAIN
// define for applications and threads.
#include <iapp.hpp>
#include <ithread.hpp>
// class to enable thread
class MainThreadFn: public IThreadFn
{
   public:
        virtual void run( void );
};
// application must define MainThreadFn::run()
// to define main code to be run by the application.
#endif // APPMAIN
