/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef GLBCOLOR
#define GLBCOLOR
#include <ibcolor.hpp>

#include "Ltper.hpp"
#include "LtProf.hpp"


// pcolor is the essance of a IBaseColor
// can be constructed from a IBaseColor and
// conversion operator allows it to convert to one.
struct pcolor
{
   CharIntensity fRed, fGreen, fBlue, fOpacity;
   pcolor( const IBaseColor color )
   {
      fRed    = color.redMix();
      fGreen  = color.greenMix();
      fBlue   = color.blueMix();
      fOpacity= color.opacity();
   };
   pcolor( const IColor color )
   {
      fRed    = color.redMix();
      fGreen  = color.greenMix();
      fBlue   = color.blueMix();
      fOpacity= color.opacity();
   };
   // default constructor
   pcolor( )
   {
      fRed = fGreen = fBlue = fOpacity = 0;
   };
   operator IBaseColor() const
   {
      return IBaseColor( fRed, fGreen, fBlue, fOpacity );
   };
   operator IColor() const
   {
      return IColor( fRed, fGreen, fBlue, fOpacity );
   };
};


// a source of IColors.
// Can create IColor from a stored pcolor.
typedef ExternalExistance<IColor, pcolor, pcolor > ExternalColor;



// a source of IColor from application profiles.

class ColorStore
{
     private:
        ProfStorage storage;                  // Profile source.
        ExternalColor color_existance;          // ExternalExistance from profile.
     public:

        // constuctor. Profile from application name, user ini file.key=color.
        ColorStore() :
          storage("listpm","application_ini","color"),
          // external existance from profile.
          color_existance(storage)
          {};

        // key attribute from storage
        virtual void setKey( const IString& key )
        {
           storage.setKey( key );
        };
        virtual IString getKey() const
        {
           return storage.getKey();
        };

        virtual void deleteKey()
        {
           storage.deleteKey();
        };

        // returns true when key exists in profile.
        Boolean colorExternal(void) { return color_existance.ExistsExternally(); };

        // get IColor stored externally.
        operator IColor()
        {
           ExternalColor::Created created(color_existance);
//         return created.operator IColor();
           IColor rtn = created;
           return rtn;

        };

        // Store IColor in profile.
        ColorStore& operator<<(const IColor& color)
        {
           IColor tcolor(color);
           color_existance << tcolor;
           return *this;
        };
};


#endif //GLBCOLOR