#ifndef IOCTL_HEADER

#define INPUT  1
#define OUTPUT 2

typedef unsigned char BYTE;

/*
** used by function 46h
*/
typedef struct
  {
  BYTE ModemSigOn;
  BYTE ModemSigOff;
  }MDMSSIG;

/*
** used by extension function 7Ah
*/
typedef struct
  {
  ULONG ulBytesReceived;
  ULONG ulBytesTransmitted;
  }DIAGCOUNTS;

/*
** used by functions 42h and 62h
*/
typedef struct
  {
  BYTE DataBits;
  BYTE Parity;
  BYTE StopBits;
  BYTE bTransmittingBreak;    // return value only (function 42h)
  }LINECHAR;

/*
** used by function 43h
*/
typedef struct
  {
  LONG lBaudRate;
  BYTE byFraction;     // byFraction is not used by COMi and will always be zero
  }BAUDRT;

/*
** used by function 43h
*/
typedef struct
  {
  BAUDRT stCurrentBaud;
  BAUDRT stLowestBaud;
  BAUDRT stHighestBaud;
  }BAUDST;

/*
** DCB used by functions 53h and 73h
*/
typedef struct _DCB
  {
  USHORT WrtTimeout;
  USHORT ReadTimeout;
  BYTE Flags1;
  BYTE Flags2;
  BYTE Flags3;
  BYTE ErrChar;
  BYTE BrkChar;
  BYTE XonChar;
  BYTE XoffChar;
 }DCB;

typedef struct
  {
  USHORT usByteCount;
  USHORT usQueueLen;
  USHORT usQueueHigh;
  }BUFCNT;

typedef struct
  {
  USHORT usXonThreshold;      // default is receive buffer size divided by two
  USHORT usXoffThreshold;     // default is four times FIFO size, or 32 bytes without FIFOs
  BYTE byMaxWritePackets;     // default is six
  BYTE byMaxReadPackest;      // defualt is six
  }DDTHRESHOLDS;

typedef struct
  {
  USHORT usFIFOsize;          // UART FIFO size
  USHORT usTxFIFOload;        // current transmit FIFO load count
  USHORT usFIFOflags;         // current FIFO flags, see below for definitions
  ULONG ulReserved;
  }FIFOINF;

typedef struct
  {
  USHORT usTxFIFOload;        // new transmit FIFO load count
  USHORT usFIFOflags;         // new FIFO flags, see below
  ULONG ulReserved;
  }FIFODEF;

#ifdef allow_16650_HDW_Xon_HS       // will not be supported until Startech makes it work
 #define FIFO_FLG_HDW_TX_XON_HS           0x0100
 #define FIFO_FLG_HDW_RX_XON_HS           0x0200
 #define FIFO_FLG_HDW_HS_MASK             0x0f00
#else
 #define FIFO_FLG_HDW_HS_MASK             0x0c00
#endif
#define FIFO_FLG_HDW_CTS_HS              0x0400
#define FIFO_FLG_HDW_RTS_HS              0x0800
#define FIFO_FLG_EXPLICIT_TX_LOAD        0x4000
#define FIFO_FLG_LOW_16750_TRIG          0x8000
#define FIFO_FLG_NO_DCB_UPDATE           0x2000
#define FIFO_FLG_NO_HDW_HS_SUPPORT       0x1000
#define FIFO_FLG_MASK                    0xf000

/*
** IOCTL.DLL function prototypes
*/
APIRET SetModemSignals(HFILE hCom,BYTE byOnByte,BYTE byOffByte,USHORT *pwCOMerror);
APIRET GetModemInputSignals(HFILE hCom,BYTE *pbySignals);
APIRET GetModemOutputSignals(HFILE hCom,BYTE *pbySignals);
APIRET GetXmitStatus(HFILE hCom,BYTE *pbyCOMstatus);
APIRET GetReceiveQueueLen(HFILE hCom,USHORT *pwQueueLen,USHORT *pwByteCount);
APIRET GetReceiveQueueCounts(HFILE hCom,BUFCNT *pstCounts);
APIRET GetTransmitQueueLen(HFILE hCom,USHORT *pwQueueLen,USHORT *pwByteCount);
APIRET BreakOff(HFILE hCom,USHORT *pwCOMerror);
APIRET BreakOn(HFILE hCom,USHORT *pwCOMerror);
APIRET GetCOMerror(HFILE hCom,USHORT *pwCOMerror);
APIRET GetCOMstatus(HFILE hCom,BYTE *pbyCOMstatus);
APIRET GetCOMevent(HFILE hCom,USHORT *pwCOMevent);
APIRET SendByteImmediate(HFILE hCom,BYTE bySendByte);
APIRET ForceXon(HFILE hCom);
APIRET ForceXoff(HFILE hCom);
APIRET GetDCB(HFILE hCom,DCB *pstComDCB);
APIRET SendDCB(HFILE hCom,DCB *pstComDCB);
APIRET GetLineCharacteristics(HFILE hCom,LINECHAR *pstLineChar);
APIRET SetLineCharacteristics(HFILE hCom,LINECHAR *pstLineChar);
APIRET SetBaudRate(HFILE hCom,LONG lBaud);
APIRET GetBaudRate(HFILE hCom,LONG *plBaud);
APIRET GetBaudRates(HFILE hCom,BAUDST *pstBaudRates);
APIRET FlushComBuffer(HFILE hCom,USHORT wDirection);
APIRET GetFIFOinfo(HFILE hCom,FIFOINF *pstFIFOinfo);
APIRET SetFIFO(HFILE hCom,FIFODEF *pstFIFOcontrol);
APIRET GetCountsSinceLast(HFILE hCom,DIAGCOUNTS *pstCounts);

#define IC_ATM_ERRMSG_INVALID_PARAM 3626
#define IC_ATM_ERRMSG_GEN_FAIL  3627
#define IC_ATM_ERRMSG_BAD_COMMAND 3628
#define IC_ATM_ERRMSG_UNKNOWN_ERROR 3629
#define IC_ATM_GET_DIAG_COUNTS     3630

#define IC_ATM_SET_FIFO_LOAD 3625
#define IC_ATM_GET_FIFO     3624

#define IC_ATM_TXIMM        3623
#define IC_ATM_ERRORCD      3622
#define IC_ATM_FUNCTION     3621
#define IC_ATM_IOCTL        3620
#define IC_ATM_FLUSH        3619
#define IC_ATM_COMEVENTS    3618
#define IC_ATM_COMEVENT     3617
#define IC_ATM_COMERROR     3616
#define IC_ATM_XMITSTAT     3615
#define IC_ATM_COMSTAT      3614
#define IC_ATM_BRKON        3613
#define IC_ATM_BRKOFF       3612
#define IC_ATM_RCVQLEN      3611
#define IC_ATM_TXQLEN       3610
#define IC_ATM_LINEWRT      3609
#define IC_ATM_LINERD       3608
#define IC_ATM_DCBWRT       3607
#define IC_ATM_DCBRD        3606
#define IC_ATM_BAUDWRT      3605
#define IC_ATM_BAUDRD       3604
#define IC_ATM_FXOFF        3603
#define IC_ATM_FXON         3602
#define IC_ATM_MDMGET       3601
#define IC_ATM_MDMSET       3600

#define IOCTL_HEADER

#endif
