/*
inetcfg.cmd
Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
mckinnis@attglobal.net

REXX Program to set parameter for the inetlog.cmd and ijoylog.cmd
and convert existing an existing inetlog.ini file to inetcfg.cfg
*/

Trace 'N'
version = '7.1'
what_r_we = 'INETCFG  v'||version 'Copyright 2000 by Chuck McKinnis'
Parse Upper Arg otherparms

/* Where are we ? */
Parse Source . . install_path .
inetlog_program = install_path
install_path = Filespec('D',install_path) || Filespec('P',install_path)
ini_file = install_path || 'inetlog.ini'
cfg_file = install_path || 'inetcfg.cfg'
cfg_save = install_path || 'inetcfg.sav'
save_path = Directory()
our_path = Strip(install_path, 'T', '\')
our_path = Directory(our_path)
pmrexx_obj = SysSearchPath('PATH', 'PMREXX.EXE')

pmrexx = 0
If Wordpos('/PMREXX', otherparms) > 0 Then
   Do
      If pmrexx_obj <> '' Then
         pmrexx = 1
      Else
         Do
            Say 'PMREXX.EXE is not in your current PATH'
            pmrexx = 0
         End
   End
Else
   Do
      If Wordpos('/NOPMREXX', otherparms) = 0 Then
         Do
            If pmrexx_obj <> '' Then
               Do
                  Parse Source . . inetlog_program .
                  Address cmd '@START "Internet Log Configuration" /PM /I' pmrexx_obj inetlog_program otherparms '/PMREXX'
                  Exit 0
               End
            Else
               Do
                  Say 'PMREXX.EXE is not in your current PATH'
                  pmrexx = 0
               End
         End
      pmrexx = 0
   End

/* Right to freely use, modify, distribute granted but please acknowledge
   source as a courtesy if you build upon it.  Please pass on comments,
   suggestions, problems to mckinnis@attglobal.net */

/* The following are acceptable command-line parameters for special runs.
    Only one of these can be used in a run and case is ignored.

      /NOPMREXX run without using PMREXX

   The following are acceptable command-line parameters (case is ignored):

   These parameters can be overridden on a run by run basis only.

      /RESET ini file parameters to defaults and re-initialize

*/
If Rxfuncquery('SysDropFuncs') Then
   Do
      Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call SysLoadFuncs
   End
If Rxfuncquery('RxExtra') Then
   Do
      Call Rxfuncadd 'RxExtra', 'RxExtras', 'RxExtra'
      Call RxExtra 'LOAD'
   End

Signal On Failure Name errhandler
Signal On Halt Name errhandler
Signal On Syntax Name errhandler

Call SysCls

Call Read_config                              /* read the config file */

Call Reset_config otherparms           /* check for config file reset */

Call Check_config                    /* check for config file updates */

Call Write_config                            /* write the config file */

Call Cleanup                                   /* end of main program */

/* read the config file */
Read_config:
trace_save = Trace('N')
Trace 'N'
If RxFileExists(cfg_file) Then            /* do we have a config file */
   input_file = cfg_file
Else
   Do
      If RxFileExists(cfg_save) Then
         input_file = cfg_save
      Else
         Do
            Call Config_sample               /* use the sample values */
            input_file = 'sample'
         End
   End

Say 'Using configuration file -' input_file
If input_file <> 'sample' Then
   Call RxRead 'data.', input_file
Else
   Call RxStemCopy 'cfg_sample.', 'data.'
config. = ''
config.0 = data.0
Do i = 1 To data.0
   config.i = data.i
   If Abbrev(data.i, ';') | Abbrev(data.i, '[') Then
      Nop
   Else
      Do
         Parse Var data.i key_id '=' key_value
         key_id = Strip(key_id)
         key_value = "'" || Strip(key_value) || "'"
         Interpret key_id '=' key_value
      End
End
Call Convert_ini ini_file              /* update from an old ini file */
Trace(trace_save)
Return

/* convert or update config using an existing ini file */
Convert_ini:
trace_save = Trace('N')
Trace 'N'
Parse Arg ini_file
If RxFileExists(ini_file) ,
   & File_cmd(ini_file, 'D') > File_cmd(input_file, 'D') Then
   Do
      ini_key = 'IGN InJoy DataPath DisplayDailyReport PauseAsScreenFills' ,
         'WarnPercent ConnectDigits MinuteDigits HourDigits'
      key_key = 'ibm_dialer injoy_dialer data_path daily_report one_screen_at_a_time' ,
         'warn_pct sig_x sig_min sig_hr'
      /* get all keys */
      xrc = SysIni(ini_file, 'COMMON', 'ALL:', 'keys.')
      If keys.0 > 0 Then
         Do i = 1 To keys.0                 /* get all the key values */
            key_id = Word(key_key, Wordpos(keys.i, ini_key))
            key_value = "'" || SysIni(ini_file, 'COMMON', keys.i) || "'"
            Interpret key_id '=' key_value
         End
      ini_key = 'IniFileName OutputFileName SummaryFileName LastTimeStamp'
      key_key = 'ibm_dialer_ini_file ibm_output_file ibm_summary_file ibm_last_time_stamp'
      /* get all keys */
      xrc = SysIni(ini_file, 'INETLOG', 'ALL:', 'keys.')
      If keys.0 > 0 Then
         Do i = 1 To keys.0                 /* get all the key values */
            key_id = Word(key_key, Wordpos(keys.i, ini_key))
            key_value = "'" || SysIni(ini_file, 'INETLOG', keys.i) || "'"
            Interpret key_id '=' key_value
         End
      ini_key = 'InJoyOutput InJoySummary'
      key_key = 'injoy_output_file injoy_summary_file'
      /* get all keys */
      xrc = SysIni(ini_file, 'IJOYLOG', 'ALL:', 'keys.')
      If keys.0 > 0 Then
         Do i = 1 To keys.0                 /* get all the key values */
            key_id = keys.i
            If Wordpos(key_id, ini_key) > 0 Then
               Do
                  key_id = Word(key_key, Wordpos(keys.i, ini_key))
                  key_value = "'" || SysIni(ini_file, 'IJOYLOG', keys.i) || "'"
                  Interpret key_id '=' key_value
               End
         End
      injoy_total_logs = SysIni(ini_file, 'IJOYLOG', 'InJoyLogs')
      log_value = ''
      acct_value = ''
      user_value = ''
      time_value = ''
      Do i = 1 To injoy_total_logs
         key = 'InJoyLog_' || i
         log_value = log_value SysIni(ini_file, 'IJOYLOG', key)
         If log_value = 'ERROR:' Then
            log_value = Word(SysIni(ini_file, 'IJOYLOG', 'InJoyLog'), i)
         key = 'InJoyAcct_' || i
         acct_value = acct_value SysIni(ini_file, 'IJOYLOG', key)
         If acct_value = 'ERROR:' Then
            acct_value = Word(SysIni(ini_file, 'IJOYLOG', 'InJoyAcct'), i)
         key = 'InJoyUser_' || i
         user_value = user_value SysIni(ini_file, 'IJOYLOG', key)
         If user_value = 'ERROR:' Then
            user_value = Word(SysIni(ini_file, 'IJOYLOG', 'InJoyUser'), i)
         key = 'InJoyTimeStamp_' || i
         time_value = time_value SysIni(ini_file, 'IIJOYLOG', key)
         If time_value = 'ERROR:' Then
            time_value = Word(SysIni(ini_file, 'IJOYLOG', 'InJoyTimeStamp'), i)
      End
      key_id = 'injoy_logs'
      Interpret key_id '=' "'" || Strip(log_value) || "'"
      key_id = 'injoy_accts'
      Interpret key_id '=' "'" || Strip(acct_value) || "'"
      key_id = 'injoy_users'
      Interpret key_id '=' "'" || Strip(user_value) || "'"
      key_id = 'injoy_times'
      Interpret key_id '=' "'" || Strip(time_value) || "'"
      Call Write_config
      Address cmd '@rename' ini_file 'inetini.sav > nul'
   End
Trace(trace_save)
Return

/* reset config file to defaults */
Reset_config:
trace_save = Trace('N')
Trace 'N'
Parse Upper Arg otherparms
If Wordpos('/RESET', otherparms) > 0 Then
   Do
      /* load sample data */
      Call Config_sample
      /* find location of each application */
      Call RxStemSearch '[COMMON]', 'cfg_sample.', 'found.', 'N'
      Parse Var found.1 common_start .
      order.1 = Right(common_start, 5)
      Call RxStemSearch '[INETLOG]', 'cfg_sample.', 'found.', 'N'
      Parse Var found.1 inetlog_start .
      order.2 = Right(inetlog_start, 5)
      Call RxStemSearch '[IJOYLOG]', 'cfg_sample.', 'found.', 'N'
      Parse Var found.1 ijoylog_start .
      order.3 = Right(ijoylog_start, 5)
      order.4 = Right(cfg_sample.0, 5)
      order.0 = 4
      Call RxSort 'order.'
      order = Space(order.1 order.2 order.3 order.4)
      Say 'Reset all common data in -'
      Say cfg_file '(y/N)'
      Parse Upper Pull ans .
      If Abbrev(ans, 'Y') Then
         Do
            start = common_start + 1
            next = Word(order, Wordpos(common_start, order) + 1) - 1
            appl_id = 'common'
            Do i = start To next
               If \Abbrev(cfg_sample.i, ';') Then
                  Do
                     Parse Var cfg_sample.i key_id '=' key_value
                     key_id = Strip(key_id)
                     key_value = "'" || Strip(key_value) || "'"
                     Interpret key_id '=' key_value
                  End
            End
            Call Write_config
         End
      Say 'Reset all IBM dialer data in -'
      Say cfg_file '(y/N)'
      Parse Upper Pull ans .
      If Abbrev(ans, 'Y') Then
         Do
            start = inetlog_start + 1
            next = Word(order, Wordpos(inetlog_start, order) + 1) - 1
            appl_id = 'inetlog'
            Do i = start To next
               If \Abbrev(cfg_sample.i, ';') Then
                  Do
                     Parse Var cfg_sample.i key_id '=' key_value
                     key_id = Strip(key_id)
                     key_value = "'" || Strip(key_value) || "'"
                     Interpret key_id '=' key_value
                  End
            End
            ibm_dialer = ''
            Call Write_config
         End
      Say 'Reset all InJoy dialer data in -'
      Say cfg_file '(y/N)'
      Parse Upper Pull ans .
      If Abbrev(ans, 'Y') Then
         Do
            start = ijoylog_start + 1
            next = Word(order, Wordpos(ijoylog_start, order) + 1) - 1
            appl_id = 'ijoylog'
            Do i = start To next
               If \Abbrev(cfg_sample.i, ';') Then
                  Do
                     Parse Var cfg_sample.i key_id '=' key_value
                     key_id = Strip(key_id)
                     key_value = "'" || Strip(key_value) || "'"
                     Interpret key_id '=' key_value
                  End
            End
            injoy_dialer = ''
            Call Write_config
         End
   End
Trace(trace_save)
Return

/* update the config file */
Check_config:
trace_save = Trace('N')
Trace 'N'
/* path to data files */
If data_path = '' Then
   Do
      data_path = install_path || 'data\'
      Call Write_config
   End
/* create the data path sub-directory if needed */
If \RxFileExists(data_path || '*.*') Then
   xrc = SysMkDir(Strip(data_path, , '\'))
/* IBM dialer support */
If ibm_dialer = '' Then
   Do
      Say 'Support the IBM dialer (y/N)?'
      Parse Upper Pull ans .
      key_value = Abbrev(ans, 'Y')
      ibm_dialer = key_value
      Call Write_config
   End
/* InJoy dialer support */
If injoy_dialer = '' Then
   Do
      Say 'Support the InJoy dialer (y/N)?'
      Parse Upper Pull ans .
      key_value = Abbrev(ans, 'Y')
      injoy_dialer = key_value
      Call Write_config
   End

/* process IBM dialer entries */
If ibm_dialer Then
   Do
      /* dialer ini file */
      If ibm_dialer_ini_file = '' Then
         Do
            Say 'Please select your IBM dialer by number'
            Say '   1 - DIALER.EXE (1.67 and below)'
            Say '   2 - TCPDIAL.EXE (1.69 and above)'
            Parse Upper Pull ans .
            Select
               When ans = 1 Then
                  key_value = 'dialer.ini'
               When ans = 2 Then
                  key_value = 'tcpdial.ini'
               Otherwise Do
                  Say 'You did not chose a supported dialer'
                  key_value = ''
               End
            End
            ibm_dialer_ini_file = key_value
            Call Write_config
         End
   End

/* process InJoy dialer entries */
If injoy_dialer Then
   Do
      If injoy_logs = '' Then
         Do
            /* get path to InJoy */
            Say 'Enter the full path to the InJoy Dialer logs or hit enter to quit.'
            Parse Upper Pull ans .
            If ans <> '' Then
               Do
                  /* get all *.log file names */
                  log_path = ans
                  rc = SysFileTree(log_path || '\*.log', 'logs.', 'FO')
                  /* loop through log file names to see the user wants them included */
                  If rc = 0 & logs.0 > 0 Then
                     Do i = 1 To logs.0
                        Say 'Found InJoy log file -' logs.i
                        Say 'Analyze this log (y/N)'
                        Parse Upper Pull ans
                        If Abbrev(ans, 'Y') Then
                           Do
                              injoy_logs = Space(injoy_logs logs.i)
                           End
                     End
                  Else
                     Do
                        Say 'Unable to locate any logs in InJoy log path -' ans
                        Say 'InJoy logs in' ans 'will not be processed.'
                     End
               End
            Else
               Say 'InJoy logs will not be processed'
            injoy_accts = ''
            injoy_users = ''
            injoy_times = ''
            Do i = 1 To Words(injoy_logs)
               joylog = Word(injoy_logs, i)
               joyacct = Word(injoy_accts, i)
               joyuser = Word(injoy_users, i)
               joytime = Word(injoy_times, i)
               If joyacct = '' Then
                  Do
                     Say 'Enter an account id for InJoy log (enter = none)'
                     								say joylog
                     Parse Pull joydata
                     If joydata = '' Then
                        joydata = 'none'
                     injoy_accts = Strip(injoy_accts joydata)
                  End
               If joyuser = '' Then
                  Do
                     Say 'Enter an user id for InJoy log (enter = none)'
                     Say joylog
                     Say 'and account id -' joydata
                     Parse Pull joydata
                     If joydata = '' Then
                        joydata = 'none'
                     injoy_users = Strip(injoy_users joydata)
                  End
               If joytime = '' Then
                  Do
                     joydata = 'T00000000000000'
                     injoy_times = Strip(injoy_times joydata)
                  End
            End
            Call Write_config
         End
   End
Trace(trace_save)
Return

/* write the config file */
Write_config:
trace_save = Trace('N')
Trace 'N'
If RxFileExists(cfg_file) Then            /* do we have a config file */
   Do
      If RxFileExists(cfg_save) Then
         Call SysFileDelete(cfg_save)
      Address cmd '@rename' cfg_file Filespec('N', cfg_save) '> nul'
   End
Do i = 1 To config.0
   If Abbrev(config.i, ';') | Abbrev(config.i, '[') Then
      Nop
   Else
      Do
         Parse Var config.i key_id '=' key_value
         key_id = Strip(key_id)
         config.i = key_id '=' Value(key_id)
      End
End
Call RxWrite 'config.', cfg_file
Trace(trace_save)
Return

Errhandler:
Call Beep 300, 500
Say 'Rexx error' rc 'in line' sigl||':' Errortext(rc)
Say Sourceline(sigl)
Call Cleanup
Return

Cleanup:                                                      /* Exit */
If \pmrexx Then
   answer = Say_message('Press any key to exit...')
Else
   Call SysSleep 2
save_path = Directory(save_path)
Exit
Return                                                 /* for Cleanup */

/* performs common Stream commands and returns 1 or a date if successful */
File_cmd: Procedure Expose result
trace_save = Trace('N')
Trace 'N'
Parse Arg file_name, command
command = Translate(command)
Select
   When command = 'X' Then
      Do
         result = Stream(file_name, 'C', 'QUERY EXISTS')
         answer = (result <> '')
      End
   When command = 'C' Then
      Do
         result = Stream(file_name, 'C', 'CLOSE')
         answer = Abbrev(result,'READY') | (result = '')
      End
   When command = 'W' Then
      Do
         result = Stream(file_name, 'C', 'OPEN WRITE')
         answer = Abbrev(result,'READY')
      End
   When command = 'R' Then
      Do
         result = Stream(file_name, 'C', 'OPEN READ')
         answer = Abbrev(result,'READY')
      End
   When command = 'D' Then
      Do
         result = Stream(file_name, 'C', 'QUERY DATETIME')
         If result <> '' Then
            Do
               Parse Var result date time
               date = Dateconv(Translate(date, '/', '-'), 'U', 'S')
               Parse Var time hr ':' min ':' sec
               answer = Strip(date) || Strip(hr) || Strip(min) || Strip(sec)
            End
         Else
            answer = '00000000000000'
      End
   Otherwise answer = 0
End
Trace (trace_save)
Return answer

Say_out:                             /* performs output to the screen */
Procedure Expose quiet
trace_save = Trace('N')
If quiet Then
   Return
Parse Arg line
Say line
Trace (trace_save)
Return

Say_message:       /* performs message output and returns key entered */
Procedure Expose quiet
trace_save = Trace('N')
Parse Arg msg
Say msg
answer = SysGetKey('NOECHO')
Trace (trace_save)
Return answer

Log_file_parms: Procedure
trace_save = Trace('N')
Parse Arg dialer_ini_name, dialer_ini
Select
   When Translate(dialer_ini_name) = 'DIALER.INI' Then
      Do
         dlog_eparm = 'AdvLog'
         dlog_nparm = 'Cfn'
         dlog_sparm = 'Cfs'
      End
   When Translate(dialer_ini_name) = 'TCPDIAL.INI' Then
      Do
         dlog_eparm = 'Common'
         dlog_nparm = 'LoggingCfn'
         dlog_sparm = 'LoggingCfs'
      End
   Otherwise Do
      Say 'Unable to recognize dialer ini file'
      Call Cleanup
      Exit
   End
End
dialer_log_file = Strip(SysIni(dialer_ini, dlog_eparm, dlog_nparm),,'00'x)
dialer_log_size = C2d(Left(SysIni(dialer_ini, dlog_eparm, dlog_sparm),3))
Trace (trace_save)
Return dialer_log_file dialer_log_size

/* set up config sample values */
Config_sample: Procedure Expose cfg_sample.
trace_save = Trace('N')
Trace 'N'
data_queue = INetSmp('config')
old_queue = Rxqueue('Set', data_queue)
cfg_sample.0 = Queued()
Do i = 1 To cfg_sample.0
   Parse Pull cfg_sample.i
End
rx_queue = Rxqueue('Delete', data_queue)
Trace(trace_save)
Return
