/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX.
exit
*/
/*----------------------------------------------*/
/*-- REXX                                     --*/
/*----------------------------------------------*/
/*-- PROGRAM NAME:                            --*/
/*-- install                                  --*/
/*--                                          --*/
/*-- DESCRIPTION:                             --*/
/*-- Installs System Configuration Editor     --*/
/*----------------------------------------------*/
/*-- AUTHOR:                                  --*/
/*-- Kelly Schrock                            --*/
/*----------------------------------------------*/
/*-- DATE:                                    --*/
/*-- 07.07.93                                 --*/
/*----------------------------------------------*/

TRACE n
signal on HALT
call LoadLibs

/*-- get the command line --*/
parse arg sourcedir destdir

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Please enter a directory name for System Configuration Editor'
  say '(Default: C:\CSED):'
  parse pull destdir
  /*-- if error --*/
  if destdir = ' ' then do
    destdir = 'C:\CSED'
  end
end

if sourcedir = ' ' then do
  thisdir = directory()
  say ''
  say 'Please enter the directory where the program is being installed'
  say 'from(Default: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
    say 'using the current directory as the source directory.'
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

/*-- do main screen --*/
call SysCls
say
say '                   System Configuration Editor Installation'
say
say 'System Configuration Editor will be Installed with the following settings:'
say
say 'Source directory: "'sourcedir'"'
say 'Destination directory: "'destdir'"'
say
say 'Okay to continue(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
  say
  say 'Installation cancelled.'
  exit
end

/*-- see if the dest directory exists --*/
Call SysFileTree destdir, file, 'D'

if file.0 = '0' then do
  say 'The directory: 'destdir' does not exist on your hardfile. Create it(Y/n)?'
  k = SysGetKey('NOECHO')
  if k = 'N'| k = 'n' then do
    say
    say 'Installation cancelled.'
    exit
  end
  /*-- create the dest. dir --*/
  rc = SysMkDir(destdir)
  if rc = 0 then do
    say 'The directory ' destdir ' was created successfully.'
  end
  else do
    say 'The directory ' destdir ' could not be created successfully; cancelling.'
    exit
  end
end

/*-- copy the files --*/
call SysCls
say
say 'Install is copying files, please wait...'
call CopyFile 'CSED.EXE',       sourcedir,    destdir
call CopyFile 'CSED.INF',       sourcedir,    destdir
call CopyFile 'CSED.HLP',       sourcedir,    destdir
call CopyFile 'CSED.ICO',       sourcedir,    destdir
call CopyFile 'README.TXT',     sourcedir,    destdir
call CopyFile 'LISCENSE.TXT',   sourcedir,    destdir
call CopyFile 'REGISTER.TXT',   sourcedir,    destdir
call CopyFile 'FILE_ID.DIZ',    sourcedir,    destdir

/*-- create a program object --*/
call SysCls
say
say 'System Configuration Editor can be installed as an object on your desktop.'
say 'Do you want to create it now(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call GoodBye

say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "Configuration Editor",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<CSEDFLDR>;ICONFILE="||destdir||"\CSED.ICO", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end

say 'Adding the'
say 'Manual,'
x = SysCreateObject("WPProgram",,
                    "Manual",,
                    "<CSEDFLDR>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\CSED.INF")

say 'ReadMe file,'
x = SysCreateObject("WPProgram",,
                    "Read Me",,
                    "<CSEDFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\README.TXT")

say 'Registration form,'
x = SysCreateObject("WPProgram",,
                    "Registration",,
                    "<CSEDFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\REGISTER.TXT")

say 'Liscense agreement,'
x = SysCreateObject("WPProgram",,
                    "Liscense Agreement",,
                    "<CSEDFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\LISCENSE.TXT")

say 'and the Program file.'
x = SysCreateObject("WPProgram",,
                    "Configuration Editor",,
                    "<CSEDFLDR>",,
                    "EXENAME="||destdir||"\CSED.EXE;STARTUPDIR="||destdir)


GoodBye:
/*-- exit with a goodbye --*/
say
say 'Done.'
say
say
say 'System Configuration Editor has been installed on your system.'
say
say 'Be sure to read the file README.TXT for up-to-date information.'
say
say 'Press any key to exit installation...'
k = SysGetKey('NOECHO')
call SysCls
"@start e.exe "||destdir||"\readme.txt"
exit

/*----------------------------------------------*/
/*-- FUNCTION:                                --*/
/*-- LoadLibs                                 --*/
/*-- ACTION:                                  --*/
/*-- loads the libraries needed by this REXX  --*/
/*----------------------------------------------*/
LoadLibs:
  if RxFuncQuery('SysLoadFuncs') THEN
  do
    /*-- load the load-function --*/
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    /*-- load the Sys* utilities --*/
    CALL SysLoadFuncs
  end
return

HALT:
  say
  say 'User interrupted program.'
  exit

/*-----------------------------------------------------------------------------*/
/*-- CopyFile                                                                --*/
/*-----------------------------------------------------------------------------*/
CopyFile: Arg ArgFile2Copy, ArgFloppyDir, ArgInstallDir

    Say 'Copying 'ArgFloppyDir||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'...'
    Command = '@Copy 'ArgFloppyDir||ArgFile2Copy' 'ArgInstallDir||'\'||ArgFile2Copy' >NUL'
    Command
    if rc \= 0 Then Do
        say 'Error! 'ArgFile2Copy' was not installed properly.'
        Pull ConfirmIt
    End
    Return


