/* INIinst - Install / UnInstall for INI tools */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit /* End of INIinst.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
PARSE PULL action
SELECT
    WHEN TRANSLATE(LEFT(action,1)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(LEFT(action,1)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
PARSE ARG noinstmsg
SAY noinstmsg
SAY 'Press Enter to exit ...'
PULL answer
CALL SysCls
Exit /* End of NoAction */

/* InstallMe - install INI tools */

InstallMe:  PROCEDURE

toolname = 'INItools 1.2.0'
prgname = 'INI editor 1.2.0'
chkfiles = 'INIedit.exe Inibmp32.dll ENGLISH.INI'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||prgname||' can not be installed in root directory.'
    SAY 'Create directory for '||prgname||', copy files: '||chkfiles||' there and start this procedure again.'
    SAY 'Press Enter to exit ...'
    PULL answer
    Exit
END

CALL SysCls
SAY 'Welcome to '||toolname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Create Folder "OS/2 System Tools" on your Desktop (if folder does not exist),'
SAY '- Create Program objects for '||prgname||','
SAY '- Associate *.INI files with '||prgname||' (option),'
SAY '- Add '||toolname||' specific entries in OS2.INI file - App ToolsByGoran.'
SAY 'Press "Y" (and Enter) to start Installation, Enter to exit...'
PARSE PULL answer

IF TRANSLATE(LEFT(answer,1)) <> "Y" THEN DO
    CALL NoAction 'Installation aborted'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(chkfiles)
    CALL SysFiletree Directory()||'\'||WORD(chkfiles,i), 'chkfile', 'FO'
    SELECT
    WHEN chkfile.0 = 1 THEN SAY '- '||LEFT(WORD(chkfiles,i),12)||' - OK'
    OTHERWISE CALL NoAction LEFT(WORD(chkfiles,i),12)||' - Missing file. Installation failed!'
    END
END

SAY ' '
SAY 'Writing entries to OS2.INI'
dummy = SysIni('USER','ToolsByGoran','INItool120WorkDir',Directory())
SAY 'Working directory - '||Rc1(dummy)
dummy = SysIni('USER','ToolsByGoran','INItool120INIfile',Directory()||'\INITOOLS.INI')
SAY 'INI file - '||Rc1(dummy)

SAY ' '
SAY 'Writing default values to INITOOLS.INI'
CALL SysIni 'INITOOLS.INI', 'Host', '127.0.0.1', '8000'
CALL SysIni 'INITOOLS.INI', 'Language', 'ENGLISH', 'English.inf'
CALL SysIni 'INITOOLS.INI', 'General', 'CurrHost', '127.0.0.1'
CALL SysIni 'INITOOLS.INI', 'General', 'CurrLang', 'ENGLISH'
CALL SysIni 'INITOOLS.INI', 'General', 'FastHex', '1'
CALL SysIni 'INITOOLS.INI', 'General', 'FileList', '1'
CALL SysIni 'INITOOLS.INI', 'General', 'SafeMode', '1'
CALL SysIni 'INITOOLS.INI', 'General', 'ShowAll', '1'
CALL SysIni 'INITOOLS.INI', 'General', 'OnExit', '1'
CALL SysIni 'INITOOLS.INI', 'General', 'PosEdit', '50 20'
CALL SysIni 'INITOOLS.INI', 'General', 'Size', '550 460'
CALL SysIni 'INITOOLS.INI', 'General', 'FontP', '9.WarpSans'
CALL SysIni 'INITOOLS.INI', 'General', 'FontM', '10.System VIO'

SAY 'Writing INI files to database'
CALL SysIni 'INITOOLS.INI', 'DataBase', Directory()||'\INITOOLS.INI', 'OS2'
CALL SysIni 'INITOOLS.INI', 'DataBase', Directory()||'\ENGLISH.INI', 'OS2'
CALL SysIni 'INITOOLS.INI', 'DataBase', VALUE('USER_INI',,'OS2ENVIRONMENT'), 'OS2'
CALL SysIni 'INITOOLS.INI', 'DataBase', VALUE('SYSTEM_INI',,'OS2ENVIRONMENT'), 'OS2'

SAY ' '
assocme = 0
SAY 'Do you want to associate *.INI files with '||prgname||'? (Y/N)'
PARSE PULL answer
IF TRANSLATE(answer) = 'Y' THEN DO
    assocme = 1
END

SAY ' '
InstallDir = Directory()
WorkDir = Directory()

FoldTitle='OS/2 System Tools'
Icon1=Directory()||'\Folder1.ico'
Icon2=Directory()||'\Folder2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<GISYSTOOLS_FOLD>;'||Icon||''
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

FoldTitle='Help'
Setup='OBJECTID=<GISYSTOOLS_HELP>'
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

ProgTitle = prgname
EXE = 'INIedit.exe'
ICO = 'INIedit.ico'
Setup = 'OBJECTID=<INIEDIT120_PROGRAM>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
IF assocme = 1 THEN DO
    Setup = 'OBJECTID=<INIEDIT120_PROGRAM>;EXENAME='InstallDir'\'EXE';ASSOCFILTER=*.INI;ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
END
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' Program object - '||Rc2(dummy)

ProgTitle = toolname||'^English manual'
EXE = 'View.exe'
INF = 'English.inf'
Setup = 'OBJECTID=<INITOOL120_HENG>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_HELP>',Setup,Action)
SAY 'Creating '||prgname||' English manual - '||Rc2(dummy)

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall INI tools */

UnInstallMe: PROCEDURE

prgname = 'INI tools 1.2.0'
CALL SysCls
SAY 'This is '||prgname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Remove '||prgname||' specific entries in OS2.INI file, App ToolsByGoran.'
SAY '- Destroy '||prgname||' Program object'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer
IF answer <> "Y" THEN DO
    CALL NoAction 'UnInstall terminated.'
END
SAY ' '
SAY 'Removing entries from OS2.INI'
CALL SysIni 'USER','ToolsByGoran','INItool120lWorkDir','DELETE:'
CALL SysIni 'USER','ToolsByGoran','INItool120INIfile','DELETE:'
SAY ' '
SAY 'Destroying Program object'
CALL SysDestroyObject '<INITOOL120_HENG>'
CALL SysDestroyObject '<INITOOL120_PROGRAM>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||prgname||' again, start INIinst I. Press Enter to exit...'
PULL answer
RETURN /* End of UnInstallMe */

/* Rc1 - return code - SysIni */

Rc1:        PROCEDURE

PARSE ARG rcSysIni
SELECT
    WHEN rcSysIni = 'ERROR:' THEN rc1 = 'Error writing to INI file!'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1 /* End of Rc1 */

/* Rc2 - return code - SysCreateObject */

Rc2:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysIni = 0 THEN rc2 = 'Error'
    OTHERWISE rc2 = 'OK'
END
RETURN rc2 /* End of Rc2 */
