/* Update 1 - Swedish NLS */

IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
SAY 'Ŀ'
SAY 'INI tools Version 1.10                                                       '
SAY 'Update 1 (1999-12-27): Swedish Language support                              '
SAY ''
SAY ''
IF SysIni('USER','ToolsByGoran','INItoolsWorkDir') = 'ERROR:' THEN DO
    errmsg = 'INI tools are not installed! Please install INI tools (Install.exe).'
    CALL IsError errmsg
END
CALL SysFileTree DIRECTORY()||'\INITOOLS.INI','found','F'
IF found.0 = 0 THEN DO
    errmsg = 'INITOOLS.INI not found in: '||DIRECTORY()||'. Please correct error.'
    CALL IsError errmsg
END
CALL SysFileTree DIRECTORY()||'\INSTALL.INI','found','F'
IF found.0 = 0 THEN DO
    errmsg = 'INSTALL.INI not found in: '||DIRECTORY()||'. Please correct error.'
    CALL IsError errmsg
END
SAY ' '
CALL SysFileTree DIRECTORY()||'\SWEDISH.INI','found','F'
IF found.0 = 0 THEN DO
    dummy = BEEP(400,250)
    SAY 'SWEDISH.INI not found in: '||DIRECTORY()||'.'
    SAY 'Swedish Language support will not be installed.'
END
IF found.0 > 0 THEN DO
    SAY 'Updating INITOOLS.INI (SWEDISH Language support).'
    dummy = SysIni('INITOOLS.INI','Language','SWEDISH','Swedish.inf')
    IF dummy = 'ERROR:' THEN DO
	CALL Problem 'SWEDISH'
    END
    SAY 'Updating INSTALL.INI (SWEDISH Language support).'
    dummy = SysIni('INSTALL.INI','INI','LanguageSWEDISH','Swedish.inf')
    dummy = SysIni('INSTALL.INI','WPS','WPProgram<INITOOLS_FOLD><INITOOLS_HENG>','INI tools^English manualView.exeEnglish.inf0U0')
    dummy = SysIni('INSTALL.INI','WPS','WPProgram<INITOOLS_FOLD><INITOOLS_HSWE>','INI tools^Swedish manualView.exeSwedish.inf0U0')
    IF dummy = 'ERROR:' THEN DO
	CALL Problem1 'SWEDISH'
    END
    dummy = SysIni('INSTALL.INI','WPS','WPProgram<INITOOLS_FOLD><INITOOLS_HELP>','DELETE:')
    infname=DIRECTORY()||'\English.inf'
    setup='OBJECTID=<INITOOLS_HENG>;EXENAME=VIEW.EXE;PARAMETERS='||infname||';STARTUPDIR='||DIRECTORY()
    dummy=SysCreateObject('WPProgram', 'INI tools^English manual', '<INITOOLS_FOLD>', setup, 'U')
    SAY 'Creating Object in INI tools folder (Swedish manual).'
    infname=DIRECTORY()||'\Swedish.inf'
    setup='OBJECTID=<INITOOLS_HSWE>;EXENAME=VIEW.EXE;PARAMETERS='||infname||';STARTUPDIR='||DIRECTORY()
    dummy=SysCreateObject('WPProgram', 'INI tools^Swedish manual', '<INITOOLS_FOLD>', setup, 'U')
    dummy=SysDestroyObject('<INITOOLS_HELP>')
END
SAY ' '
SAY 'Finished! Press Enter to exit...'
PULL answer
Exit

/* Kraj Update */

Problem:	PROCEDURE

PARSE ARG problang
SAY ''
SAY 'Problem!'
SAY problang||' Language support not added to INI tools.'
SAY 'Open INITOOLS.INI with INI editor and add new Key in Application Language:'
SAY 'Key - '||problang||', Value - Swedish.inf'
Return

Problem1:	PROCEDURE

PARSE ARG problang
SAY ''
SAY 'Problem!'
SAY problang||' Language support not added to INSTALL.INI.'
SAY 'Open INSTALL.INI with INI editor and add new Key in Application INI:'
SAY 'Key - Language'||problang||', Value - Swedish.inf'
Return

IsError:	PROCEDURE

PARSE ARG errmsg
SAY 'Error !!!'
dummy = BEEP(400,250)
SAY errmsg
SAY 'Then run this procedure again.'
SAY ''
SAY 'Press Enter to exit...'
PULL answer
Exit

/* Kraj IsError */