/****************************************************************/
/*                        SelectTNI.cmd                         */
/*                                                              */
/*  Decides whether to use INI data in INI format or TNI        */
/*  Returns 0 for INI, 1 for TNI.  Although this may be called  */
/*  from the command line, it is mainly intended to be called   */
/*  from other Rexx scripts.                                    */
/*                                                              */
/*         Author:       Peter Moylan (peter@pmoylan.org)       */
/*         Last revised: 2 February 2019                        */
/*                                                              */
/*  Usage:  useTNI = SelectTNI(appname)                         */
/*              where appname is a string, e.g. "Weasel"        */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PARSE ARG appname
Iname = appname".INI"
Tname = appname".TNI"
useINI = STREAM(Iname, 'C', 'QUERY EXISTS') \= ''
useTNI = STREAM(Tname, 'C', 'QUERY EXISTS') \= ''

/* If only one of the files exists, the decision is obvious.    */
/* If neither exists, default to using INI.                     */

IF (useINI = 0) | (useTNI = 0) THEN RETURN useTNI

/* That leaves the case where both files exist.  In that case   */
/* we look up the entry ($SYS, UseTNI) in each file.            */

useTNI0 = SysIni(Iname, "$SYS", "UseTNI")
foundI = (useTNI0 \= "ERROR:")
IF foundI THEN useTNI0 = C2D(useTNI0)
 ELSE useTNI0 = 0

useTNI = INIget(Tname, "$SYS", "UseTNI")
foundT = LENGTH(useTNI) > 0
IF foundT THEN useTNI = C2D(useTNI)
 ELSE useTNI = 0

/* If both entries missing, default to using INI.  */

IF \(foundI | foundT) THEN RETURN 0

/* If only one entry exists, use it. */

IF foundI \= foundT THEN
    DO
        IF foundI THEN useTNI = useTNI0
        RETURN useTNI;
    END

/* The only remaining case is where both entries exist. */

IF useTNI0 = useTNI THEN RETURN useTNI
ELSE RETURN 0

/****************************************************************/

