/**
***  This is a part of the DCFVBA project.   This set of functions handle
***  The PCL datastreams beginning with:  <Esc>(
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dcfvba.h"

/* -------------------------------------------------------------------------- */

void pcl_paren(void)
   {
   char   pcl_command;

   double number;  /* holds PCL argument */
   next_char();
   pcl_command = (char)toupper(*current);
   switch(pcl_command)
      {
      case 'S':
         {
         do
            {
            next_char();
            number = get_pcl_arg();
            pcl_paren_S(number);
            }
         while(strchr(PCL_END_SET,*current) == NULL);
         break;
         } /* case 'S' */
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
         {
         number = get_pcl_arg();
         pcl_paren_number(number);
         break;
         }
      default:
         {
         char error_message[255];

         sprintf(error_message,"Unsupported PCL command: <Esc>(%c",*current);
         error(error_message,8);
         } /* default */
      } /* switch */
   } /* pcl_paren */

/* -------------------------------------------------------------------------- */

void pcl_paren_S(double number)
   {
   char pcl_char;

   pcl_char = (char)toupper(*current);
   switch(pcl_char)
      {
      case 'B': /* Bold */
         {
         if (number == 3)  /* Bold on */
            {
            new_line();
            fputs(".bf bold\n",vba_file);
            bold = 1;
            }
         else
         if ((number == 0) ||
             (number == -3))
            {
            if (bold)
               {
               new_line();
               fputs(".pf\n",vba_file);
               strcpy(line,".ct ");
               bold = 0;
               }
            }
         else
            error("Invalid PCL datastream",12);
         break;
         }
      case 'H': /* Set pitch */
         {
         if (number != 10)
            error("Unsupported pitch",0);
         break;
         }
      case 'P': /* Proportional spacing */
         {
         if (number != 0)
            error("Proportional spacing not supported",0);
         break;
         }
      case 'S': /* Italics */
         {
         if (number == 0)
            {
            if (italics)
               {
               new_line();
               fputs(".us off\n",vba_file);
               strcpy(line,".ct ");
               italics = 0;
               }
            break;
            }
         else
         if (number == 1)
            {
            new_line();
            fputs(".us on\n",vba_file);
            italics = 1;
            break;
            }
         else
            error("Invalid PCL data stream",12);
         } /* case 'S' */
      case 'T': /* Select typeface */
         {
         if (number != 3)
            error("Unsupported typeface",0);
         break;
         }
      case 'U': /* Super/sub script */
         {
         if (number != 0)
            (number == 1) ?
                 error("Superscript not supported",0) :
                 error("Subscript not supported",0);
         break;
         }
      case 'V': /* Character height */
         {
         if (number != 12)
            error("Unsupported character height",0);
         break;
         }
      default:
         error("Invalid PCL datastream",12);
      } /* switch */
   }

/* -------------------------------------------------------------------------- */

void pcl_paren_number(double number)
   {
   char pcl_char;

   pcl_char = (char)toupper(*current);
   switch(pcl_char)
      {
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'K':
      case 'S':
         {
         error("Unsupported font selection",0);
         break;
         }
      case 'U': /* IBM PC U.S.A */
         {
         if (number != 10)
            error("Unsupported font selection",0);
         break;
         }
      case '@': /* Font default */
         {
         error("Font default PCL command not supported",0);
         break;
         }
      default:
         error("Invalid PCL datastream",12);
      } /* switch */
   }
