#include <stdio.h>
#include <stdlib.h>


long double **makematrix( long dim )
{
    long double  *data, **matrix;
    long    z, s;

    if ( (data = (long double*) malloc( sizeof( long double) * dim * dim ) ) == NULL )
    {
        fprintf( stderr, "no Mem" );
        exit ( 1 );
    }

    if ( (matrix = (long double**) malloc( sizeof( long double*) * dim ) ) == NULL )
    {
        fprintf( stderr, "no Mem" );
        exit ( 1 );
    }

    for ( z=0; z<dim; z++)
        matrix[z] = data + z * dim;

    for ( z=0; z<dim; z++ )
        for ( s=0; s<dim; s++ )
            matrix[z][s] = 0;

    return( matrix );
}

