/* 
   drvDXF.cpp : This file is part of pstoedit 

   Copyright (C) 1993,1994,1995,1996 Wolfgang Glunz, Wolfgang.Glunz@zfe.siemens.de

	DXF Backend Version 0.9 ( LINEs only, no Text, no color, no linewidth )
	(see #ifdef aslines )
	Carsten Hammer	chammer@post.uni-bielefeld.de
   	CATS Gesellschaft fuer technische DV-Anwendungen mbH
	Carl-Zeiss-Strasse 65
	33334 Guetersloh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <string.h>
#include <iostream.h>

#include "drvdxf.h"

class DXFColor {
public:
// The SparcCompiler wants to have this public in order to initialize DXFColors
struct rgbcolor {
	unsigned short r;
	unsigned short g;
	unsigned short b;
};

private:
static const rgbcolor DXFColors[];
static const unsigned short numberOfColors;
public:
static unsigned int getDXFColor(float r, float g, float b)
{
	float mindist = 1.0f;
	unsigned int best = 0;
	for (unsigned int i = 0 ; i < numberOfColors; i++) {
		const float dxfr = DXFColors[i].r / 255.0f;
		const float dxfg = DXFColors[i].g / 255.0f;
		const float dxfb = DXFColors[i].b / 255.0f;
		const float dr = dxfr - r;
		const float dg = dxfg - g;
		const float db = dxfb - b;
		const float dist = dr * dr + dg * dg + db * db;
		if (dist == 0.0 ) {
//			errf << "Found exact match for " << r << " "
//				<< g << " " << b << " " << i  << " " << numberOfColors << endl;
			return i;
		} else if (dist < mindist) {
			best = i;
			mindist = dist;
		}
	}
//	errf << "Found approximation for " << r << " "
//		<< g << " " << b << " " << best  << " " << mindist  << " " << numberOfColors << endl;
	return best;
}
};
const DXFColor::rgbcolor DXFColor::DXFColors[] = {
        { 0x00, 0x00, 0x00 },      //0
        { 0xFF, 0x00, 0x00 },
        { 0xFF, 0xFF, 0x00 },
        { 0x00, 0xFF, 0x00 },
        { 0x00, 0xFF, 0xFF },
        { 0x00, 0x00, 0xFF },      //5
        { 0xFF, 0x00, 0xFF },
        { 0xFF, 0xFF, 0xFF },
        { 0x41, 0x41, 0x41 },
        { 0x80, 0x80, 0x80 },
        { 0xFF, 0x00, 0x00 },      //10
        { 0xFF, 0xAA, 0xAA },
        { 0xBD, 0x00, 0x00 },
        { 0xBD, 0x7E, 0x7E },
        { 0x81, 0x00, 0x00 },
        { 0x81, 0x56, 0x56 },      //15
        { 0x68, 0x00, 0x00 },
        { 0x68, 0x45, 0x45 },
        { 0x4F, 0x00, 0x00 },
        { 0x4F, 0x35, 0x35 },
        { 0xFF, 0x3F, 0x00 },      //20
        { 0xFF, 0xBF, 0xAA },
        { 0xBD, 0x2E, 0x00 },
        { 0xBD, 0x8D, 0x7E },
        { 0x81, 0x1F, 0x00 },
        { 0x81, 0x60, 0x56 },      //25
        { 0x68, 0x19, 0x00 },
        { 0x68, 0x4E, 0x45 },
        { 0x4F, 0x13, 0x00 },
        { 0x4F, 0x3B, 0x35 },
        { 0xFF, 0x7F, 0x00 },      //30
        { 0xFF, 0xD4, 0xAA },
        { 0xBD, 0x5E, 0x00 },
        { 0xBD, 0x9D, 0x7E },
        { 0x81, 0x40, 0x00 },
        { 0x81, 0x6B, 0x56 },      //35
        { 0x68, 0x34, 0x00 },
        { 0x68, 0x56, 0x45 },
        { 0x4F, 0x27, 0x00 },
        { 0x4F, 0x42, 0x35 },
        { 0xFF, 0xBF, 0x00 },      //40
        { 0xFF, 0xEA, 0xAA },
        { 0xBD, 0x8D, 0x00 },
        { 0xBD, 0xAD, 0x7E },
        { 0x81, 0x60, 0x00 },
        { 0x81, 0x76, 0x56 },      //45
        { 0x68, 0x4E, 0x00 },
        { 0x68, 0x5F, 0x45 },
        { 0x4F, 0x3B, 0x00 },
        { 0x4F, 0x49, 0x35 },
        { 0xFF, 0xFF, 0x00 },      //50
        { 0xFF, 0xFF, 0xAA },
        { 0xBD, 0xBD, 0x00 },
        { 0xBD, 0xBD, 0x7E },
        { 0x81, 0x81, 0x00 },
        { 0x81, 0x81, 0x56 },      //55
        { 0x68, 0x68, 0x00 },
        { 0x68, 0x68, 0x45 },
        { 0x4F, 0x4F, 0x00 },
        { 0x4F, 0x4F, 0x35 },
        { 0xBF, 0xFF, 0x00 },      //60
        { 0xEA, 0xFF, 0xAA },
        { 0x8D, 0xBD, 0x00 },
        { 0xAD, 0xBD, 0x7E },
        { 0x60, 0x81, 0x00 },
        { 0x76, 0x81, 0x56 },      //65
        { 0x4E, 0x68, 0x00 },
        { 0x5F, 0x68, 0x45 },
        { 0x3B, 0x4F, 0x00 },
        { 0x49, 0x4F, 0x35 },
        { 0x7F, 0xFF, 0x00 },      //70
        { 0xD4, 0xFF, 0xAA },
        { 0x5E, 0xBD, 0x00 },
        { 0x9D, 0xBD, 0x7E },
        { 0x40, 0x81, 0x00 },
        { 0x6B, 0x81, 0x56 },      //75
        { 0x34, 0x68, 0x00 },
        { 0x56, 0x68, 0x45 },
        { 0x27, 0x4F, 0x00 },
        { 0x42, 0x4F, 0x35 },
        { 0x3F, 0xFF, 0x00 },      //80
        { 0xBF, 0xFF, 0xAA },
        { 0x2E, 0xBD, 0x00 },
        { 0x8D, 0xBD, 0x7E },
        { 0x1F, 0x81, 0x00 },
        { 0x60, 0x81, 0x56 },      //85
        { 0x19, 0x68, 0x00 },
        { 0x4E, 0x68, 0x45 },
        { 0x13, 0x4F, 0x00 },
        { 0x3B, 0x4F, 0x35 },
        { 0x00, 0xFF, 0x00 },      //90
        { 0xAA, 0xFF, 0xAA },
        { 0x00, 0xBD, 0x00 },
        { 0x7E, 0xBD, 0x7E },
        { 0x00, 0x81, 0x00 },
        { 0x56, 0x81, 0x56 },      //95
        { 0x00, 0x68, 0x00 },
        { 0x45, 0x68, 0x45 },
        { 0x00, 0x4F, 0x00 },
        { 0x35, 0x4F, 0x35 },
        { 0x00, 0xFF, 0x3F },      //100
        { 0xAA, 0xFF, 0xBF },
        { 0x00, 0xBD, 0x2E },
        { 0x7E, 0xBD, 0x8D },
        { 0x00, 0x81, 0x1F },
        { 0x56, 0x81, 0x60 },      //105
        { 0x00, 0x68, 0x19 },
        { 0x45, 0x68, 0x4E },
        { 0x00, 0x4F, 0x13 },
        { 0x35, 0x4F, 0x3B },
        { 0x00, 0xFF, 0x7F },      //110
        { 0xAA, 0xFF, 0xD4 },
        { 0x00, 0xBD, 0x5E },
        { 0x7E, 0xBD, 0x9D },
        { 0x00, 0x81, 0x40 },
        { 0x56, 0x81, 0x6B },      //115
        { 0x00, 0x68, 0x34 },
        { 0x45, 0x68, 0x56 },
        { 0x00, 0x4F, 0x27 },
        { 0x35, 0x4F, 0x42 },
        { 0x00, 0xFF, 0xBF },      //120
        { 0xAA, 0xFF, 0xEA },
        { 0x00, 0xBD, 0x8D },
        { 0x7E, 0xBD, 0xAD },
        { 0x00, 0x81, 0x60 },
        { 0x56, 0x81, 0x76 },      //125
        { 0x00, 0x68, 0x4E },
        { 0x45, 0x68, 0x5F },
        { 0x00, 0x4F, 0x3B },
        { 0x35, 0x4F, 0x49 },
        { 0x00, 0xFF, 0xFF },      //130
        { 0xAA, 0xFF, 0xFF },
        { 0x00, 0xBD, 0xBD },
        { 0x7E, 0xBD, 0xBD },
        { 0x00, 0x81, 0x81 },
        { 0x56, 0x81, 0x81 },      //135
        { 0x00, 0x68, 0x68 },
        { 0x45, 0x68, 0x68 },
        { 0x00, 0x4F, 0x4F },
        { 0x35, 0x4F, 0x4F },
        { 0x00, 0xBF, 0xFF },      //140
        { 0xAA, 0xEA, 0xFF },
        { 0x00, 0x8D, 0xBD },
        { 0x7E, 0xAD, 0xBD },
        { 0x00, 0x60, 0x81 },
        { 0x56, 0x76, 0x81 },      //145
        { 0x00, 0x4E, 0x68 },
        { 0x45, 0x5F, 0x68 },
        { 0x00, 0x3B, 0x4F },
        { 0x35, 0x49, 0x4F },
        { 0x00, 0x7F, 0xFF },      //150
        { 0xAA, 0xD4, 0xFF },
        { 0x00, 0x5E, 0xBD },
        { 0x7E, 0x9D, 0xBD },
        { 0x00, 0x40, 0x81 },
        { 0x56, 0x6B, 0x81 },      //155
        { 0x00, 0x34, 0x68 },
        { 0x45, 0x56, 0x68 },
        { 0x00, 0x27, 0x4F },
        { 0x35, 0x42, 0x4F },
        { 0x00, 0x3F, 0xFF },      //160
        { 0xAA, 0xBF, 0xFF },
        { 0x00, 0x2E, 0xBD },
        { 0x7E, 0x8D, 0xBD },
        { 0x00, 0x1F, 0x81 },
        { 0x56, 0x60, 0x81 },      //165
        { 0x00, 0x19, 0x68 },
        { 0x45, 0x4E, 0x68 },
        { 0x00, 0x13, 0x4F },
        { 0x35, 0x3B, 0x4F },
        { 0x00, 0x00, 0xFF },      //170
        { 0xAA, 0xAA, 0xFF },
        { 0x00, 0x00, 0xBD },
        { 0x7E, 0x7E, 0xBD },
        { 0x00, 0x00, 0x81 },
        { 0x56, 0x56, 0x81 },      //175
        { 0x00, 0x00, 0x68 },
        { 0x45, 0x45, 0x68 },
        { 0x00, 0x00, 0x4F },
        { 0x35, 0x35, 0x4F },
        { 0x3F, 0x00, 0xFF },      //180
        { 0xBF, 0xAA, 0xFF },
        { 0x2E, 0x00, 0xBD },
        { 0x8D, 0x7E, 0xBD },
        { 0x1F, 0x00, 0x81 },
        { 0x60, 0x56, 0x81 },      //185
        { 0x19, 0x00, 0x68 },
        { 0x4E, 0x45, 0x68 },
        { 0x13, 0x00, 0x4F },
        { 0x3B, 0x35, 0x4F },
        { 0x7F, 0x00, 0xFF },      //190
        { 0xD4, 0xAA, 0xFF },
        { 0x5E, 0x00, 0xBD },
        { 0x9D, 0x7E, 0xBD },
        { 0x40, 0x00, 0x81 },
        { 0x6B, 0x56, 0x81 },      //195
        { 0x34, 0x00, 0x68 },
        { 0x56, 0x45, 0x68 },
        { 0x27, 0x00, 0x4F },
        { 0x42, 0x35, 0x4F },
        { 0xBF, 0x00, 0xFF },      //200
        { 0xEA, 0xAA, 0xFF },
        { 0x8D, 0x00, 0xBD },
        { 0xAD, 0x7E, 0xBD },
        { 0x60, 0x00, 0x81 },
        { 0x76, 0x56, 0x81 },      //205
        { 0x4E, 0x00, 0x68 },
        { 0x5F, 0x45, 0x68 },
        { 0x3B, 0x00, 0x4F },
        { 0x49, 0x35, 0x4F },
        { 0xFF, 0x00, 0xFF },      //210
        { 0xFF, 0xAA, 0xFF },
        { 0xBD, 0x00, 0xBD },
        { 0xBD, 0x7E, 0xBD },
        { 0x81, 0x00, 0x81 },
        { 0x81, 0x56, 0x81 },      //215
        { 0x68, 0x00, 0x68 },
        { 0x68, 0x45, 0x68 },
        { 0x4F, 0x00, 0x4F },
        { 0x4F, 0x35, 0x4F },
        { 0xFF, 0x00, 0xBF },      //220
        { 0xFF, 0xAA, 0xEA },
        { 0xBD, 0x00, 0x8D },
        { 0xBD, 0x7E, 0xAD },
        { 0x81, 0x00, 0x60 },
        { 0x81, 0x56, 0x76 },      //225
        { 0x68, 0x00, 0x4E },
        { 0x68, 0x45, 0x5F },
        { 0x4F, 0x00, 0x3B },
        { 0x4F, 0x35, 0x49 },
        { 0xFF, 0x00, 0x7F },      //230
        { 0xFF, 0xAA, 0xD4 },
        { 0xBD, 0x00, 0x5E },
        { 0xBD, 0x7E, 0x9D },
        { 0x81, 0x00, 0x40 },
        { 0x81, 0x56, 0x6B },      //235
        { 0x68, 0x00, 0x34 },
        { 0x68, 0x45, 0x56 },
        { 0x4F, 0x00, 0x27 },
        { 0x4F, 0x35, 0x42 },
        { 0xFF, 0x00, 0x3F },      //240
        { 0xFF, 0xAA, 0xBF },
        { 0xBD, 0x00, 0x2E },
        { 0xBD, 0x7E, 0x8D },
        { 0x81, 0x00, 0x1F },
        { 0x81, 0x56, 0x60 },      //245
	{ 0x68, 0x00, 0x19 },
        { 0x68, 0x45, 0x4E },
        { 0x4F, 0x00, 0x13 },
        { 0x4F, 0x35, 0x3B },
        { 0x33, 0x33, 0x33 },      //250
        { 0x50, 0x50, 0x50 },
        { 0x69, 0x69, 0x69 },
        { 0x82, 0x82, 0x82 },
        { 0xBE, 0xBE, 0xBE },
        { 0xFF, 0xFF, 0xFF }      //255
};

const unsigned short DXFColor::numberOfColors = sizeof(DXFColor::DXFColors) / sizeof(DXFColor::rgbcolor);



drvDXF::drvDXF(const char * driveroptions_p,ostream & theoutStream, ostream & theerrStream/* , float theMagnification */ ):
        drvbase(driveroptions_p,theoutStream,theerrStream,0,0,0)
/*	,magnification(theMagnification) */
{
outf << "999\nDXF generated by pstoedit\n";
outf << "  0\nSECTION\n  2\nHEADER\n";
outf << "  9\n$ACADVER\n  1\nAC1009\n";
outf << "  9\n$EXTMIN\n 10\n0.0\n 20\n0.0\n 30\n0.0\n";
outf << "  9\n$EXTMAX\n 10\n1000.0\n 20\n1000.0\n 30\n0.0\n";
outf << "  9\n$FILLMODE\n 70\n     0\n";
outf << "  0\nENDSEC\n";

outf << "  0\nSECTION\n  2\nTABLES\n";
// Layers
outf << "  0\nTABLE\n  2\nLAYER\n 70\n   255\n" ;
outf << "  0\nLAYER\n  2\n0\n 70\n     0\n 62\n     7\n  6\nCONTINUOUS\n";
outf << "  0\nENDTAB\n";
outf << "  0\nENDSEC\n";

outf << "  0\nSECTION\n  2\nENTITIES\n";
}

drvDXF::~drvDXF() 
{
outf << "  0\nENDSEC\n  0\nEOF\n";
}

void drvDXF::print_coords()
{
}

void drvDXF::close_page()
{
/*outf << "#Seite beendet.\n";*/
}

void drvDXF::open_page()
{
/*outf << "#Seite Nr. " << currentPageNumber << "\n";*/
}

void drvDXF::show_text(const TextInfo & textinfo)
{
	outf << "  0\nTEXT\n  8\n0\n";
	// color
	outf << " 62\n     " << DXFColor::getDXFColor(textinfo.currentR, textinfo.currentG, textinfo.currentB)
	     << "\n";
	outf << " 10\n" << textinfo.x << "\n";
	outf << " 20\n" << textinfo.y << "\n";
	outf << " 30\n" << 0.0 << "\n";
	outf << " 40\n" << textinfo.currentFontSize << "\n";
	outf << "  1\n" << textinfo.thetext << "\n";
	outf << " 50\n" << textinfo.currentFontAngle << "\n";
}

void drvDXF::show_path()
{
#ifdef aslines
	for(unsigned int t=1;t<numberOfElementsInPath();t++) {
		const Point & p = pathElement(t-1).getPoint(0);
		const Point & q = pathElement(t).getPoint(0);
		outf << "  0\nLINE\n  8\n0\n";
		outf << " 10\n" << p.x_ << "\n";
		outf << " 20\n" << p.y_ << "\n";
		outf << " 30\n" << 0 << "\n";
		outf << " 11\n" << q.x_ << "\n";
		outf << " 21\n" << q.y_ << "\n";
		outf << " 31\n" << 0.0 << "\n";
	}
#else
// to do: check for "lineto" only
	const float lineWidth = currentLineWidth();
	outf << "  0\nPOLYLINE\n  8\n0\n"; 
	// color
	outf << " 62\n     " << DXFColor::getDXFColor(currentR(), currentG(), currentB())
	     << "\n";
	// vertex flag (always 1)
	outf << " 66\n     1\n";
	// base point
	outf << " 10\n0.0\n 20\n0.0\n 30\n0.0\n";
	if (isPolygon()) {
		outf << " 70\n     1\n";
	}
	// start and end line width
	outf << " 40\n" << lineWidth << "\n 41\n" << lineWidth << "\n";
	for(unsigned int t=0;t<numberOfElementsInPath();t++) {
		const Point & p = pathElement(t).getPoint(0);
		outf << "  0\nVERTEX\n  8\n0\n";
		outf << " 10\n" << p.x_ << "\n";
		outf << " 20\n" << p.y_ << "\n";
		outf << " 30\n" << 0.0 << "\n";
		outf << " 40\n" << lineWidth << "\n 41\n" << lineWidth << "\n";
	}
	outf << "  0\nSEQEND\n";
#endif
};

void drvDXF::show_rectangle(const float llx, const float lly, const float urx, const float ury)
{
// just do show_polyline for a first guess
  unused(&llx);
  unused(&lly);
  unused(&urx);
  unused(&ury);
	 show_path();
}
