/* Esstu Archive - archives a list of files into an S2Data file */
PARSE ARG ARC CMDOPT ARGS
IF (ARC="")|(TRANSLATE(ARC,"-HH","/h?")="-H") THEN SIGNAL HELP
CALL SETVARS
CMD=TRANSLATE(LEFT(CMDOPT,1))
OPT=SUBSTR(CMDOPT,2)
SELECT
	WHEN CMD="A" THEN CALL ADD ARC,OPT,ARGS
	WHEN CMD="X" THEN CALL EXTRACT ARC,OPT,ARGS
	WHEN CMD="V" THEN CALL VIEW ARC,OPT,ARGS
	OTHERWISE SAY "Invalid command - use S2ARC -H for help."
END
EXIT

HELP:
SAY "S2ARC - File archiver/dearchiver using the S2Data format"
SAY
SAY "Usage:"
SAY "S2ARC [archive] [command] [files]"
SAY
SAY "archive	Archive file (eg .S2A) to manipulate"
SAY "command	Command to perform"
SAY "files	List of files to archive/dearchive (if omitted on dearchiving all files extracted)"
SAY
SAY "Commands:"
SAY "A	Add file(s)"
SAY "X	Extract file(s)"
SAY "V	View archive"
SAY
EXIT

SETVARS:
S2DSIG="S2D"'FB0D0A1A0A'x
RETURN

ADD: PROCEDURE EXPOSE S2DSIG
PARSE ARG ARC,OPT,ARGS
IF STREAM(ARC,"C","QUERY EXISTS")="" THEN CALL CHAROUT ARC,S2DSIG
ELSE DO
	SIG=CHARIN(ARC,,LENGTH(S2DSIG))
	CALL STREAM ARC,"C","CLOSE"
	IF SIG\=S2DSIG THEN DO
		SAY ARC" is not a valid S2Data file or signature is corrupt."
		RETURN
	END
END
OPT.=0
DO I=1 TO LENGTH(OPT)
	O=TRANSLATE(SUBSTR(OPT,I))
	OPT.O=1
END
DO I=1 TO WORDS(ARGS)
	"@FOR %%D IN ("WORD(ARGS,I)") DO @ECHO %%D|RXQUEUE /FIFO" /**** THIS WORKS ON OS/2 BUT MAY NOT ON ALL SYSTEMS ****/
	DO WHILE QUEUED()>0
		PARSE PULL F
		IF F=ARC THEN ITERATE
		SAY "Archiving "F
		DATA=CHARIN(F,,CHARS(F))
		CALL STREAM F,"C","CLOSE"
		/* String up the two subchunks (NAME and DATA) to make the chunk data for the FIlE */
		CHUNKDATA="NAME"RIGHT(D2C(LENGTH(F)),4,"00"x)F||STRINGCRC(F)"DATA"RIGHT(D2C(LENGTH(DATA)),4,"00"x)DATA||STRINGCRC(DATA)
		CALL CHAROUT ARC,"FIlE"RIGHT(D2C(LENGTH(CHUNKDATA)),4,"00"x)CHUNKDATA||STRINGCRC(CHUNKDATA)
	END
END
CALL CHAROUT ARC
RETURN

EXTRACT: PROCEDURE
PARSE ARG ARC,OPT,ARGS
SIG=CHARIN(ARC,,8)
IF SIG\="S2D"'FB0D0A1A0A'x THEN DO
	SAY "Not an S2Data file"
	CALL STREAM ARC,"C","CLOSE"
	RETURN
END
CALL READSUBCHUNKS CHARIN(ARC,,CHARS(ARC))
DO I=1 TO CHUNK..0 /* Yes, TWO dots - kludgey technique to simplify READSUBCHUNKS code */
	IF WORD(CHUNK..I,1)="FIlE" THEN DO
		NAME=""
		DO J=1 TO CHUNK..I.0
			IF WORD(CHUNK..I.J,1)="NAME" THEN NAME=SUBWORD(CHUNK..I.J,2)
			IF WORD(CHUNK..I.J,1)="DATA" THEN DATA=SUBWORD(CHUNK..I.J,2)
		END
		IF NAME="" THEN SAY "*** Error in data file - bad or missing NAME chunk ***"
		ELSE IF DATA="" THEN SAY "*** Error in data file - bad or missing DATA chunk ***"
		ELSE DO
			/* Should check to see if in list of filespecs (in ARGS) */
			SAY "Extracting "NAME
			CALL CHAROUT NAME,DATA
			CALL CHAROUT NAME
		END
	END
END
RETURN

VIEW: PROCEDURE
PARSE ARG ARC,OPT,ARGS
SIG=CHARIN(ARC,,8)
IF SIG\="S2D"'FB0D0A1A0A'x THEN DO
	SAY "Not an S2Data file"
	CALL STREAM ARC,"C","CLOSE"
	RETURN
END
CALL READSUBCHUNKS CHARIN(ARC,,CHARS(ARC))
DO I=1 TO CHUNK..0 /* Yes, TWO dots - kludgey technique to simplify READSUBCHUNKS code */
	IF WORD(CHUNK..I,1)="FIlE" THEN DO
		NAME=""
		DO J=1 TO CHUNK..I.0
			IF WORD(CHUNK..I.J,1)="NAME" THEN NAME=SUBWORD(CHUNK..I.J,2)
		END
		IF NAME="" THEN SAY "*** Error in data file - bad or missing NAME chunk ***"
		ELSE SAY NAME
	END
END
RETURN

READSUBCHUNKS: PROCEDURE EXPOSE CHUNK.
PARSE ARG DATA,TAIL
N=0
DO WHILE DATA\=""
	PARSE VALUE DATA WITH ID 5 LENGTH 9 DATA
	LENGTH=C2D(LENGTH)
	CHUNKDATA=LEFT(DATA,LENGTH)
	CRC=SUBSTR(DATA,LENGTH+1,4)
	DATA=SUBSTR(DATA,LENGTH+5)
	N=N+1
	CHUNK.TAIL.N=ID CHUNKDATA
	IF SUBSTR(ID,3,1)\=TRANSLATE(SUBSTR(ID,3,1)) THEN CALL READSUBCHUNKS CHUNKDATA,TAIL"."N
END
CHUNK.TAIL.0=N
RETURN
