/***********************************************************************/
/* kilian.cmd, a script to copy and rename digital camera files        */
/* using EXIF data for the jpegs.                                      */ 
/* Copyright (c) 2003 by Dimitrios Bogiatzoules                        */
/* info at bogiatzoules dot de                                         */
/* This Program is released under the Gnu Public                       */
/* Licence (GPL).                                                      */
/* See the file COPYING for further information.                       */
/*                                                                     */
/*                                                                     */
/* Please change the following values to your needs!                   */
/*                                                                     */
/***********************************************************************/
/* Path to the directorieswere your files should be saved              */
/* The directories must exist!!                                        */
/***********************************************************************/
camera_jpg_dir='R:\data\camera\jpg'
camera_movie_dir='R:\data\camera\mov'
camera_wav_dir='R:\data\camera\wav'

/***********************************************************************/
/* Path to renamepics.exe                                              */
/***********************************************************************/
renamepics='E:\Programme\renamepics\renamepics.exe'

/***********************************************************************/
/* If your camera creates all the audio and video files with the same  */
/* timestamp, then you may set the following value to 1 and force an   */
/* alternate file renaming.                                             */
/***********************************************************************/
use_alternative_renaming=0

/***********************************************************************/
/* End of user data                                                    */
/***********************************************************************/
version='0.3'
version_date='03.12.2003'

/***********************************************************************/
/* Main routine                                                        */
/***********************************************************************/
CALL BASIC_INIT		/* initialise */
CALL INTRO		/* put intro to screen */
PARSE ARG source_dir	/* parse the source directory */  
CALL EVAL_SOURCE_DIR	/* evaluate the source dir */
CALL PROCESS_JPG	/* process the JPEGs */
CALL PROCESS_MOVIES	/* process the MOVIEs */
CALL PROCESS_WAV	/* process the WAVs */
CALL DONE
EXIT



/***********************************************************************/
/* Initialising...                                                     */
/***********************************************************************/
BASIC_INIT:
'@ECHO OFF'
CALL RxFuncAdd "SYSLoadFuncs","RexxUtil","SYSLoadFuncs"
CALL SYSLoadFuncs
CALL ANSI_COLORS	/* enable ansi colors */
RETURN

/***********************************************************************/
/* Start message                                                       */
/***********************************************************************/
INTRO:
SAY color.gray  || 'Thank you for using '|| color.magenta || 'Kilian' ||,
color.gray || ', a tool for your digital camera files.'
SAY color.cyan || 'Version 'version || color.gray || ', 'version_date'.'
SAY color.gray || 'This Program is released under the Gnu Public Licence',
|| '(GPL).'
SAY 'See the file COPYING for further information.'
SAY color.gray  || 'Copyright (c) 2003 by '|| color.white ||,
'Dimitrios Bogiatzoules'
SAY
RETURN

/***********************************************************************/
/* get the source directory (on the camera)                            */
/***********************************************************************/
EVAL_SOURCE_DIR:        
IF source_dir="" THEN
   DO
   SAY ' '
   SAY color.red || " ERROR: " || color.gray ||,
  'Please drop the directory which contains the image files to rename!'
   PAUSE
   EXIT 1 /* Exit with error */
   END
RETURN

/***********************************************************************/
/* Process all JPG files, if there are any !                           */
/***********************************************************************/
PROCESS_JPG:
CALL DIRECTORY camera_jpg_dir
CALL COPY_FILES 'jpg' ,camera_jpg_dir  
DO i=1 to files.0
  f2r=FILESPEC("name",files.i) /* extraxt the filename only! */
  renamepics camera_jpg_dir'\'f2r ' >nul' /* rename */
END
RETURN

/***********************************************************************/
/* Process all movies, if there are any !                           */
/***********************************************************************/
PROCESS_MOVIES:
CALL DIRECTORY camera_movie_dir
CALL COPY_FILES 'avi', camera_movie_dir /* for AVI movies */
CALL COPY_FILES 'mov', camera_movie_dir /* for Quicktime movies */
DO i=1 to files.0
  old_name=FILESPEC("name",files.i) /* extraxt the filename only! */
  PARSE VALUE old_name WITH name_wo_ext'.'file_extension
  fdt=STREAM(files.i,'C','QUERY DATETIME')
  new_name='20'SUBSTR(fdt,7,2)'_'SUBSTR(fdt,1,2)'_'SUBSTR(fdt,4,2)'_'||,
  SUBSTR(fdt,11,2)'_'SUBSTR(fdt,14,2)'_'SUBSTR(fdt,17,2)'.'file_extension
  IF use_alternative_renaming=1 THEN
    DO
    PARSE VALUE old_name WITH name_wo_ext'.'file_extension
    new_name='20'SUBSTR(fdt,7,2)'_'SUBSTR(fdt,1,2)'_'SUBSTR(fdt,4,2)'_'||,
    name_wo_ext'.'||file_extension
    END
  'RENAME' old_name new_name   
END
RETURN

/***********************************************************************/
/* Process all WAV files, if there are any !                           */
/***********************************************************************/
PROCESS_WAV:
CALL DIRECTORY camera_wav_dir
CALL COPY_FILES 'wav', camera_wav_dir
DO i=1 to files.0
  old_name=FILESPEC("name",files.i) /* extraxt the filename only! */
  fdt=STREAM(files.i,'C','QUERY DATETIME')
  new_name='20'SUBSTR(fdt,7,2)'_'SUBSTR(fdt,1,2)'_'SUBSTR(fdt,4,2)'_'||,
  SUBSTR(fdt,11,2)'_'SUBSTR(fdt,14,2)'_'SUBSTR(fdt,17,2)'.wav'
  IF use_alternative_renaming=1 THEN
    DO
    PARSE VALUE old_name WITH name_wo_ext'.'crap1
    new_name='20'SUBSTR(fdt,7,2)'_'SUBSTR(fdt,1,2)'_'SUBSTR(fdt,4,2)'_'||,
    name_wo_ext'.wav'
    END
  'RENAME' old_name new_name
END
RETURN

/***********************************************************************/
/* Set some colors, thanx to Dmitry A.Steklenev for the inspiration.   */
/* Enable ANSI extended screen and keyboard control                    */
/***********************************************************************/
ANSI_COLORS:
'@ansi on > nul'
color.brown   = "1B"x"[0;33m"
color.red     = "1B"x"[1;31m"
color.green   = "1B"x"[1;32m"
color.yellow  = "1B"x"[1;33m"
color.blue    = "1B"x"[1;34m"
color.magenta = "1B"x"[1;35m"
color.cyan    = "1B"x"[1;36m"
color.white   = "1B"x"[1;37m"
color.gray    = "1B"x"[0m"
RETURN

/***********************************************************************/
/* Copy from source to destination, if necessary !                     */
/***********************************************************************/
COPY_FILES:
ARG file_ext, dest_dir
rc=SysFileTree(source_dir'\*.'file_ext,files,O)
IF files.0=0 THEN RETURN 1 /* check if there are any else return */
SAY color.gray || 'Processing the files with the extension: 'file_ext
DO i=1 to files.0
  COPY files.i dest_dir '2>nul >nul' /* copy to destination */
END
RETURN

/***********************************************************************/
/* Done....                                                            */
/**********************************************************************/
DONE:
CALL BEEP 1000,100
SAY ' '
SAY color.red || "Done!" || color.gray ||,
' But please look at the saved files before deleting them on the camera!'
PAUSE
RETURN



