/*
 * ds7.c - DS-7 Ƃ̒ʐMs֐
 * loadds7 by Romy
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <utime.h>

#define INCL_DOS
#define INCL_DOSDEVIOCTL
#include <os2.h>

#include "serial.h"
#include "ds7.h"

#define TIMESTAMP_OFFSET 0x1d0

INT
Resp( HFILE hFile )
/*  */
{
	CHAR ch[3];

	COM_RecvString( hFile, ch, 1 );
	return (INT)ch[0];
}

void
SendACK( HFILE hFile )
{
	CHAR ch = (CHAR)ACK;
	COM_SendString( hFile, &ch, 1 );
}

void
SendNAK( HFILE hFile )
{
	CHAR ch = (CHAR)NAK;
	COM_SendString( hFile, &ch, 1 );
}

INT
StartConnection( HFILE hFile )
/* ڑJn */
/* ߂l: 0....OK -1...Error */
{
	if( COM_SendString( hFile, "\x05", 1 ) != 1 ){
		return -1;
	}

	return 0;
}


INT
EndConnection( HFILE hFile )
{
	SendACK( hFile );
	if( COM_SendString( hFile, "\x04", 1 ) != 1 ){
		return -1;
	}
	return 0;
}


INT
RecvData( HFILE hFile, CHAR sData[], ULONG *ulDataLength, CHAR *chCtlChar )
/* Ԃl: 㑱f[^:1, 㑱f[^Ȃ(MI):0 G[:-1 */
/* p[^: hFile(IN)..t@Cnh, sData(OUT)..Mf[^obt@,
   ulDataLength(OUT)..Mf[^, sCtlChar(OUT)..䕶(ETB|ETX) */
/* sData[]  ߂ɊmۂĂB*/
{
	CHAR sHead[2], sTmp[1025], chBcc;
	INT nLen, i, j;

	/* Receive Data(and Footer) */
	do{
		sTmp[1024] = '\x00';

		/* Receive Header */
		COM_RecvString( hFile, sHead, 2 );

		j = 0;
		do{
			do{
				nLen = COM_RecvString( hFile, sTmp, 1024 );

				/* M񒆂 "\x10\x10"  "\x10" ɒu */
				for( i = 0; i < nLen; i++,j++ ){
					if( memcmp( &sTmp[i], "\x10\x10", 2 ) == 0 ){
						sData[j] = '\x10';
						i++;
					}
					else{
						sData[j] = sTmp[i];
					}
				}
			}while( nLen == 1024 );
		}while( sData[j-3] != 0x10 );

		*chCtlChar = sData[j-2];
		*ulDataLength = j-3;

		/* BCC Check */
		chBcc = sData[j-1];
		chBcc ^= *chCtlChar;	/* CtlChar */
		for( i = 0; i < *ulDataLength; i++ ){
			chBcc ^= sData[i];	/* Data */
		}
		if( chBcc != 0x00 ){
			/* if error detected, send NAK to reread */
			SendNAK( hFile );
			fprintf( stderr, "x(%d)", nLen );
		}

	}while( chBcc != 0x00 );


	/* f[^Ɋ֌ŴȂ擪4oCgJbg */
	for( i = 4; i < *ulDataLength; i++ ){
		sData[i-4] = sData[i];
	}
	*ulDataLength -= 4;

	if( *chCtlChar == ETB ){
		return 1;
	}
	else if( *chCtlChar == ETX ){
		return 0;
	}
	
	return -1;

}

INT
SendCommand( HFILE hFile, CHAR sCommand[], ULONG nCommandLength )
/* R}hɃwb_Etb^EBCCđM */
/* ACKM...0, NAKM...-1 */
{
	CHAR sSend[20], sTmp[20];
	CHAR chBcc = 0;
	INT i, j;

	/*BCČvZ*/
	sTmp[0] = '\0';j = 0;
	for( i = 0; i < nCommandLength; i++ ){
		chBcc ^= sCommand[i];
		sTmp[j] = sCommand[i];
		j++;
		/*r\x10ǉ(BcčvZΏۂƂ͂Ȃ)*/
		if( sCommand[i] == '\x10' ){
			sTmp[j] = '\x10';
			j++;
		}
	}
	chBcc ^= ETX;
	nCommandLength = j;
	
	/*wb_*/
	strcpy( sSend, "\x10\x02" );
	memcpy( sSend+2, sTmp, nCommandLength );

	/*tb^EBCC*/
	sprintf( sSend+nCommandLength+2, "\x10%c%c", ETX, chBcc );

	/*M*/
	COM_SendString( hFile, sSend, nCommandLength+5 );

	/*ǂݎ*/
	if( Resp( hFile ) != ACK )
		return -1;

	return 0;
}

INT
ChangeBaudrate( HFILE hFile, USHORT usBaud )
{
	CHAR chBaud, chCtlChar;
	CHAR sCommand[] = { 0x01, 0x07, 0x01, 0x00, 0x07 };/*xύX*/
	CHAR sDummy[10];
	ULONG ulLen;

	/*ݒXs[hɉăR}h*/
	switch( usBaud ){
		case 57600u:	chBaud = 0x07;break;
		case 38400u:	chBaud = 0x06;break;
		case 19200u:	chBaud = 0x04;break;
		case 9600u :	chBaud = 0x00;break;
		default:
			fprintf( stderr, "Invalid baudrate %u.\n", usBaud );
			return -1;
	}
	sCommand[4] = chBaud;

	/*R}hM*/
	if( SendCommand( hFile, sCommand, 5 ) != 0 ){
		return -1;
	}
	if( RecvData( hFile, sDummy, &ulLen, &chCtlChar ) < 0 ){/*ǂݎ̂*/
		return -1;
	}

	/*xʐMI*/
	EndConnection( hFile );

	/*(0.1b)҂*/
	_sleep2( 100 );

	/*OS/2̃{[[gς*/
	if( COM_SetBaudrate( hFile, usBaud ) != 0 ){
		return -1;
	}

	/*ʐMĊJ*/
	if( StartConnection( hFile ) != 0 || Resp( hFile ) != ACK ){
		return -1;
	}

	return 0;
	
}

INT
GetCameraInfo( HFILE hFile, CHAR sCamInfo[] )
/* J̎擾 */
/* sCanInfo19oCgȏKv */
{
	ULONG ulLen;
	INT nRet;
	CHAR sCommand[] = { 0x00, 0x09, 0x00, 0x00 };
	CHAR chCtlChar;

	if( SendCommand( hFile, sCommand, 4 ) != 0 ){
		return -1;
	}
	nRet = RecvData( hFile, sCamInfo, &ulLen, &chCtlChar );
	SendACK( hFile );

	sCamInfo[9] = '\0';

	return 0;
}

INT
GetRecordInfo( HFILE hFile )
/* L^̎擾 */
/* Ԃl: L^(G[:-1) */
{
	ULONG ulLen;
	INT nRet;
	CHAR sCommand[] = { 0x00, 0x0b, 0x00, 0x00 };
	CHAR sRecInfo[20], chCtlChar;

	if( SendCommand( hFile, sCommand, 4 ) != 0 ){
		return -1;
	}
	nRet = RecvData( hFile, sRecInfo, &ulLen, &chCtlChar );
	SendACK( hFile );

	return sRecInfo[0];
}

INT
GetImageName( HFILE hFile, INT nImageNum, CHAR sImgName[] )
/* sImgName20oCgKv */
{
	CHAR sCommand[] = { 0x00, 0x0a, 0x02, 0x00, 0xAA, 0x00 };
	CHAR chCtlChar;
	INT nRet;
	ULONG ulLen;

	sCommand[4] = (CHAR)nImageNum;

	if( SendCommand( hFile, sCommand, 6 ) != 0 ){
		return -1;
	}
	nRet = RecvData( hFile, sImgName, &ulLen, &chCtlChar );
	SendACK( hFile );

	sImgName[12] = '\0';

	return 0;

}

INT
GetImage( HFILE hFile, INT nImageNum, CHAR szImageName[] )
/*nImageNumŎw肵摜MAszImageNameŎw肵
 *t@Cɏo*/
{
	FILE* fp;
	CHAR sData[1050], chCtlChar;
	CHAR sCommand[] = { 0x00, 0x02, 0x02, 0x00, 0xAA, 0x00 };
 	/*                                           R}ԍ*/
	ULONG ulLength;
	INT nRec;
	int nYear,nMonth,nDay,nHour,nMin,nSec;
 	time_t nUTime;
 	int nFirst;
	struct tm tm;
 	struct utimbuf ut;

	sCommand[4] = (CHAR)nImageNum;

	fp = fopen( szImageName, "wb" );
	if( fp == NULL ){
		fprintf( stderr, "File %s open failed\n", szImageName );
		return -1;
	}

	if( SendCommand( hFile, sCommand, 6 ) != 0 ){
		return -1;
	}

	nFirst = 0;
	do{
		nRec = RecvData( hFile, sData, &ulLength, &chCtlChar );
		if( nFirst == 0 ){
			sscanf( sData+TIMESTAMP_OFFSET,
					"%4d:%02d:%02d %02d:%02d:%02d",
					&nYear,&nMonth,&nDay,
					&nHour,&nMin,&nSec );
			nFirst = 1;
		}
		fwrite( sData, 1, ulLength, fp );
		printf( "." );
		SendACK( hFile );
	}while( nRec == 1 );

	fclose( fp );
	
	memset( &tm, 0, sizeof(struct tm) );
	tm.tm_sec = nSec;		
 	tm.tm_min = nMin;
	tm.tm_hour = nHour;
 	tm.tm_mday = nDay;
	tm.tm_mon = nMonth-1;
 	tm.tm_year = nYear-1900;
	tzset();
	nUTime = mktime( &tm );
 	if( nUTime != (time_t)-1 ){
	 	ut.actime = nUTime;
 	 	ut.modtime = nUTime;
 		utime( szImageName, &ut );
	}else{
		fputs( "Timestamp conversion failed\n", stderr );
	}
	printf( "OK\n" );

	return 0;

}

