/*
 * serial.c - VA|[g֌W
 * loadds7 by Romy
 */

#include <stdio.h>
#include <stdlib.h>

#define INCL_BASE
#define INCL_DOSDEVIOCTL
#include <os2.h>

void
COM_WaitRecv( HFILE hFile )
{
	RXQUEUE queParam;

	do{
		DosDevIOCtl( hFile, IOCTL_ASYNC, ASYNC_GETINQUECOUNT,
					NULL, 0L, 0L, (PVOID)&queParam, sizeof(RXQUEUE),
					NULL );
	}while( queParam.cch == 0 );
}

void
COM_WaitSend( HFILE hFile )
{
	RXQUEUE queParam;
	CHAR sDummy[20];
	ULONG ulDummy;
	
	/* Mobt@̃f[^ǂݎ̂Ă */
	DosDevIOCtl( hFile, IOCTL_ASYNC, ASYNC_GETINQUECOUNT,
				NULL, 0L, 0L, (PVOID)&queParam, sizeof(RXQUEUE),
				NULL );
	if( queParam.cch > 0 ){
		DosRead( hFile, sDummy, queParam.cch, &ulDummy );
	}

	do{
		DosDevIOCtl( hFile, IOCTL_ASYNC, ASYNC_GETOUTQUECOUNT,
					NULL, 0L, 0L, (PVOID)&queParam, sizeof(RXQUEUE),
					NULL );
	}while( queParam.cch > 0 );

}

INT
COM_SetBaudrate( HFILE hFile, USHORT usBaudRate )
{
	APIRET ulRet;

	/* Set Baudrate */
	ulRet = DosDevIOCtl( hFile, IOCTL_ASYNC, ASYNC_SETBAUDRATE,
						(PVOID)&usBaudRate, sizeof(USHORT), NULL, NULL,
						0L, NULL );
	if( ulRet != NO_ERROR ){
		return -1;
	}

	return 0;
}

INT
COM_Init( INT nComPort, HFILE* hFile )
/*COM|[g(nComPort...1-4)*/
/*߂l: 0...OK 1...Error*/
{
	ULONG ulAction;
	APIRET ulRet;
	LINECONTROL lineCtrl;
	DCBINFO	dcbInfo;
	CHAR szFile[10];

	/* Open COMport */
	sprintf( szFile, "COM%1d", nComPort );
	ulRet = DosOpen( szFile, hFile, &ulAction, 0L, FILE_NORMAL,
			FILE_OPEN, OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,
			0L );
	if( ulRet != NO_ERROR ){
		return -1;
	}

	/* Set BaudRate */
	COM_SetBaudrate( *hFile, 9600u );

	/* Set Line Parameters */
	lineCtrl.bDataBits = 8;
	lineCtrl.bParity = 0x02;	/*Even Parity*/
	lineCtrl.bStopBits = 0x00;	/*1 stop bit*/
	lineCtrl.fTransBreak = 0x00;	/*Dont' send break*/
	ulRet = DosDevIOCtl( *hFile, IOCTL_ASYNC, ASYNC_SETLINECTRL,
						&lineCtrl, sizeof(LINECONTROL), NULL, NULL,
						0L, NULL );

	if( ulRet != NO_ERROR ){
		return -1;
	}
						
	dcbInfo.usWriteTimeout = 0;
	dcbInfo.usReadTimeout = 0;
	dcbInfo.fbCtlHndShake = 0;
	dcbInfo.fbFlowReplace = 0;
	dcbInfo.fbTimeout = MODE_NO_WRITE_TIMEOUT|MODE_READ_TIMEOUT;
	dcbInfo.bErrorReplacementChar = '\0';
	dcbInfo.bBreakReplacementChar = '\0';
	dcbInfo.bXONChar = 0x11;	/*NoUse*/
	dcbInfo.bXOFFChar = 0x13;	/*NoUse*/
	ulRet = DosDevIOCtl( *hFile, IOCTL_ASYNC, ASYNC_SETDCBINFO,
						&dcbInfo, sizeof(DCBINFO), 0L, NULL,
						0L, NULL );
	if( ulRet != NO_ERROR ){
		return -1;
	}

	return 0;
}

INT
COM_Close( HFILE hFile )
{
	ULONG ulRet;

	/* Close COMport */
	ulRet = DosClose( hFile );

	if( ulRet != NO_ERROR ){
		return -1;
	}

	return 0;
}

INT
COM_SendString( HFILE hFile, CHAR sString[], ULONG ulLen )
/* ulLenoCg̃f[^𑗐M */
{
	ULONG ulWrittenLen;
	APIRET ulRet;
	
	COM_WaitSend( hFile );
	ulRet = DosWrite( hFile, (PVOID)sString, (ULONG)ulLen, &ulWrittenLen );
	if( ulRet != NO_ERROR ){
		return -1;
	}
	else if( ulLen != ulWrittenLen ){
		return -1;
	}

	return (INT)ulLen;
}

INT
COM_RecvString( HFILE hFile, CHAR sString[], ULONG ulLen )
/* ulLenoCgf[^M */
{
	ULONG ulReadLen;
	APIRET ulRet;

	COM_WaitRecv( hFile );
	ulRet = DosRead( hFile, (PVOID)sString, (ULONG)ulLen, &ulReadLen );
	if( ulRet != NO_ERROR ){
		return -1;
	}

	return (INT)ulReadLen;
}

