/* REXX */

/* Rename pictures to the date and time they where made. 
 *
 * This script was designed to be used with Olympus Digital Cameras
 *
 * (c) 2000 by A. Wagner, Team OS/2 Franken 
 */

/* Load some system fucntions in case we don't allready have them: */
if RxFuncQuery('SysLoadFuncs') > 0 Then
   CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs
'@Echo off'

Arg InFile

SearchStr  = 'OLYMPUS DIGITAL CAMERA' /* Search for this String to locate Date and Time : */
DateOffset = 20                       /* Date starts at Searchstring - DateOffset */
DateLength = 19                      /* Lengh of Date */
TransFrom  = ': '                    /* Replace this Chars... */
TransTo    = '-_'                    /* by that ones within output filename */
TargetPath = '.\'                    /* Where to copy the Target file */

say "Processing "||InFile||"..."

rc = stream(InFile, 'C', 'OPEN READ')

do while Lines(InFile) > 0
	Line = LineIn(InFile)
	DatePos = pos(SearchStr, Line)
	if DatePos > 0 then
	do
		DateTime = SubStr(Line, DatePos-DateOffset, DateLength)
		DateTime = Translate(DateTime,TransTo,TransFrom)
		say 'Copying '||InFile||' to '||TargetPath||DateTime||'.jpg...'
		CopyFile = InFile
		rc = stream(CopyFile, 'C', 'OPEN READ')
		FileSize = Stream(CopyFile, 'C', 'QUERY SIZE')
		FileCont = CharIn(CopyFile, ,FileSize)
		call CharOut TargetPath||DateTime||'.jpg', FileCont
		DatePos = 0
	end
end

rc = stream(InFile, 'C', 'CLOSE')
say 'Done.'
