/* allfolders.cmd,v 1.5 1999-01-31 13:43:56-05 rl Exp */

/*************************************************************************
 *                                                                       *
 * allfolders.cmd                                                        *
 * Set attributes of all folders in a directory tree                     *
 * 1996-06-15, Rolf Lochbuehler                                          *
 *                                                                       *
 * Note: Requires functions from RexxUtil DLL                            *
 *                                                                       *
 *************************************************************************/

STD_FEATURE = 'ICONVIEW'
STD_VALUE = 'FLOWED,MINI'

NO_ERR = 0
ERR_CANNOT_FIND_DIR = 1

parse arg dirname feature value

feature = translate( feature )
value = translate( value )

if feature = 'STD' then
  do
  feature = STD_FEATURE
  value = STD_VALUE
  end

if translate(dirname) = "/LIST" then do
  say 'ALWAYSSORT        NO|YES'
  say 'BACKGROUND        B|C|N|M|S'
  say 'CCVIEW            DEFAULT|NO|YES'
  say 'DEFAULTVIEW       DEFAULT|DETAILS|id|ICON|SETTINGS|TREE'
  say 'DETAILSCLASS      classname'
  say 'DETAILSFONT       fontsize.facename'
  say 'DETAILSVIEW       MINI|NORMAL'
  say 'HELPLIBRARY       filename'
  say 'HELPPANEL         panelid'
  say 'HIDEBUTTON        NO|YES'
  say 'ICONFONT          fontsize.facename'
  say 'ICONNFILE         1,filename   (1 = index value, must be 1)'
  say 'ICONRESOURCE      1,id,filename   (1 = index value, must be 1)'
  say 'ICONVIEW          FLOWED|GRID|INVISIBLE|MINI|NONFLOWED|NONGRID|NORMAL'
  say 'ICONVIEWPOS       x,y,cx,cy'
  say 'MINWIN            DESKTOP|HIDE|VIEWER'
  say 'NOCOPY            NO|YES'
  say 'NODELETE          NO|YES'
  say 'NODRAG            NO|YES'
  say 'NODROP            NO|YES'
  say 'NOLINK            NO|YES'
  say 'NOMOVE            NO|YES'
  say 'NOPRINT           NO|YES'
  say 'NORENAME          NO|YES'
  say 'NOSETTINGS        NO|YES'
  say 'NOSHADOW          NO|YES'
  say 'NOTVISIBLE        NO|YES'
  say 'OBJECTID          <objectid>'
  say 'OPEN              DEFAULT|DETAILS|ICON|SETTINGS|TREE'
  say 'REMOVEFONTS       NO|YES'
  say 'SHOWALLINTREEVIEW NO|YES'
  say 'SORTCLASS         classname'
  say 'TEMPLATE          NO|YES'
  say 'TITLE             text'
  say 'TREEFONT          fontsize.facename'
  say 'TREEVIEW          INVISIBLE|LINES|MINI|NOLINES|NORMAL'
  say 'WORKAREA          NO|YES'
  say ''
  say 'id                0-9'
  say 'facename          Helv|System Monospaced|System Proportional'
  say '                  |System VIO|Tms Rmn|WarpSans'
  exit
  end

if (translate(dirname) = '/H') | (dirname == "") then do
  say "AllFolders 1.5, Rolf Lochbuehler <rolf@together.net>"
  say 'Purpose:'
  say "  Set extended attributes (EAs) of all directories in directory tree"
  say "  (assuming that all directories are objects of type WPFolder)"
  say "Syntax:"
  say "  allfolders [/h]"
  say "  allfolders [/list]"
  say "  allfolders [Directory Feature Value]"
  say "  allfolders [Directory std]"
  say "Arguments:"
  say "  (none)      print this help, then abort"
  say "  /h          print this help, then abort"
  say "  /list       print list of possible EAs to set"
  say "  Directory   Start directory"
  say "  Feature     EA name to be set (see allfolders /list)"
  say "  Value       EA value to be set (see allfolders /list)"
  say "  std         Set "STD_FEATURE" to "STD_VALUE
  say "Examples:"
  say "  allfolders c:\os2 ICONVIEW FLOWED,MINI"
  say "  allfolders c:\os2 ALWAYSSORT YES"
  say "  allfolders . ALWAYSSORT YES"
  say "  allfolders . std"
  exit
  end

dirname = complete( dirname )

/* Directory exists? */
call sysfiletree dirname, 'd', 'do'
if d.0 = 0 then
  do
  say "*ERROR AllFolders* Cannot find" dirname
  exit ERR_CANNOT_FIND_DIR
  end

call setfolder dirname, feature, value

exit NO_ERR


/*************************************************************************
 *                                                                       *
 * setfolder()                                                           *
 * Recursive procedure to setup folders                                  *
 *                                                                       *
 *************************************************************************/
setfolder : procedure

  parse arg dirname, feature, value

  if 1 = syssetobjectdata(dirname,feature||'='||value) then
    say 'Set' feature||'='||value 'for' dirname

  if directory() <> dirname then
    do
    /* We started with a subdirectory of the current directory */
    olddir = directory()
    call directory( dirname )
    end
  else
    /* We started with the current directory */
    olddir = dirname

  call SysFileTree '*', 'subdirname', 'do'
  if subdirname.0 > 0 then
    /* Go into subdirectories */
    do i = 1 to subdirname.0
      call setfolder subdirname.i, feature, value
    end

  call directory olddir

  return NO_ERR


/************************************************************************* 
 *                                                                       * 
 * complete()                                                            * 
 * Complete directory/file name, substitute ellipses, etc.               * 
 *                                                                       * 
 *************************************************************************/
complete : procedure

  parse arg d

  d = strip( d, 'both' )
  d = strip( d, 'both', '"' )

  if d = '' then
    dn = directory()
  
  else if d = '.' then
    dn = directory()
  
  else if d = '..' then
    do
    curdir = directory()
    call directory '..'
    dn = directory()
    call directory curdir
    end
  
  else if substr(d,1,1) = '\' then
    do

    /* Here: '\any\dir\name' (absolute path, but missing 'drive:') */

    drive = filespec( 'drive', directory() )
    dn = drive || d

    end
  
  else if 0 = pos(':',d) then
    do

    /* Here: 'any\dir\name' (relative path) */

    dummy = directory()
    if length(dummy) <> lastpos('\',dummy) then
      dn = dummy'\'d
    else
      dn = dummy || d

    end
  else if (length(d) = 2) & (2 = pos(':',d)) then

    /* Here: '?:' (drive) */

    dn = d'\'

  else
    dn = d

  return dn
