/* -------------------------------------------------------------------- */
/* Installation/Setup Procedure for Oberon DiskStat PLUS!               */
/* Copyright 1996, Oberon Software, Inc.                                */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/* Register the REXXUtil Functions */
/* -------------------------------------------------------------------- */

  PreRegistered = 1
  if RxFuncQuery('SysLoadFuncs') then
    do
  	  PreRegistered = 0
  	  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      call SysLoadFuncs
    end


  call CopyR

/* -------------------------------------------------------------------- */
/* Copy the files */
/* -------------------------------------------------------------------- */

  parse source . . argv0 .
  temp = reverse(argv0)
  temp = substr(temp, pos('\', temp))
  if length(temp) > 3 then temp = substr(temp, 2)
  srcPath = reverse(temp)

  parse arg argv1 argv2 .
  if length(argv1) = 0 then
    do
      say 'usage: install targetpath [/nocopy | /nofolder]'
      exit 1
    end

  option      = translate(argv2)
  exePath     = argv1
  exeFileName = exePath||'\DSPlus.exe'
  hlpFileName = exePath||'\DSPlus.HLP'
  infFileName = exePath||'\DSPlus.INF'
  iniFileName = exePath||'\DSPLUS.INI'
  iniAppName  = 'Oberon.DSPlus'

  if length(srcPath) = 3 then srcPath = left(srcPath, 2)

  if option \= '/NOCOPY' then
    do

      say
      say 'The following files will be copied:'
      say
      say srcPath||'\DSPlus.exe  ->' exePath||'\DSPlus.exe'
      say srcPath||'\DSPlus.hlp  ->' exePath||'\DSPlus.hlp'
      say srcPath||'\DSPlus.inf  ->' exePath||'\DSPlus.inf'
      say srcPath||'\ObReg.dll   ->' exePath||'\ObReg.dll'
      say srcPath||'\Install.cmd ->' exePath||'\Install.cmd'
      say
      call charout , 'Press ENTER to continue or CONTROL+C to abort ...'
      pull
      say

      call SysMkDir(exePath)
      '@copy' srcPath||'\DSPlus.exe'  exePath
      '@copy' srcPath||'\DSPlus.hlp'  exePath
      '@copy' srcPath||'\DSPlus.inf'  exePath
      '@copy' srcPath||'\ObReg.dll'   exePath
      '@copy' srcPath||'\Install.cmd' exePath
      say
      call charout , 'Press ENTER to continue...'
      pull
      say
    end

  if option = '/NOFOLDER' then
    do
      say
      say 'DiskStat PLUS! Installation complete.'
      if PreRegistered = 0 then call SysDropFuncs
      exit 0
    end

/* -------------------------------------------------------------------- */
/* Create folder and DiskStat objects */
/* -------------------------------------------------------------------- */

  drvMap = SysDriveMap()
  drvLoc = SysDriveMap(, 'LOCAL')
  drvRmt = SysDriveMap(, 'REMOTE')

  call CopyR
  say
  say 'The following drives were found on your system:'
  say drvMap
  say
  say 'These drives are local: ' drvLoc
  say 'These drives are remote:' drvRmt
  say
  say 'Type "ALL" for all listed drives, "LOCAL" for just the local drives,'
  say '"REMOTE" for only the remote drives, or enter a list of drive letters.'
  say 'Type "NONE" or just press ENTER if you do not want to install any'
  say 'DiskStat PLUS drive objects.'
  call charout , 'Drives> '
  parse upper pull rsp

  select
    when rsp = 'ALL'    then drvList = drvMap
    when rsp = 'LOCAL'  then drvList = drvLoc
    when rsp = 'REMOTE' then drvList = drvRmt
    when rsp = 'NONE'   then drvList = 'NONE'
    when rsp = ''       then drvList = 'NONE'
    otherwise                drvList = rsp
  end
  if drvList = '' then drvList = 'NONE'

  call CopyR
  say
  say 'File to update or create:' iniFileName
  say
  say 'Drives to install:' drvList
  say
  call charout , 'Press ENTER to continue or CONTROL+C to abort...'
  pull
  say
  say

  if drvList = 'NONE' then
    do
      say 'There are no drive objects to install.'
      fInst = GetYN(' Do you want to install or update the folder anyway? ')
      say
      if fInst = 0 then
        do
          if PreRegistered = 0 then call SysDropFuncs
          exit 0
        end
    end

  classname='WPFolder'
  title='Oberon DiskStat PLUS!'
  location='<WP_DESKTOP>'
  setup='OBJECTID=<OBERON_DSPLUSFLDR>;'||,
        'ICONPOS=25,75;'||,
        'OPEN=ICON;'
  option='U'
  call BldObj

  say 'Do you want to install or update the DiskStat PLUS!'
  fInst = GetYN('Documentation object? ')
  say
  if fInst = 1 then
    do
      classname='WPProgram'
      title='DiskStat PLUS!^Documentation:'
      location='<OBERON_DSPLUSFLDR>'
      setup='OBJECTID=<OBERON_DSPLUSINF>;'||,
            'EXENAME=VIEW.EXE;'||,
            'PARAMETERS=DSPlus;'||,
            'STARTUPDIR='exePath';'||,
            'PROGTYPE=PM;'
      option='R'
      call BldObj
    end

  if drvList \= 'NONE' then
    do
      drvCnt = words(drvList)
      do i = 1 to drvCnt
        drv = left(word(drvList, i), 1)
        prof = SysIni(iniFileName, iniAppName, 'Drive'||drv)
        fOK = 1
        if prof \= 'ERROR:' then
          do
            call beep 1760, 50
            call charout , '*NOTE* Profile "Drive'||drv||'" already exists.'
            fOK = GetYN(' Overwrite? ')
            say
          end

        if fOK = 1 then
          call SysIni iniFileName, iniAppName, 'Drive'||drv, drv

        classname='WPProgram'
        title='Drive '||drv||':'
        location='<OBERON_DSPLUSFLDR>'
        setup='OBJECTID=<OBERON_DSPLUS_'||drv||'>;'||,
              'EXENAME='exeFileName';'||,
              'PARAMETERS=Drive'||drv||';'||,
              'STARTUPDIR='exePath';'||,
              'PROGTYPE=PM;'
        option='R'
        call BldObj
      end
    end


  say
  say 'DiskStat PLUS! Installation complete.'
  if PreRegistered = 0 then call SysDropFuncs
  exit


/* -------------------------------------------------------------------- */
/* Copyright */
CopyR:
  call SysCls
  say 'Installation/Setup Procedure for Oberon DiskStat PLUS!'
  say 'Copyright (c) 1996, Oberon Software, Inc.'
  say
  return


/* -------------------------------------------------------------------- */
BldObj:
  call charout ,'    Building:' title '... '
  r = SysCreateObject(classname, title, location, setup, option)
  if r = 1 then
    say 'Object created!'
  else
    say 'Not created!  Return code='r
  return


/* -------------------------------------------------------------------- */
GetYN: procedure
parse arg gynPrompt
  call charout ,gynPrompt '(y/N) '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = D2C(27) | k = D2C(13) then k = 'N'
    select
      when k = 'Y' then
        do
          ynRC = 1
          leave
        end
      when k = 'N' then
        do
          ynRC = 0
          leave
        end
      otherwise
        call beep 1760, 50
    end
  end
  return ynRC

