/* FAT32 Blanker */

Version='0.1.5'

/* Store command line parameters */
parse arg param

/* Parameters we need */
SectorsPerTrack = -1
Heads           = -1
PartStart       = -1
PartSize        = -1
  /* Everything depends on this to work correctly thanks to MS */
BPS             = 512

/* Acceptable defaults for the rest of variables */
  /* Some options to generate a 'random' volume serial number */
opdate          = 'B'
optime          = 'S'
sn              = right(d2x(date(opdate)),4)||right(d2x(time(optime)),4)
Bootable        = 0
Filename        = ''
debug           = 1

/* Analyze command line parameters */
Call parse_args

/* Check if acceptable values have been given */
if SectorsPertrack=-1 | Heads=-1 | PartStart=-1 | PartSize=-1 then
  call syntax

CylSize = SectorsPerTrack * Heads    /* CylSize is expressed in sectors */

/* Make the necessary conversions x<->d, cylinders<->sectors */ 
Call check_part_params

if filename='' then do
  temp_dir = value('TEMP',,'OS2ENVIRONMENT')
  thisdir=directory()
  temp_dir = directory(temp_dir)
  if temp_dir <> '' then do
    if right(temp_dir,1)<>'\' then temp_dir=temp_dir||'\'
    filename = temp_dir||'F32Blank.BIN'
   end
  else do
    Say 'Cannot create blanker file at '||temp_dir
    Call syntax
   end
  call directory thisdir
 end

Call Define_BPB
Call Useful_Structs
Call Make_BootSec
Call Make_BlankerFile
exit 0

syntax:

  parse source . . myself
  dir=directory()
  parse var myself with value(dir) '\' myself

  Say ' FAT32 blanker version '||version||' - Usage:'
  Say ''
  Say ' '||myself||' S:sectors H:heads SP:starting point SZ:size'
  Say ' [SN:xxxxxxxx] B:Y|N F:file [Q:Y]'
  Say ''
  Say ' Where the parameters are:'
  Say ' S:  hard drive sectors per track'
  Say ' H:  hard drive heads'
  Say ' SP: where the FAT32 partition begins, format: number,[x|d][s|c]'
  Say ' SZ: size of the partition, same format as above'
  Say '  "x" stands for "hexadecimal", "d" for "decimal", s for "sectors"'
  Say '  and "c" for cylinders; if none specified, defaults are x & s'
  Say ' B:  if the program should merge Win9x bootcode in its output or not'
  Say ' SN: A valid 8 hex digital code for volume serial number'
  Say ' F:  a filename for the blanked FAT32 structures to be dumped to'
  Say ' Q:Y if the program should not output anything to the display'
  exit 2

return

parse_args:
  do while length(param)>0
  parse var param pst param
    parse var pst bit_a ':' bit_b
    bit_a=translate(bit_a)
    select
      when bit_a = 'S'   then SectorsPerTrack = bit_b
      when bit_a = 'H'   then Heads           = bit_b
      when bit_a = 'SP'  then PartStart       = bit_b
      when bit_a = 'SZ'  then PartSize        = bit_b
  /*    when bit_a = 'BPS' then BPS             = bit_b */
      when bit_a = 'SN'  then sn              = bit_b
      when bit_a = 'B'   then bootable        = (bit_b='Y')
      when bit_a = 'F'   then filename        = bit_b
      when bit_a = 'Q'   then debug           = (bit_b<>'Y')
      otherwise
        call syntax
     end
   end
return

check_part_params:
  if pos(',',PartStart)>0 then do
    parse var PartStart PartStart ',' format
    format = translate(format)
    if pos('D',format)>0 then N_Base = 'D'
      else N_Base = 'X'
    if pos('C',format)>0 then CylSec = 'C'
      else CylSec = 'S'
   end
  else do
    N_Base = 'X'
    CylSec = 'S'
   end
  if N_Base = 'X' then PartStart = x2d(PartStart)
  if CylSec = 'C' then PartStart = PartStart * CylSize

  if pos(',',PartSize)>0 then do
    parse var PartSize PartSize ',' format
    format = translate(format)
    if pos('D',format)>0 then N_Base = 'D'
      else N_Base = 'X'
    if pos('C',format)>0 then CylSec = 'C'
      else CylSec = 'S'
   end
  else do
    N_Base = 'X'
    CylSec = 'S'
   end
  if N_Base = 'X' then PartSize = x2d(PartSize)
  if CylSec = 'C' then PartSize = PartSize * CylSize
return

txt2nr:
  parse arg chars
return c2d(reverse(chars))

nr2txt:
  nr=arg(1)
  chars=arg(2)
  nr=d2x(nr)
  nr=right(nr,2*chars,'0')
return reverse(x2c(nr))

Define_BPB:

  BS_OEMName     = 'MSWIN4.1'           /* Standard value set by MicroSoft */
  BPB_BytsPerSec = nr2txt(BPS,2)        /* We just can handle BPS=512 */

  select                         /* MS algorithm/table, hardcoded for 512 bps */
    when PartSize < 16777216  then SecPerClus=8
    when PartSize >= 16777216 & PartSize < 33554432  then SecPerClus=16
    when PartSize >= 33554432 & PartSize < 67108864  then SecPerClus=32
    when PartSize >= 67108864 then SecPerClus=64
    otherwise nop
   end

  BPB_SecPerClus = nr2txt(SecPerClus,1)

  BPB_RsvdSecCnt = x2c('2000')          /* 32, typical & recommended setting */
  BPB_NumFATs    = x2c('02')            /* 2, typical & recommended setting */
  BPB_RootEntCnt = x2c('0000')
  BPB_TotSec16   = x2c('0000')
  BPB_Media      = x2c('F8')
  BPB_FATSz16    = x2c('0000')
  BPB_SecPerTrk  = nr2txt(SectorsPerTrack,2)
  BPB_NumHeads   = nr2txt(Heads,2)
  BPB_HiddSec    = nr2txt(PartStart,4)
  BPB_TotSec32   = nr2txt(PartSize,4)

  tmp1=PartSize-32                /* MS algorithm, hardcoded for 512 bps*/
  tmp2=((256*SecPerClus)+2)/2
  fatsz=(tmp1+(tmp2-1))%tmp2      /* Number of sectors occuped by 1 FAT */

  BPB_FATSz32    = nr2txt(fatsz,4)

  BPB_ExtFlags   = x2c('0000')
  BPB_FSVer      = x2c('0000')
  BPB_RootClus   = x2c('02000000')      /* 2, typical & recommended setting */
  BPB_FSInfo     = x2c('0100')          /* 1, typical & recommended setting */
  BPB_BkBootSec  = x2c('0600')          /* 6, typical & recommended setting */
  BPB_Reserved   = copies(x2c('00'),12) /* Initialize as zeros */

  BS_DrvNum      = x2c('80')
  BS_Reserved1   = x2c('00')            /* Initialize as zeros */
  BS_BootSig     = x2c('29')            /* Standard value set by MicroSoft */
  BS_VolID       = reverse(x2c(sn))     /* As specified or date+time */
  BS_VolLab      = 'NO NAME    '        /* No label to start with */
  BS_FilSysType  = 'FAT32   '           /* Standard value as set by MicroSoft */

return

Useful_Structs:

  FATSecSig      = x2c('000055AA')
  PadBootSec     = copies(x2c('00'),508)||FATSecSig||copies(x2c('00'),BPS-512)
  PadSector      = copies(x2c('00'),BPS)
  FATFirstClus   = BPB_Media||x2c('FFFF0F')
  EOC            = x2c('FFFFFF0F')         /* Last cluster indicator */
  EmptyClusPtr   = x2c('00000000')         /* FAT Entry: empty cluster indicator */
  EmptyDirEntry  = copies(x2c('00'),32)    /* Empty dir entry for directory clusters */

  /* Substitute with your own junk/boot code */
  BootCode1=x2c(''||,
     'FA33C98ED1BCF87B8EC1BD7800C576001E561655'||,   /* 3ɎѼ{x.v..V.U */
     'BF2205897E00894E02B10BFCF3A48ED9BD007CC6'||,   /* ".~.N...ٽ.| */
     '45FE0F8B46188845F9384E407D258BC199BB0007'||,   /* E..F.E8N@}%.. */
     'E89700721A83EB3A66A11C7C663B078A57FC7506'||,   /* .r.:f.|f;.W.u. */
     '80CA0288560280C31073EDBF0200837E16007545'||,   /* .V..s..~..uE */
     '8B461C8B561EB903004940750142BB007EE85F00'||,   /* F.V...I@u.B.~_. */
     '7326B0F84F741D8B463233D2B903003BC8771E8B'||,   /* s&Ot.F23ҹ..;w. */
     '760E3BCE73172BF103461C13561EEBD1730BEB27'||,   /* v.;s.+.F..V.s.' */
     '837E2A007703E9FD02BE7E7DAC9803F0AC84C074'||,   /* ~*.w...~}.t */
     '173CFF7409B40EBB0700CD10EBEEBE817DEBE5BE'||,   /* .<.t.....} */
     '7F7DEBE098CD165E1F668F04CD194156666A0052'||,   /* }.^.f..AVfj.R */
     '5006536A016A108BF460807E020E7504B442EB1D'||,   /* P.Sj.j.`~..u.B. */
     '919233D2F7761891F776184287CAF7761A8AF28A'||,   /* 3v.v.Bv. */
     'E8C0CC020ACCB801028A5640CD13618D64105E72'||,   /* ..̸..V@.ad.^r */
     '0A40750142035E0B4975B4C3031801270D0A4469'||,   /* .@u.B.^.Iu...'..Di */
     '73636F20696E636F72726563746FFF2020200D0A'||,   /* sco incorrecto   ... */
     '4572726F7220452F53FF20202020200D0A43616D'||,   /* Error E/S     ...Cam */
     '62696520656C20646973636F2079207072657369'||,   /* bie el disco y presi */
     '6F6E6520756E61207465636C61202020200D0A00'||,   /* one una tecla    ... */
     '0000494F2020202020205359534D53444F532020'||,   /* ..IO      SYSMSDOS   */
     '205359537E010057494E424F4F5420535953'    )     /*  SYS~..WINBOOT SYS   */

  BootCode2=x2c(''||,
     'FA660FB64610668B4E2466F7E16603461C660FB7'||,   /* f.F.fN$ff.F.f. */
     '560E6603C233C9668946FC66C746F8FFFFFFFFFA'||,   /* V.f.3fF.fF.... */
     '668B462C6683F8020F82CFFC663DF8FFFF0F0F83'||,   /* fF,f...f=.... */
     'C5FC660FA4C210FB5250FA66C1E010660FACD010'||,   /* .f...RPf.f.. */
     '6683E802660FB65E0D8BF366F7E3660346FC660F'||,   /* f.f.^.ff.F.f. */
     'A4C210FBBB00078BFBB90100E8BEFC0F82AAFC38'||,   /* ..........8 */
     '2D741EB10B56BED87DF3A65E741903F983C7153B'||,   /* -t..V}^t...; */
     'FB72E84E75D6585AE8660072AB83C404E964FC83'||,   /* .rNuXZf.r.d. */
     'C4048B75098B7D0F8BC6FA66C1E0108BC76683F8'||,   /* .u.}.f.f */
     '02723B663DF8FFFF0F733366486648660FB64E0D'||,   /* .r;f=...s3fHfHf.N. */
     '66F7E1660346FC660FA4C210FBBB000753B90400'||,   /* ff.F.f.....S.. */
     'E852FC5B0F823DFC813F4D5A750881BF0002424A'||,   /* R.[.=.?MZu...BJ */
     '7406BE807DE90EFCEA0002700003C013D203C013'||,   /* t.}....p..... */
     'D2E81800FA26668B016625FFFFFF0F660FA4C210'||,   /* ..&f.f%....f.. */
     '663DF8FFFF0FFBC3BF007EFA66C1E010660FACD0'||,   /* f=....ÿ.~f.f. */
     '10660FB74E0B6633D266F7F1663B46F874446689'||,   /* .f.N.f3ff;FtDf */
     '46F86603461C660FB74E0E6603C1660FB75E2883'||,   /* Ff.F.f.N.f.f.^( */
     'E30F74163A5E100F83A4FB52668BC8668B462466'||,   /* .t.:^...RffF$f */
     'F7E36603C15A52660FA4C210FB8BDFB90100E8B4'||,   /* f.ZRf...߹.. */
     'FB5A0F829FFBFB8BDAC300000000000000000000'||,   /* .Z............. */
     '0000000000000000000000000000000000000000'||,   /* .................... */
     '0000000000000000000000000000000000000000'||,   /* .................... */
     '0000000000000000000000000000000000000000'||,   /* .................... */
     '0000000000000000000000000000000000000000'||,   /* .................... */
     '0000000000000000000000000000000000000000'||,   /* .................... */
     '0000000000000000'                        )     /* ........             */

return
               /* This defines the 3-sector BootRecord of a FAT32 partition */
Make_BootSec:

  if bootable=1 then
       BS_jmpBoot= x2C('EB5890')
  else BS_jmpBoot= x2C('EB3C90')

  BPB  = BS_jmpBoot      ||  BS_OEMName      ||  BPB_BytsPerSec  ||,
         BPB_SecPerClus  ||  BPB_RsvdSecCnt  ||  BPB_NumFATs     ||,
         BPB_RootEntCnt  ||  BPB_TotSec16    ||  BPB_Media       ||,
         BPB_FATSz16     ||  BPB_SecPerTrk   ||  BPB_NumHeads    ||,
         BPB_HiddSec     ||  BPB_TotSec32    ||  BPB_FATSz32     ||,
         BPB_ExtFlags    ||  BPB_FSVer       ||  BPB_RootClus    ||,
         BPB_FSInfo      ||  BPB_BkBootSec   ||  BPB_Reserved    ||,
         BS_DrvNum       ||  BS_Reserved1    ||  BS_BootSig      ||,
         BS_VolID        ||  BS_VolLab       ||  BS_FilSysType

  if bootable=1 then do
    BootSec1 = BPB || BootCode1 || FATSecSig || Copies(x2c('00'),BPS-512)
    BootSec2 = BootCode2 || FATSecSig || Copies(x2c('00'),BPS-512)
   end
  else do
    BootSec1 = BPB || Copies(x2c('00'),418) || FATSecSig || Copies(x2c('00'),BPS-512)
    BootSec2 = PadBootSec
   end

  FreeClusCnt=((PartSize-txt2nr(BPB_RsvdSecCnt)-(2*FATSz)) % SecPerClus) -1

  FSInfo      = x2c('52526141')        ||,  /* FSI_LeadSig */
                copies(x2c('00'),480)  ||,  /* FSI_Reserved1 = zeros */
                x2c('72724161')        ||,  /* FSI_StrucSig  */
                nr2txt(FreeClusCnt,4)  ||,  /* FSI_Free_Count, now known */
                x2c('03000000')        ||,  /* FSI_Nxt_Free = 3 */
                copies(x2c('00'),12)   ||,  /* FSI_Reserved2 = zeros */
                x2c('000055AA')             /* FSI_TrailSig  */
return

Make_BlankerFile:

 /* Attending to the parameters in the BootRecord we dump to a file the boot */
 /* record itself, the reserved sectors at the beginning of the partition,   */
 /* two blank FATs, and a blank cluster for the root directory, which is by  */
 /* the moment hardcoded to be at the first usable cluster (cluster nr 2)    */
 /* and is therefore adjacent to the second FAT                              */

  filexists = stream(filename,'c','query exists')
  if filexists <> "" then do
    say 'Warning: '||filename||' already exists. Overwrite (Y/N)? '
    do until pos(YesNo,'YN')>0
      parse upper pull YesNo
     end
    if YesNo = 'Y' then do
      '@del "'||filename||'" >NUL'
      filexists = stream(filename,'c','query exists')
      if filexists <> "" then do
        Say 'Warning: could not erase existing file.'
        exit 4
       end
     end
    else
     exit 3
   end

  if debug=1 then do
    Say 'Output file: '||filename
    Say 'Volume serial number: '||sn
    if bootable=1 then say 'Boot code being included in boot record'
    Say PartSize||' sectors = '||(PartSize*BPS)/(1024*1024)||' MB, '||BPS||' bytes per sector'
    Call charout stdout,'Dumping first Boot Record...'
   end

  Call charout filename,BootSec1
  Call charout filename,FSInfo
  Call charout filename,BootSec2
  /* This operation will be performed twice */
  blankersize = 2*(length(BootSec1)+length(FSInfo)+length(BootSec2))

  if debug=1 then do
    say ' Done.'
    Call charout stdout,'Padding bootrecord to reach BKBootSec address...'
   end  
          /* Pad until BkBootSec with boot-marked blank sectors */
  
  do i=1 to txt2nr(BPB_BkBootSec)-3
    call charout filename,PadBootSec
    blankersize = blankersize + length(PadBootSec)
   end

  if debug=1 then do 
    say ' Done.'
    Call charout stdout,'Dumping second Boot Record...'
   end

  Call charout filename,BootSec1
  Call charout filename,FSInfo
  Call charout filename,BootSec2

  if debug=1 then do
    Say ' Done.'
    Call charout stdout,'Padding reserved first sectors...'
   end

  do i=1 to txt2nr(BPB_RsvdSecCnt)-(txt2nr(BPB_bkBootSec)+3)
    call charout filename,PadSector                          /* zero fill */
    blankersize = blankersize + length(PadSector)
   end

  if debug=1 then say ' Done.'

  do i=1 to txt2nr(BPB_NumFATs)  /* Number of FATs */
    EmptyClusPtrCnt=((FATSz*BPS)/4)-txt2nr(BPB_RootClus)-1

    if debug=1 then call charout stdout,'Writing FAT number '||,
                                        i||' = '||EmptyClusPtrCnt||,
                                        ' null cluster pointers...'
    call charout filename,FATFirstClus
    blankersize = blankersize + length(FATFirstClus)
    call charout filename,EOC
    blankersize = blankersize + length(EOC)

    do j=1 to txt2nr(BPB_RootClus)-2
      call charout filename,EmptyClusPtr
      blankersize = blankersize + length(EmptyClusPtr)
     end

    call charout filename,EOC
    blankersize = blankersize + length(EOC)
    call charout filename,copies(EmptyClusPtr,EmptyClusPtrCnt)
    blankersize = blankersize + EmptyClusPtrCnt*length(EmptyClusPtr)

    if debug=1 then say ' Done.'

   end

  DirEntryPerClusCnt=txt2nr(BPB_SecPerClus)*txt2nr(BPB_BytsPerSec)/length(EmptyDirEntry)
  if debug=1 then call charout stdout,'Generating an empty cluster ('||,
                                      DirEntryPerClusCnt||,
                                      ' entries) for root directory...'
  call charout filename,copies(EmptyDirEntry,DirEntryPerClusCnt)
  blankersize = blankersize + DirEntryPerClusCnt*length(EmptyDirEntry)

  if debug=1 then say ' Done.'

  call charout filename

  size=chars(filename)
  call charout filename

  if size = blankersize then do
    if debug=1 then do
      Say FreeClusCnt||' allocation units have been calculated and should be reported as free.'
      Say 'Blanker file is '||size||' bytes = x'||d2x(size/BPS)||' sectors of '||BPS||' bytes.'
     end
   end
  else do
    if debug=1 then do
      Call LineOut stderr,'Blanker file is '||size||' bytes, but it should be '||blankersize||' bytes long.'
      Call LineOut stderr,'Possible cause: not enough space to write the entire file.'
     end
    exit 1
   end

return

/* Useless chunks of code and so on */

DumpBootCode:
 call charout 'BootCod1.bin',BootCode1
 call charout 'BootCod2.bin',BootCode2
return
