/*~ Make disk images */
numeric digits 15
parse arg srcdisk tgtdisk
parse upper source . . ddtfile
ddtfile = reverse(ddtfile)
parse var ddtfile . '.' ddtfile
ddtfile = reverse(ddtfile)'.DDT'
select
  when srcdisk = ''     then call help
  when srcdisk = '/?'   then call help
  when tgtdisk = '/?'   then call help
  when srcdisk = '/??'  then call hint
  otherwise; nop; end

parse upper var srcdisk 1 boot 6  size 9 type
select  /* Same order as in IMGCOPY.DDT */
  when boot = 'BLANK' then bo=1
  when boot = 'PCDOS' then bo=2
  when boot = 'OSTWO' then bo=3
  when boot = 'MSDOS' then bo=4
  when boot = 'MSWIN' then bo=5
  when boot = 'WINNT' then bo=6
  when boot = 'BDOS-' then bo=7
  when boot = 'DRDOS' then bo=8
  when boot = 'NWDOS' then bo=9
  when boot = 'RXDOS' then bo=10
  otherwise call die 'Invalid maker' boot; end

select  /* Same order as in IMGCOPY.DDT */
  when size = '016' then si=1
  when size = '018' then si=2
  when size = '032' then si=3
  when size = '036' then si=4
  when size = '072' then si=5
  when size = '120' then si=6
  when size = '144' then si=7
  when size = '168' then si=8
  when size = '288' then si=9
  otherwise call die 'Invalid size' size; end

select
  when type = '.DSK' then ty = 1
  when type = '.IMG' then ty = 2
  otherwise call die 'Invalid file type' type; end

call makedisk bo, si, ty
exit

xyzzy: ; call die "Nothing Happens" ; return
die:  ;parse arg message; say message; exit; return

help:
say 'ImgCopy makes a blank diskette, as if it were copied from the program'
say ''
say 'Usage:   ImgCopy maker999.ext target.file'
say ''
say 'Where maker is one of the following:'
say '  blank, pcdos, ostwo, msdos, mswin, winnt, bdos-, drdos, nwdos, rxdos'
say ''
say 'Size (999) is one of the following (*10k, or *80ft for size)'
say '  016, 018, 032, 036, 072, 120, 144, 168, 288'
say ''
say 'Type (.ext) is one of the following'
say '  .DSK   Raw diskette'
say '  .IMG   OS/2 Bootable image'
say ''
say 'eg "ImgCopy pcdos018.img dos5.img" will make a blank diskette with a PCDOS 5'
say '    sector, and of size 180k, suitable for use as an OS/2 VM Image'
say ''
say 'If target.file = /!, then the consist of the disk is listed only.'
say 'An option /?? prints a hints screen, listing the OSes for each boot sector'
say 'IMGCOPY.REX  (c) Wendy Krieger 2003'
exit; return

hint:
say 'Different OSes need different boot sectors.  This is a list of the currently'
say 'supported operating systems, by boot sectors.  Even though the boot sector'
say 'might look for a particular OS, it does not mean that the diskette must be'
say 'made to be a boot disk for that system.'; say
say '   BLANK      Non-system disk.  This is useful for a data diskette'
say '   PCDOS      PC-DOS and IBMDOS 3.3x - 7.00, PC-DOS 2000'
say '   MSDOS      MS-DOS 4.00 to 6.22.  Do not use it with DOS 7.0'
say '   MSWIN      Win95 and Win98, these are DOS 7.x'
say '   BDOS-      DR-DOS 3.4x'
say '   DRDOS      DR-DOS, NWDOS and OpenDos 6.x and 7.x'
say '   NWDOS      DR-DOS, NWDOS and OpenDOS 6.x and 7.x'
say '   RXDOS      Real Mode DOS, from the Book Disecting DOS'
say '   OSTWO      OS/2 2.x, 3.x and 4.x'
say '   WINNT      Windoze NT 4.x'; say;
say 'The size reflects current and older sizes.  While a file of this size might'
say 'be made on the system, you might not be able to put the files on a diskette.'
say 'Smaller sizes are suited where the file is loaded into memory, as is the'
say 'case with OS/2 vmdisk images.  Larger sizes are more useful if diskette'
say 'images are being made for diskette imaging.'
say; exit; return

makedisk:
parse arg mk, sz, tp
call getinfo
select
  when tgtdisk = '/!' then call showinfo
  when tgtdisk = ''   then call showinfo
  otherwise call putinfo; end
return


getinfo:
call stream ddtfile, 'c', 'open read'
call stream ddtfile, 'c', 'seek' sz*32+5
  os2hdr = charin(ddtfile,,  8)
  ddtstr = charin(ddtfile,, 16)
  fathdr = charin(ddtfile,,  3)
call stream ddtfile, 'c', 'seek' mk*512+1
  bootsc = charin(ddtfile,, 512)
call stream ddtfile, 'c', 'close'
parse var ddtstr . 6 c1 7 . 11 c2 12 . 13 c3 14 . 15 c4 16 .
parse var os2hdr . 3 c5 4 .
fatsize = c2d(c2)*512; rootdir = c2d(c1)* 32
nrheads = c2d(c4)    ; sectors = c2d(c3); ntracks = c2d(c5)
disksize = nrheads * sectors * ntracks * 512
z1 = fatsize+fatsize+rootdir
z2 = disksize - z1 - 512; z1 = z1/512; z2 = z2/512
select
  when tp = 1 then call leader 1
  when tp = 2 then call leader 9
  otherwise 'Invalid type in getinfo'; end
return

leader:
parse arg offset
return

showinfo:
say 'The requested diskette is of the following type:'
say '   Maker (Boot Sector) ' boot '   ' right(left(bootsc, 11),8)
say '   Size                ' size'0 ' '   ' disksize/1024'k'
say '   Filetype            ' type
say ''
say 'This disk has 'nrheads' heads, 'ntracks' tracks, 'sectors' sectors.'
say ''
say 'Disk consist'
if offset > 1 then say '  A leader segment of' offset-1 'bytes'
say '  The boot sector of 512 bytes'
say '  Two file allocation tables, of size ' fatsize ;
say '  A root directory with 'rootdir/16' entries'
freespace = z2 * 512
say '  Free Space on the diskette '  freespace 'bytes or 'freespace/128 'ft or 'freespace/1024'k.'
say ''
call showhex 'OS/2 header  ', c2x(os2hdr)
call showhex 'DDT Leader   ', c2x(ddtstr)
call showhex '             ', rest
say ''
say 'We will write' z1 'sectors of NULLs and 'z2' of blanks.'
return

showhex:
parse arg title, tail
  xx = title
  do n = 0 to 7
    parse var tail 1 yy 3 tail
    xx = xx yy
    end
  rest = tail
say xx
return

putinfo: /* write the diskette! */
'del' tgtdisk
call stream tgtdisk, 'c', 'open write'
select
  when tp = 2 then call charout tgtdisk, os2hdr
  otherwise; nop; end
call charout tgtdisk, bootsc
s1 = copies('00'x, 512); do n = 1 to z1+4; call charout tgtdisk, s1 ; end
s1 = copies('F6'x, 512); do n = 1 to z2-4; call charout tgtdisk, s1 ; end
call stream tgtdisk, 'c', 'seek' offset+12
call charout tgtdisk, ddtstr
call stream tgtdisk, 'c', 'seek' offset+512
call charout tgtdisk, fathdr
call stream tgtdisk, 'c', 'seek' offset+512+fatsize
call charout tgtdisk, fathdr
call stream tgtdisk, 'c', 'close'
say tgtdisk 'successfully written.'

return



