/*********************************************************/
/* writboot.c: utility to write a floppy boot sector     */
/* Peter Flass <Peter_Flass@Yahoo.com> - June, 2001      */
/* Calling Sequence: writboot A[:] <filename>            */
/*                or writboot B[:] <filename>            */
/*********************************************************/

#include <stdio.h>
#include <string.h>
#define INCL_DOSDEVIOCTL
#define INCL_KBD
#include <os2.h>

main( INT argc, PUCHAR argv[] ) {
   CHAR drive[4];
   HFILE hDrive;
   FILE *boot;
   UCHAR boot_sector[512];
   INT ans;
   ULONG rc, act, len;
   TRACKLAYOUT tl;
   KBDKEYINFO k;
   ULONG l1,l2;
   INT err=0;
   

   /* Validate drive parameter */
   if( argc<3 ) usage( argv[0] );
   if( (strlen(argv[1])<1) || (strlen(argv[1])>2) ) usage( argv[0] ); 
   strcpy( drive, argv[1] );
   if( (strlen(drive)>1) && (drive[1]!=':') ) usage( argv[0] );
   drive[0] = toupper( drive[0] );
   drive[1]=':';
   drive[2]='\0';
   if( (drive[0]!='A') && (drive[0]!='B') )   usage( argv[0] );

   /* Read bootblock file */
   boot = fopen( argv[2], "rb" );
   if( boot==(FILE *)NULL ) {
      fprintf( stderr, "Boot file %s not located\n", argv[2] );
      exit(1);
      }
   if( fread(boot_sector,1,512,boot)!=512 ) {
      fprintf( stderr, "Boot file read error\n" );
      exit(1);
      }
   fclose(boot);
   if( (boot_sector[510]!=0x55) || (boot_sector[511]!=0xAA) ) {
      fprintf( stderr, "Invalid boot file signature %02X%02X\n", 
                       boot_sector[510], boot_sector[511] );
      exit(1);
      }

   /* Write the bootblock */
   fprintf( stderr, "Put disk to be modified in drive %s,\n", drive );
   fprintf( stderr, "  press any key when ready ");
   rc = KbdFlushBuffer( 0 );
   rc = KbdCharIn( &k, IO_WAIT, 0 );
   fprintf( stderr, "\n" );

   rc = DosOpen( drive, &hDrive, &act, 0L, 
                 0,
                 FILE_OPEN, 
                 OPEN_FLAGS_DASD|OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYREADWRITE, 
                 NULL );
   if( rc!=0 ) {
      fprintf( stderr, "DosOpen error %d\n", rc );
      exit(1);
      }

   /* Lock disk device */
   rc = DosDevIOCtl( hDrive, IOCTL_DISK, DSK_LOCKDRIVE, 
                     NULL, 0L, &len, 
                     NULL, 0L, &len );
   if( rc!=0 ) {
      fprintf( stderr, "DosDevIOCtl 00h error %d\n", rc );
      rc = DosClose( hDrive );
      exit(1);
      }

   tl.bCommand=0x00;
   tl.usHead=0;
   tl.usCylinder=0;
   tl.usFirstSector=0;
   tl.cSectors=1;
   tl.TrackTable[0].usSectorNumber=1; /*** DOCUMENTATION SAYS THIS SHOULD BE ZERO!!! ***/
   tl.TrackTable[0].usSectorSize=512;

   rc = DosDevIOCtl( hDrive, IOCTL_DISK, DSK_WRITETRACK,
                      &tl, sizeof(TRACKLAYOUT), &l1,
                      &boot_sector, 512, &l2 );
   if( rc!=0 ) {
      fprintf( stderr, "DosDevIOCtl 44h error %d\n", rc );
      err=1;
      }

   /* Unlock disk device */
   rc = DosDevIOCtl( hDrive, IOCTL_DISK, DSK_UNLOCKDRIVE, 
                     NULL, 0L, &len, 
                     NULL, 0L, &len );
   if( rc!=0 ) {
      fprintf( stderr, "DosDevIOCtl 01h error %d\n", rc );
      err=1;
      }
   
   rc = DosClose( hDrive );

   if( err==0 ) {
      fprintf( stderr, "Boot block successfully written\n" );
      }
   else {
      fprintf( stderr, "Error while writing boot block\n" );
      }

   return;
   }

usage( PUCHAR prog ) {
   fprintf( stderr, "Usage: %s A|B[:] <boot_file>\n", prog );
   exit(1);
   }
