@echo off
rem 27-03-2007 JvW Rename script to 'dfsdproc' to avoid users running it directly (8.14)
rem 09-08-2016 JvW Use 'dfsrunas.exe' to elevate Windows to admin, ignoring explicit window sizes
rem 10-08-2016 JvW Removed write-test and registration-test, does not work with 'dfsrunas'
echo.
echo Generate DFSDISK analysis files

if "%OS%"==""        goto notnt
if "%OS%"=="DOS"     goto notnt
if "%OS%"=="MSDOS"   goto notnt
if "%OS%"=="DRDOS"   goto notnt
if "%OS%"=="IBMDOS"  goto notnt
if "%OS%"=="OPENDOS" goto notnt
if "%OS%"=="FREEDOS" goto notnt

ver | findstr /i /C:"XP [" > nul
if %errorlevel% EQU 0 goto winxpnt
ver | findstr /i /C:"Version 5" > nul
if %errorlevel% EQU 0 goto winxpnt
ver | findstr /i /C:"NT [" > nul
if %errorlevel% EQU 0 goto winxpnt
ver | findstr /i /C:"Version 4" > nul
if %errorlevel% EQU 0 goto winxpnt

echo.
echo Wait until the ANALYSIS procedure in a seperate window has completed ...
set dfsexe=dfsrunas -c -w dfswin.exe
goto dfsee

:winxpnt
set dfsexe=dfswin.exe
goto dfsee

:notnt
set dfsexe=dfsdos.exe

:dfsee
set cmdext=BAT

set disk=*
if "%1" == "?"   goto usage
if "%1" == "/?"  goto usage
if "%1" == "-?"  goto usage
if "%1" == ""    goto work
set disk=%1

:work
%dfsexe% -b -w -t dfsdisk %disk% %2 %3 %4 %5 %6 %7 %8 %9

echo.
echo Check at least one of the resulting files  *.sk*  for obvious errors!
echo                                           -------
echo When needed, fix and run %0 again.                 When it looks OK:
echo.
echo email these file(s) to support@dfsee.com for analysis (ZIP if possible)
echo Include as many details about the disk partitions as you remember.
echo.
goto end

:usage
%dfsexe% dfsdisk -?
echo.
echo You can use the '-screen-' option to the command to prevent
echo the final completion message, requiring manual confirmation.

:end
pause
