/* dencrypt.c for Solitaire-type encryption */
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <math.h>
#define MAX_CHAR_LENGTH 254 /* 127, 256 */
#define MAX_INPUT_SIZE 1022
#define MAX_CALC_SIZE (MAX_INPUT_SIZE*2)

int modulo_sub( int number1, int number2) {
 int resoult;
 if(number1<number2)
  number1=number1+MAX_CHAR_LENGTH;
 resoult = number1-number2;
 return resoult;
}

int hexchartoint(char z) {
 if(z >= '0' && z <= '9')
  return z - '0';
 if(z >= 'A' && z <= 'F')
  return (z - 'A') + 10;
 if(z >= 'a' && z <= 'f')
  return (z - 'a') + 10;
 return 0;
}

int hexstringtoint(char *buf) {
 int n, len=strlen(buf);
 int total=0;
 for(n=0;n<len;n++)
  total += hexchartoint(buf[(len-n)-1]) * (int)pow((long)16,(long)n);
 return total;
}

int main(void) {
 int i,decimal1,decimal2,decimal3;
 unsigned char temp[]="00";
 char origString[MAX_INPUT_SIZE]="", *origstr;
 char keyStream[MAX_INPUT_SIZE]="", *keystm;
 char hexString[MAX_CALC_SIZE]="", hexKeyStream[MAX_CALC_SIZE]="";
 char decrypted[MAX_CALC_SIZE]="";

 printf("Enter text to decrypt: ");
 gets(origString);
 origstr = (char *)malloc(strlen(origString) + 1);
 strcpy(origstr, origString);
 if (strcmp(origString, "") == 0) {
  printf("Error 1: No intput string.\n");
  exit(1);
 }
 printf("Enter key stream: ");
 gets(keyStream);
 keystm = (char *)malloc(strlen(keyStream) + 1);
 strcpy(keystm, keyStream);
 if (strcmp(keyStream, "") == 0) {
  printf("Error 2: No input key stream.\n");
  exit(2);
 }

 if(strlen(origString)!=strlen(keyStream)) {
  printf("Error 3: Inputs don't match.\n");
  exit(3);
 }

 printf("\n\nText to decrypt: %s\nKey stream: %s\n", origstr,keystm);

 while(*origstr) {
  sprintf(temp, "%X",(unsigned char)*origstr++);
  strcat(hexString,temp);
 }
 while(*keystm) {
  sprintf(temp, "%X",(unsigned char)*keystm++);
  strcat(hexKeyStream,temp);
 }

 printf("hexString: %s\nhexKeyStream: %s\n",&hexString,&hexKeyStream);

 for(i=0;hexString[i]!='\0';i++) {

  strxfrm(temp,&hexString[i],2);
  printf("(hex: %s, ",temp);
  decimal1 = hexstringtoint(temp);
  printf("dec: %d)",decimal1);

  strxfrm(temp,&hexKeyStream[i],2);
  printf("(hex: %s, ",temp);
  decimal2 = hexstringtoint(temp);
  printf("dec: %d)",decimal2);

  decimal3 = modulo_sub(decimal1,decimal2);
  printf(", calc: %ld-%ld=%ld, ",decimal1,decimal2,decimal3);

  sprintf(temp,"%x",decimal3);
  printf("hex str: %s, ",temp);
  decimal3 = hexstringtoint(temp);
  sprintf(temp,"%c",decimal3);
  printf("char: %s\n",temp);
  strcat(decrypted,temp);

  i++;
 }

 printf("\n%s\n",decrypted);
 exit(0);
}


