/* cssrss.cmd   -- cssdir /Lrrs option sorted output program */
/* CopyRight (C) 2004 Curtis Systems Software P.C.           */
/* www.curtisSystemSoftware.com                              */
/*                                                           */
/* This program takes a cssdir generated file. It uses can be
   valuable on output that was generated by cssdir.exe while
   having the following options settings of /Lrrs2 or /Lrrs3 or 
   /Lrrs4 and /Lxrst:0 (dir summary report type summaries).
   (If you run it on /Lxrst:1 request type summaries its not
   very valuable and the verbose mode may NOT reflect the
   correct titles following ***Group:., Also if you use this
   utility on output generated by /Lxpo:ar /Lxpo:dr it may
   have the wrong group info if /Lrsl was used)
   The input file given to cssrss.cmd is expected to have
   the following characteristics:
   any lines that start with 's>>' are expected to have fields:
     [entries/] dirs / files /  easizeBytes / filesizeBytes [hintString]/filespec
   followed by the field you wish sorted, place a '-' to do a 
   descending ordering.

   SEE USAGE SECTION OR SIMPLY INVOKE 'CSSRSS' TO GET BASIC HELP

   Invocation example: will sort size field in ascending order
   cssrss  driveF  S

   Invocation example: will sort easize field in descending order
   cssrss  driveF  -Z

 WARNING: if you process the output of cssrss as input again, you
 may get incorrect fields and formatting because of the K or M values that
 eabytes and/or file bytes fields may contain, it is advised that you DO NOT
 do such operations at ALL.
 i.e.  cssrss infile d > out 
 followed by
       cssrss out d  > out2

 cssrss does look for simple cases and gives a fatal warning and aborts

 dependencies: need rexxutil.dll and also a version that include sysStemsort()
*/
version    = "1.17"
versionStr = "cssrss version" version "Copyright 2004 Curtis Systems Software P.C."
label      = "     #dirs/    #files/   file eaBytes/       file bytes hint/filespec"
labelIndent= "   "
label.1 =labelIndent||"    #entries/"||label
label.2 =labelIndent||label
label.1.N = "0 ,(none)"
label.1.E = "5 ,#entries"
label.1.D = "17,#dirs"
label.1.F = "28,#files"
label.1.Z = "39,#eaBytes"
label.1.S = "55,#fileBytes"
label.2.N = "0 ,(none)"
label.2.E = "0 ,(none)"
label.2.D = "4 ,#dirs"
label.2.F = "15,#files"
label.2.Z = "26,#eaBytes"
label.2.S = "42,#fileBytes"

parse upper arg infile inSortby inVerbose
infile = strip(infile)
verbose = strip(inVerbose)
if (verbose == "V") then verbose = 1
else do
   if (verbose == "") then verbose = 0
   else signal usage
end

if (lines(infile) == 1) then signal continue
if (infile <> "") then do
   say 
   say "*** infile:"infile  "has no data or is invalid"
   say
end

usage:
   say versionStr
   say
   say "usage: cssrss infile [-][E|D|F|Z|S|N] [ V]"
   say
   say "legend follows:"
   say "   infile is cssdir generated file"
   say "   E = order by num of   entries field (if avail)"
   say "   D = order by num of     Dirs  field"
   say "   F = order by num of     files field"
   say "   Z = order by eaSize     bytes field"
   say "   S = order by fileSize   bytes field (default)"
   say "   N = leave as found"
   say "   - preceding above option will reverse order"
   say "   also can append ' V' for verbose output"
   exit 1
   return

continue:
sortby = strip(inSortby)
if (sortby == "") then sortBy = "S"
if (sortby == "-") then sortBy = "-S"

orderDir = "A"
if (left(sortby,1) == "-") then do
   orderDir = "D"
   sortby = substr(sortby,2)
end

if ((pos(sortby,"EDFZSN") == 0) | (length(sortby) > 1)) then do
   say "cssrss illegal invocation usage"
   say
   signal usage
end

say VersionStr 
say "cssrss" infile inSortby inVerbose

if rxfuncquery('sysloadfuncs') then do
   if rxfuncadd('sysloadfuncs', 'rexxutil', 'sysloadfuncs') then do
      say "fatal error: couldn't load rexxutil library."
      exit 3
   end
   if (verbose == 1) then do
      say "calling sysloadfuncs"
   end
   call sysloadfuncs
end

infile  = strip(infile)
if (verbose == 1) then do
   say
   say "ordering file:'"infile"' on" date() time()
   say
end
x = time("E")

totalGroups = 0
veryFirst = 1
group. = ""; group.0 = 0

do forever
   line = getStart(infile); 
   if (substr(line,4,1) == "*") then reportType = 1
   else                              reportType = 2

   if (wordpos(left(line,3),"GT>") > 0) then do
      say parse_s_t(line) 
      iterate
   end

   veryFirst = 0
   if (line == "*") then leave
   first = 1
   sorts. = ""
   cnt = 0
   do forever
      if (first == 0) then do
         if (lines(infile) == 0) then leave
         line = strip(linein(infile),"L")
      end
      else first = 0
      if (left(line,3) <> "s>>") then do
         if (wordpos(left(line,3),"T>> t>> gt> GT>") == 0) then iterate
         totalLine = parse_s_t(line) 
         leave
      end

      cnt = cnt + 1
      sorts.cnt = parse_s_t(line) 
   end

   if (cnt == 0) then do
      if (left(totalLine,3) <> "t>>") then iterate
   end
   totalGroups = totalGroups + 1
   sorts.0 = cnt
   sortpos = left(label.reporttype.sortby,2)
   if ((sortpos <> 0) & (cnt <> 0)) then do
      rc = SysStemSort(sorts,orderDir,,,,sortpos)
   end

   say
   tmpOut = "****Group:"totalGroups 
   if (group.totalGroups <> 0) then tmpOut = tmpOut group.totalGroups
   say tmpOut
   if (orderDir == "D") then do
      say "orderedBy:"substr(label.reportType.sortby,4) "(descending) sortpos:"sortpos
   end
   else do
      say "orderedBy:"substr(label.reportType.sortby,4) "(ascending)  sortpos:"sortpos
   end
   say

   say label.reportType
   do i = 1 to cnt
      say sorts.i
   end
   say totalLine; 
   if (left(totalLine,3) <> "t>>") then say label.reportType
   say
end

say "TotalGroups Processed:" totalGroups "elasped time:"format(time("E"),3,2)
if (verbose == 1) then say "Finishing at" date() time()
say copies("*",80)
say
exit 0

getStart: procedure expose veryFirst group. verbose
   parse arg infile 
   do while(lines(infile))
      line = strip(linein(infile),"L")
      if (left(line,3) <> "s>>") then do
         if (left(line,3) <> "t>>") then do
            if (left(line,3) <> "GT>") then do
               if (veryFirst == 1) then do
                  if (left(line,7) == "sl> ++[") then do
                     cnt = group.0; cnt = cnt + 1; group.cnt = substr(line,7); group.0 = cnt
                     if (verbose == 1) then say group.cnt
                  end
               end
               if (substr(line,3,1) == ">") then do
                  if (left(line,3) <> "sl>") then do
                     if (left(line,3) <> "Pt>") then do
                        say line
                     end
                  end
               end
               iterate
            end
         end
      end
      return(line)
   end
return "*"

handleGT: 
   parse arg type,line
   temp = "gt>*"
   if (type == "*") then do
      if (pos("gt>*",line) > 0) then temp = "gt>*"; else temp = "GT>*"
      parse var line typeTotal (temp) entries "/" dirs "/" files "/" eabytes "/" rest
      alignLine = typeTotal||temp right(strip(entries),10)"/"
  end
  else do
      if (pos("gt>",line) > 0) then temp = "gt>"; else temp = "GT>"
      parse var line typeTotal (temp) dirs "/" files "/" eabytes "/" rest
      alignLine = typeTotal||temp
  end
  return

parse_s_t: procedure 
   parse arg line
   tackon = ""
   if (pos(">*",line) > 0) then do
      if (pos(">>*",line) >1) then do
         parse var line typeTotal ">>*" entries "/" dirs "/" files "/" eabytes "/" rest
         alignLine = typeTotal||">>*" right(strip(entries),10)"/"
      end
      else do
        call handleGT "*",line
      end
   end      
   else do
      if (pos(">>",line) > 0) then do
         parse var line typeTotal ">>" dirs "/" files "/" eabytes "/" rest
         alignLine = typeTotal||">>" 
      end
      else do
        call handleGT "",line
      end
   end
   eabytes = strip(eabytes)
   eabytes = checkKM(eabytes,12) /* also modifies rest */

   parse var rest size rest2

   rest = strip(rest2,"L"); 

   size = strip(size)
   size = checkKM(size,14)  /* also modifies rest */
   
   if (strip(rest) <> "") then do
      tackon = ""
      if (left(strip(rest),3) <> "T>>") then do
         parse var rest "[" hint "]" filespec
         tackon = "["hint"]" filespec
      end
      tackon = rest
   end

   alignLine = alignLine || right(strip(dirs),10)"/"right(strip(files),10)"/"||,
                              right(strip(eabytes),15)"/"right(strip(size),17) tackon
   return(alignLine)

checkKM: procedure expose line rest
   parse arg bytes, width
   if (datatype(left(bytes,1)) <> "NUM") then do
      say "fatal error processing:'"line"'"
      say "eaBytes or file bytes fields contains a leading non digit:'"left(bytes,1)"'"
      say bytes
      say width
      exit 2
   end

   rest = strip(rest,"L"); suffixChar = right(bytes,1)
   if ((suffixChar == "K") | (suffixChar == "M")) then do
      bytes = suffixChar"_ "||right(strip(bytes),width)
   end
   return bytes
