/* FATsort.cmd - FAT files sorting program */

options etmode
options exmode
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

arg dirName sortOption remainData

if dirName = '' | dirName = '/?' | remainData \= '' then
do
   say 'Syntax: FATsort directory [option]'
   say 'This program sorts directory entries on FAT drives.'
   say 'Options for ''DIR /o'' are available.'
   exit
end

if right(dirName, 1) \= '\' then dirName = dirName || '\'
if substr(dirName, 2, 1) = ':' then
do
   driveName = left(dirName, 2)
   dirName = substr(dirName, 3)
end
else driveName = ''


/* create temporary file and directory */

tempDirCreated = 0
do i = 0 to 999
   tempDir = '\FATsortD.' || i
   if SysMkDir(driveName || tempDir) = 0 then
   do
      tempDirCreated = 1
      leave
   end
end

if tempDirCreated = 0 then
do
   say 'Error: Cannot create temporary directory.'
   exit
end

tempFile = SysTempFileName('\FATsort.???')
if tempFile \= '' then signal on halt name ExitRoutine
else
do
   say 'Error: Cannot create temporary file.'
   call SysFileDelete tempFile
   call SysRmDir driveName || tempDir
   exit
end


/* get file list */

if sortOption = '' then sortOption = 'n'

'@dir /b /o'sortOption '"'driveName || dirName'" >' tempFile
if rc \= 0 then
do
   call SysFileDelete tempFile
   call SysRmDir driveName || tempDir
   exit
end


/* move files */

do while lines(tempFile) \= 0
   listedFile = linein(tempFile)
   if translate(dirName || listedFile) \= translate(tempDir) then
   do
      '@move "'driveName || dirName || listedFile'"' tempDir'\. > nul'
      say 'Moved:' listedFile
   end
end


/* restore files */

call linein tempFile, 1, 0
do while lines(tempFile) \= 0
   listedFile = linein(tempFile)
   if translate(dirName || listedFile) \= translate(tempDir) then
   do
      '@move "'driveName || tempDir'\'listedFile'"' '"'dirName || '." > nul'
      say 'Recovered: 'listedFile
   end
end

ExitRoutine:
call stream tempFile, 'command', 'close'
call SysFileDelete tempFile
call SysRmDir driveName || tempDir
exit 0
