/* BYTES.CMD       REXX CMD by Gord Snider  v1.0  2003/02/02 */
/* PURPOSE: shows the number of bytes occupied by a branch of a directory tree.

   SYNTAX:  BYTES subdirectory | * [switches]
       or   BYTES /?

       where subdirectory is the unqualified name of a subdirectory in the 
             current directory,
          or * is a literal, means all subdirectories of the current directory
             plus files in the current directory,
             (i.e. to check your whole hard drive make the root the current 
             directory and use the '*' argument.)  

          /D switch lists each subdirectory included, 
          /F switch lists each file found in the branch,
          /? switch produces a help screen and then exits.
*/
if LRU() then exit
parse arg subdir . '/' switches
switches = translate(switches)

if pos('?', switches) > 0 | subdir = '' then do                       /* check for help request */
    do l = 1 until substr(sourceline(l), 1, 2) = '*/'
      say sourceline(l)
    end l
  exit
  end  /* if */

allbytes = 0
allfiles = 0
testword = ''
  
say
current = directory()                                /* save fully qualified current directory for return */
       
if subdir = '*' 
   then call next directory()
   else do
      call SysFileTree '*', 'test.', 'DO'
      do i = 1 to test.0
         testword = testword test.i 
      end i
        if pos(current || '\' || subdir, testword) > 0 then do
              subdir = current || '\' || subdir 
              call next subdir
              end
           else do
              say 'Argument must be an unqualified subdirectory of the current directory, or ''*''.'
              exit
              end
        end

call directory(current)
say
say 'Total files:' commas(allfiles) ' Total bytes:' commas(allbytes)  
exit 0

next: procedure expose allbytes switches current allfiles   /* hide old set of variables, enable new set */
parse arg nextdir
call directory nextdir                                   /* make the passed directory the current directory */
if pos('D', switches) > 0 then say nextdir

call SysFileTree '*', 'files.', 'F'                      /* any files stored in compound variable list */
do file = 1 to files.0                                   /* make a loop to process list */
   parse var files.file 1 date 9 . 11 time 17 . 19 size 29 . 31 attrib 36 . 38 thisfile
   if pos('F', switches) > 0 then say attrib size date time thisfile
   allfiles = allfiles + 1
   allbytes = allbytes + size
end file

call SysFileTree '*', 'dirs.', 'DO'                      /* any subfolders stored in compound variable list */
do dir = 1 to dirs.0                                     /* make a loop to process list of directories */
  call next dirs.dir                                     /* pivot point of the recursion */
  call directory ..                                      /* step back to parent to delete child */
end dir                                                  /* back to top of dir loop */

return                                                   /* a leaf has been reached */

commas: procedure 
arg input
output = ''
reversed = reverse(input)
do while length(reversed) > 0
   parse var reversed 1 part 4 reversed
   partfwd = reverse(part)
   if length(reversed) > 0 then partfwd = ','partfwd
   output = partfwd || output 
end /* do */
return output
