/* REXX: lower.cmd */

/* Author:  Kai Uwe Rommel <rommel@ars.muc.de>
 * Created: Nov-01-1994
 *
 * $Id: lower.cmd,v 1.1 1994/11/18 09:58:25 rommel Exp $
 * $Revision: 1.1 $
 */

/*
 * $Log: lower.cmd,v $
 * Revision 1.1  1994/11/18 09:58:25  rommel
 * Initial revision
 * 
 */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Arg args

If args='' Then Do
  Say
  Say 'Usage: lower [-slu] <arg> ...'
  Say
  Say '       -s  include subdirectories'
  Say '       -q  do not print progress messages'
  Say '       -l  translate to lower case (default)'
  Say '       -u  translate to upper case instead'
  Say
  Say 'Options can be intermixed with arguments.'
  Exit
End

option = ''
type = 'L'
echo = 'V'

Do i=1 To Words(args)

  opt = Word(args, i)

  Select
    When Left(opt, 2) = '-Q' | Left(opt, 2) = '/Q' Then
      echo = 'Q'
    When Left(opt, 2) = '-S' | Left(opt, 2) = '/S' Then
      option = 'S'
    When Left(opt, 2) = '-L' | Left(opt, 2) = '/L' Then
      type = 'L'
    When Left(opt, 2) = '-U' | Left(opt, 2) = '/U' Then
      type = 'U'
    Otherwise
      Call dirs opt, option, type, echo
  End

End

Exit

dirs: Procedure 
  Arg pattern, option, type, echo

  Call files pattern, type
  
  If option = 'S' Then Do

    Call SysFileTree '*', 'dir', 'DO'option
  
    Do i=1 To dir.0
      
      If echo = 'V' Then
	Say 'Processing: 'dir.i
    
      If option = 'S' then
	Call files dir.i'\'pattern, type

    End 
    
  End 

Return

files: Procedure
  Arg pattern, type
  
  Call SysFileTree pattern, 'file', 'O'
    
  Do i=1 To file.0
    
    base = FileSpec('Name', file.i);

    If type = 'L' Then
      new = Translate(base, XRange('a', 'z'), XRange('A', 'Z'))
    Else
      new = Translate(base)

    If new \= base Then
      '@rename "'file.i'" "'new'"' 
  
  End

Return

/* end of lower.cmd */
