#include <stdio.h>
#include <string.h>

#ifdef VMS
#include <stat.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include <stdlib.h>

#include "window.h"
#include "file.h"  
#include "display.h"  
#include "line.h"
#include "most.h"  
#include "sysdep.h"
  
#ifndef MOST_HELP_USE_DOC
/* This section provided by Mats Akerberg (mats@efd.lth.se) */
  
static char *help[] = {
"SPACE,^D,D,d        *Scroll down one Screen.",
"RETURN, DOWN        *Move forward one line.",
"u,U,^U, DELETE      *Move Up one screen.",
"UP                  *Move up one line.",
"R, r, ^R             Redraw Screen.",
"T,t                  Top of File.",
"B,b                  Bottom of file.",
"RIGHT                Scroll Screen Left (to view lines right of right margin)",
"LEFT                 Scroll Screen Right (To view lines left of left margin)",
"F,f,/               *Find forward",
"?                   *Find Backward",
"n,N                 *Find next in current search direction.",
"J,j,g,G              Goto line.",
"%                    Goto percent.",
"q,Q                  Quit MOST.",
":N,:n                Quit this file and view next.",
"^X2,^W2              Split window",
"^X1,^W1              Make only one window.",
"o,O,^Xo,^Wo          Move to other window.",
" *Note:  This command may be repeated `n' times By entering a number then",
"        the command key, e.g.,  '5 SPACE' moves 5 screens forward.",
NULL };

void do_help_command()
{
    int i,ct;
    char *beg, *end;
    char line[80];
    char attr[80];
    
    i = 1;
    ct = 0;
    set_scroll_region(1,SCREEN_HEIGHT);
    cls();
    while( i<SCREEN_ROWS)
      {
          if( help[ct]!=NULL)
            {
                beg = help[ct];
                end = (help[ct] + strlen(help[ct++]));
                analyse_line((unsigned char *) beg, (unsigned char *) end, line, attr);
                output(line,end - beg,attr,'$');
	       tt_putchar('\n');
	       i++;
            }
          else
            {
		tt_reverse_video();
                send_string_to_term("Press any key to continue.");
	       tt_normal_video();
		getkey();
                redraw_display();
		return;
            }
      }
}

#else
void do_help_command()
{
   char *helpfile, *buf_name;

    buf_name = "*help*";
    helpfile = getenv("MOST_HELP");
    if (helpfile == NULL)
      {
	 static char tempname[255];     /* L_tmpnam */
	 struct stat statb;

	 head(MOST_PROGRAM, tempname);
	 strcat(tempname, "most.doc");
	 if (0 == stat(tempname, &statb))
	   {
	      helpfile = tempname;
	   }
      }
   if (helpfile != NULL)
     {
	if (file_visible(buf_name)) return;
	if (!split_window())
	  {
	     message("Two many windows.",1);
	     return;
	  }
	update_status(1);  /* create status line of prev. window */
	other_window(1);
	(void) find_file(helpfile);
	strcpy(BUF->file,buf_name);
	window_buffer();
	redraw_window();
	update_status(1);
     }
   else
     {
	message("You must set the environment variable 'MOST_HELP' to point to the help file.",1);
     }
}       
#endif

