#ifndef _DAVIS_WINDOW_H_
#define _DAVIS_WINDOW_H_
#include "buffer.h"

struct Window_Type
  {
      unsigned char *beg_pos;   /* buffer pos of top line */
      int beg_line;             /* line number of top */
      int curs_line;            /* line number of curs pos */
      int curs_col;             /* column number of curs pos */
      unsigned char *curs_pos;  /* pos of curs pos */
      int col;                  /* column offset */
      int n_lines;              /* number of lines of buffer (mode dependent) */
      int top;                  /* screen location of top */
      int bot;                  /* screen location of bot */
      int display;              /* value of MOST_S_OPT for selective display */
      char *status;             /* status line */
      Buffer *buf;              /* buffer structure in window */
      struct Window_Type *next; /* next window */
      struct Window_Type *prev; /* prev window */
      int flags;                /* Squeeze lines, etc.. */
      int lock;                 /* true if locked */
  };
typedef struct Window_Type Window;

extern Window *WIN;
extern Window *TOP_WIN;
extern int COLUMN;
extern int CURS_ROW;
extern int CURS_COL;
extern unsigned char *CURS_POS;
extern int RESTORE_WIDTH_TO;
extern void update_window(int); /* moves window to have arg lines on the top */
extern void update_status(int);
extern void redraw_window(void);    /* redraws window updating the structure */
extern void clear_window(void);
extern void window_buffer(void);
extern void init_display(void);
extern void reset_display(void);
extern void other_window(int);
extern void toggle_lock(void);
extern void set_window(Window *);
extern void update_windows(int);
extern void message(char *, int);
extern void put_message(void);
extern void clear_minibuffer(void);
extern void free_window_buffer(void);
extern void select_minibuffer(void);
extern void exit_minibuffer(void);
extern int read_from_minibuffer(char *, char *);
extern void redraw_display(void);
extern void one_window(void);
extern void two_windows(void);
extern void delete_window(void);
extern void save_win_flags(Window *);
extern int split_window(void);
#endif

