/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crcitgen - generate a CCITT CRC lookup table.  This is NOT the   */
/*  CRC suitable for use by xmodem, and is not the CRC-16.           */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>

static unsigned int crcit_tab[256];

#define crcit_update(crc, ch) \
    ((crc) = ((crc) >> 8) ^ crcit_tab[(ch) ^ ((crc) & 0xff)])

int main(void)
{
  unsigned int x;
  unsigned int y;
  unsigned int crc;
  
  for (x=0;x<256;x++)
  {
    y = (x ^ (x << 4)) & 0xffU;
    crcit_tab[x] = ((y << 8) ^ (y << 3) ^ (y >> 4)) & 0xffffU;
  }
  
  for (x=0;x<32;x++)
  {
    printf(" ");
    for (y=0;y<8;y++)
    {
      printf("0x%0.4XU, ",crcit_tab[x*8+y]);
    }
    printf("\n");
  }
  printf("crc['M'] is %x\n",crcit_tab[77]);
  crc = 0;
  crcit_update(crc, 'M');
  printf("crc is %x\n",crc);
  crc = 0;
  for (x=0;x<3;x++)
  {
    crcit_update(crc, "THE"[x]);
  }
  printf("crc is %x\n",crc);
  return (0);
}
