/*
 * qpager.h - Definitions for Quick Pager
 */

#ifndef _QPAGER_H
#define _QPAGER_H

#define VERSION "2.3"

extern  PSZ progName ;

/*
 * Kanji Code
 */

#define ENC_SJIS    0
#define ENC_JIS7    1
#define ENC_EUC     2
#define ENC_UTF8    3

int     kanjiAssume(PUCHAR p) ;                     /* Assume Kanji Code    */
int     kanjiConv(PUCHAR sp, PUCHAR dp, int code) ; /* Convert Kanji Text   */

/*
 * Files & Lines
 */

typedef struct _FileRec *FILEPTR ;
typedef struct _LineRec *LINEPTR ;

typedef struct _LineRec {
    LINEPTR     prev  ;         /* Link to Previous line    */
    LINEPTR     next  ;         /* Link to Next     line    */
    PSZ         line  ;         /* Line Data (raw)          */
    int         code  ;         /* Assumed Kanji Code       */
    LONG        nline ;         /* Line Number              */
} LINEREC ;

typedef struct _FileRec {
    FILEPTR     prev  ;         /* Link to Previous File        */
    FILEPTR     next  ;         /* Link to Next     File        */
    PSZ         name  ;         /* File Name                    */
    FILE        *fp   ;         /* File Pointer                 */
    int         stat  ;         /* I/O Status                   */
    BOOL        stop  ;         /* Flag to Stop Reading         */
    LONG        nline ;         /* Number of Lines              */
    HMTX        mutex ;         /* MUTEX Sem. to access Lines   */
    LINEREC     lines ;         /* Lines in this File           */
    LINEPTR     curln ;         /* Current Line (top on screen) */
} FILEREC ;

#define IO_INIT     0           /* Initial Status   */
#define IO_READ     1           /* Now Reading      */
#define IO_DONE     2           /* Completed        */
#define IO_ERROR    3           /* Found an Error   */

/*
 * Manipulate Lines
 */

int     linesInit(FILEPTR fptr) ;
int     linesDone(FILEPTR fptr) ;
int     linesAppend(FILEPTR fptr, PSZ line) ;
LINEPTR linesTop(FILEPTR fptr) ;
LINEPTR linesBot(FILEPTR fptr) ;
LINEPTR linesPrev(FILEPTR fptr, LINEPTR lp) ;
LINEPTR linesNext(FILEPTR fptr, LINEPTR lp) ;
void    linesFill(void *arg) ;

/*
 * Manipulate Files
 */

int     filesInit(void) ;
int     filesDone(void) ;
int     filesAppend(PUCHAR name, FILE *fp) ;
FILEPTR filesTop(void) ;
FILEPTR filesBot(void) ;
FILEPTR filesPrev(FILEPTR fptr) ;
FILEPTR filesNext(FILEPTR fptr) ;
void    filesFill(FILEPTR fptr) ;

/*
 * Display Text
 */

int     dispLine(int i, LINEPTR p, BOOL disp) ;
int     dispStat(FILEPTR fptr) ;
int     dispPage(FILEPTR fptr) ;
BOOL    dispEof(FILEPTR fptr)  ;
BOOL    dispFull(FILEPTR fptr) ;

/*
 * Quick Pager Commands - Move Around Files
 */

FILEPTR cmdDispAgain(FILEPTR fptr) ;
FILEPTR cmdHelp(FILEPTR fptr) ;

FILEPTR cmdFileTop(FILEPTR fptr) ;
FILEPTR cmdFileBot(FILEPTR fptr) ;
FILEPTR cmdFilePrv(FILEPTR fptr) ;
FILEPTR cmdFileNxt(FILEPTR fptr) ;

FILEPTR cmdTextTop(FILEPTR fptr) ;
FILEPTR cmdTextBot(FILEPTR fptr) ;
FILEPTR cmdPageUp(FILEPTR fptr)  ;
FILEPTR cmdPageDn(FILEPTR fptr)  ;
FILEPTR cmdLineUp(FILEPTR fptr)  ;
FILEPTR cmdLineDn(FILEPTR fptr)  ;
FILEPTR cmdHalfUp(FILEPTR fptr)  ;
FILEPTR cmdHalfDn(FILEPTR fptr)  ;

/*
 * Quick Pager Commands - Search
 */

FILEPTR cmdSearchForw(FILEPTR fptr) ;
FILEPTR cmdSearchBack(FILEPTR fptr) ;
FILEPTR cmdGotoLine(FILEPTR fptr) ;

/*
 * Quick Pager Commands - Save
 */

FILEPTR cmdSaveDisp(FILEPTR fptr) ;
FILEPTR cmdSaveFile(FILEPTR fptr) ;

#endif  /* _QPAGER_H */
